/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODataSegmentStrategy;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseWrapperAbstract;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.dictionary.ODictionary;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.OMetadata;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabaseRecordWrapperAbstract<DB extends ODatabaseRecord>
extends ODatabaseWrapperAbstract<DB>
implements ODatabaseComplex<ORecordInternal<?>> {
    public ODatabaseRecordWrapperAbstract(DB iDatabase) {
        super(iDatabase);
        iDatabase.setDatabaseOwner(this);
    }

    @Override
    public <THISDB extends ODatabase> THISDB create() {
        this.checkSecurity("database", ORole.PERMISSION_CREATE);
        return super.create();
    }

    @Override
    @Deprecated
    public void delete() {
        this.drop();
    }

    @Override
    public void drop() {
        this.checkOpeness();
        this.checkSecurity("database", ORole.PERMISSION_DELETE);
        super.drop();
    }

    @Override
    public int addCluster(String iType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        this.checkSecurity("database", ORole.PERMISSION_UPDATE);
        return super.addCluster(iType, iClusterName, iLocation, iDataSegmentName, iParameters);
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iType, Object ... iParameters) {
        return super.addCluster(iType.toString(), iClusterName, null, null, iParameters);
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        this.checkSecurity("database", ORole.PERMISSION_UPDATE);
        this.checkClusterBoundedToClass(this.getClusterIdByName(iClusterName));
        return super.dropCluster(iClusterName);
    }

    @Override
    public boolean dropCluster(int iClusterId) {
        this.checkSecurity("database", ORole.PERMISSION_UPDATE);
        this.checkClusterBoundedToClass(iClusterId);
        return super.dropCluster(iClusterId);
    }

    @Override
    public int addDataSegment(String iName, String iLocation) {
        this.checkSecurity("database", ORole.PERMISSION_UPDATE);
        return super.addDataSegment(iName, iLocation);
    }

    @Override
    public boolean dropDataSegment(String iName) {
        this.checkSecurity("database", ORole.PERMISSION_UPDATE);
        return super.dropDataSegment(iName);
    }

    @Override
    public OTransaction getTransaction() {
        return ((ODatabaseRecord)this.underlying).getTransaction();
    }

    @Override
    public void replaceStorage(OStorage iNewStorage) {
        ((ODatabaseRecord)this.underlying).replaceStorage(iNewStorage);
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> begin() {
        return ((ODatabaseRecord)this.underlying).begin();
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> begin(OTransaction.TXTYPE iType) {
        return ((ODatabaseRecord)this.underlying).begin(iType);
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> begin(OTransaction iTx) {
        return ((ODatabaseRecord)this.underlying).begin(iTx);
    }

    @Override
    public boolean isMVCC() {
        this.checkOpeness();
        return ((ODatabaseRecord)this.underlying).isMVCC();
    }

    @Override
    public <RET extends ODatabaseComplex<?>> RET setMVCC(boolean iValue) {
        this.checkOpeness();
        return (RET)((ODatabaseRecord)this.underlying).setMVCC(iValue);
    }

    public boolean isValidationEnabled() {
        return ((ODatabaseRecord)this.underlying).isValidationEnabled();
    }

    public <RET extends ODatabaseRecord> RET setValidationEnabled(boolean iValue) {
        return (RET)((ODatabaseRecord)this.underlying).setValidationEnabled(iValue);
    }

    @Override
    public OUser getUser() {
        return ((ODatabaseRecord)this.underlying).getUser();
    }

    @Override
    public OMetadata getMetadata() {
        return ((ODatabaseRecord)this.underlying).getMetadata();
    }

    @Override
    public ODictionary<ORecordInternal<?>> getDictionary() {
        return ((ODatabaseRecord)this.underlying).getDictionary();
    }

    public byte getRecordType() {
        return ((ODatabaseRecord)this.underlying).getRecordType();
    }

    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName) {
        return ((ODatabaseRecord)this.underlying).browseCluster(iClusterName);
    }

    public <REC extends ORecordInternal<?>> ORecordIteratorCluster<REC> browseCluster(String iClusterName, Class<REC> iRecordClass) {
        return ((ODatabaseRecord)this.underlying).browseCluster(iClusterName, iRecordClass);
    }

    @Override
    public <RET extends OCommandRequest> RET command(OCommandRequest iCommand) {
        return ((ODatabaseRecord)this.underlying).command(iCommand);
    }

    @Override
    public <RET extends List<?>> RET query(OQuery<? extends Object> iCommand, Object ... iArgs) {
        return ((ODatabaseRecord)this.underlying).query(iCommand, iArgs);
    }

    @Override
    public <RET> RET newInstance() {
        return ((ODatabaseRecord)this.underlying).newInstance();
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> delete(ORID iRid) {
        ((ODatabaseRecord)this.underlying).delete(iRid);
        return this;
    }

    @Override
    public ODatabaseComplex<ORecordInternal<?>> delete(ORecordInternal<?> iRecord) {
        ((ODatabaseRecord)this.underlying).delete(iRecord);
        return this;
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecordId));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecordId, iFetchPlan));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORID iRecordId, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecordId, iFetchPlan, iIgnoreCache));
    }

    public <RET extends ORecordInternal<?>> RET getRecord(OIdentifiable iIdentifiable) {
        return ((ODatabaseRecord)this.underlying).getRecord(iIdentifiable);
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecord));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecord, iFetchPlan));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET load(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).load(iRecord, iFetchPlan, iIgnoreCache));
    }

    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).reload(iRecord, null, true));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET reload(ORecordInternal<?> iRecord, String iFetchPlan, boolean iIgnoreCache) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).reload(iRecord, iFetchPlan, iIgnoreCache));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).save(iRecord));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).save(iRecord, iClusterName));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).save(iRecord, iMode, iCallback));
    }

    @Override
    public <RET extends ORecordInternal<?>> RET save(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        return (RET)((ORecordInternal)((ODatabaseRecord)this.underlying).save(iRecord, iClusterName, iMode, iCallback));
    }

    @Override
    public void setInternal(ODatabase.ATTRIBUTES attribute, Object iValue) {
        ((ODatabaseRecord)this.underlying).setInternal(attribute, iValue);
    }

    public boolean isRetainRecords() {
        return ((ODatabaseRecord)this.underlying).isRetainRecords();
    }

    public ODatabaseRecord setRetainRecords(boolean iValue) {
        ((ODatabaseRecord)this.underlying).setRetainRecords(iValue);
        return (ODatabaseRecord)((Object)this);
    }

    @Override
    public ORecordInternal<?> getRecordByUserObject(Object iUserObject, boolean iCreateIfNotAvailable) {
        if (this.databaseOwner != this) {
            return this.getDatabaseOwner().getRecordByUserObject(iUserObject, false);
        }
        return (ORecordInternal)iUserObject;
    }

    @Override
    public void registerUserObject(Object iObject, ORecordInternal<?> iRecord) {
        if (this.databaseOwner != this) {
            this.getDatabaseOwner().registerUserObject(iObject, iRecord);
        }
    }

    @Override
    public void registerUserObjectAfterLinkSave(ORecordInternal<?> iRecord) {
        if (this.databaseOwner != this) {
            this.getDatabaseOwner().registerUserObjectAfterLinkSave(iRecord);
        }
    }

    @Override
    public Object getUserObjectByRecord(OIdentifiable iRecord, String iFetchPlan) {
        if (this.databaseOwner != this) {
            return this.databaseOwner.getUserObjectByRecord(iRecord, iFetchPlan);
        }
        return iRecord;
    }

    @Override
    public boolean existsUserObjectByRID(ORID iRID) {
        if (this.databaseOwner != this) {
            return this.databaseOwner.existsUserObjectByRID(iRID);
        }
        return false;
    }

    public <DBTYPE extends ODatabaseRecord> DBTYPE checkSecurity(String iResource, int iOperation) {
        return (DBTYPE)((ODatabaseRecord)this.underlying).checkSecurity(iResource, iOperation);
    }

    public <DBTYPE extends ODatabaseRecord> DBTYPE checkSecurity(String iResourceGeneric, int iOperation, Object iResourceSpecific) {
        return (DBTYPE)((ODatabaseRecord)this.underlying).checkSecurity(iResourceGeneric, iOperation, iResourceSpecific);
    }

    public <DBTYPE extends ODatabaseRecord> DBTYPE checkSecurity(String iResourceGeneric, int iOperation, Object ... iResourcesSpecific) {
        return (DBTYPE)((ODatabaseRecord)this.underlying).checkSecurity(iResourceGeneric, iOperation, iResourcesSpecific);
    }

    @Override
    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE registerHook(ORecordHook iHookImpl) {
        ((ODatabaseRecord)this.underlying).registerHook(iHookImpl);
        return (DBTYPE)this;
    }

    @Override
    public boolean callbackHooks(ORecordHook.TYPE iType, OIdentifiable iObject) {
        return ((ODatabaseRecord)this.underlying).callbackHooks(iType, iObject);
    }

    @Override
    public Set<ORecordHook> getHooks() {
        return ((ODatabaseRecord)this.underlying).getHooks();
    }

    @Override
    public <DBTYPE extends ODatabaseComplex<?>> DBTYPE unregisterHook(ORecordHook iHookImpl) {
        ((ODatabaseRecord)this.underlying).unregisterHook(iHookImpl);
        return (DBTYPE)this;
    }

    public ODataSegmentStrategy getDataSegmentStrategy() {
        return ((ODatabaseRecord)this.underlying).getDataSegmentStrategy();
    }

    public void setDataSegmentStrategy(ODataSegmentStrategy dataSegmentStrategy) {
        ((ODatabaseRecord)this.underlying).setDataSegmentStrategy(dataSegmentStrategy);
    }

    protected void checkClusterBoundedToClass(int iClusterId) {
        for (OClass clazz : this.getMetadata().getSchema().getClasses()) {
            if (clazz.getDefaultClusterId() == iClusterId) {
                throw new OSchemaException("Cannot drop the cluster '" + this.getClusterNameById(iClusterId) + "' because the classes ['" + clazz.getName() + "'] are bound to it. Drop these classes before dropping the cluster");
            }
            if (clazz.getClusterIds().length <= 1) continue;
            for (int i : clazz.getClusterIds()) {
                if (i != iClusterId) continue;
                throw new OSchemaException("Cannot drop the cluster '" + this.getClusterNameById(iClusterId) + "' because the classes ['" + clazz.getName() + "'] are bound to it. Drop these classes before dropping the cluster");
            }
        }
    }
}

