/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePoolAbstract;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabasePoolBase<DB extends ODatabase>
extends Thread {
    protected ODatabasePoolAbstract<DB> dbPool;
    protected final String url;
    protected final String userName;
    protected final String userPassword;

    protected ODatabasePoolBase() {
        this.userPassword = null;
        this.userName = null;
        this.url = null;
    }

    protected ODatabasePoolBase(String iURL, String iUserName, String iUserPassword) {
        this.url = iURL;
        this.userName = iUserName;
        this.userPassword = iUserPassword;
    }

    public ODatabasePoolBase<DB> setup() {
        this.setup(1, 20);
        return this;
    }

    protected abstract DB createResource(Object var1, String var2, Object ... var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODatabasePoolBase<DB> setup(int iMinSize, int iMaxSize) {
        if (this.dbPool == null) {
            ODatabasePoolBase oDatabasePoolBase = this;
            synchronized (oDatabasePoolBase) {
                if (this.dbPool == null) {
                    this.dbPool = new ODatabasePoolAbstract<DB>(this, iMinSize, iMaxSize){

                        @Override
                        public void onShutdown() {
                            if (this.owner instanceof ODatabasePoolBase) {
                                ((ODatabasePoolBase)this.owner).close();
                            }
                        }

                        @Override
                        public DB createNewResource(String iDatabaseName, Object ... iAdditionalArgs) {
                            if (iAdditionalArgs.length < 2) {
                                throw new OSecurityAccessException("Username and/or password missed");
                            }
                            return ODatabasePoolBase.this.createResource(this.owner, iDatabaseName, iAdditionalArgs);
                        }

                        @Override
                        public boolean reuseResource(String iKey, Object[] iAdditionalArgs, DB iValue) {
                            if (((ODatabasePooled)iValue).isUnderlyingOpen()) {
                                ((ODatabasePooled)iValue).reuse(this.owner, iAdditionalArgs);
                                if (iValue.getStorage().isClosed()) {
                                    iValue.getStorage().open((String)iAdditionalArgs[0], (String)iAdditionalArgs[1], null);
                                } else if (!((ODatabaseComplex)iValue).getUser().checkPassword((String)iAdditionalArgs[1])) {
                                    throw new OSecurityAccessException(iValue.getName(), "User or password not valid for database: '" + iValue.getName() + "'");
                                }
                                return true;
                            }
                            return false;
                        }
                    };
                }
            }
        }
        return this;
    }

    public DB acquire() {
        this.setup();
        return this.dbPool.acquire(this.url, this.userName, this.userPassword);
    }

    public DB acquire(String iName, String iUserName, String iUserPassword) {
        this.setup();
        return this.dbPool.acquire(iName, iUserName, iUserPassword);
    }

    public DB acquire(String iName, String iUserName, String iUserPassword, Map<String, Object> iOptionalParams) {
        this.setup();
        return this.dbPool.acquire(iName, iUserName, iUserPassword, iOptionalParams);
    }

    public void release(DB iDatabase) {
        if (this.dbPool != null) {
            this.dbPool.release(iDatabase);
        }
    }

    public void close() {
        if (this.dbPool != null) {
            this.dbPool.close();
            this.dbPool = null;
        }
    }

    public int getMaxSize() {
        this.setup();
        return this.dbPool.getMaxSize();
    }

    public Map<String, OResourcePool<String, DB>> getPools() {
        return this.dbPool.getPools();
    }

    public void remove(String iName, String iUser) {
        this.dbPool.remove(iName, iUser);
    }

    @Override
    public void run() {
        this.close();
    }
}

