/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.db;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OOrientListener;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabasePooled;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ODatabasePoolAbstract<DB extends ODatabase>
implements OResourcePoolListener<String, DB>,
OOrientListener {
    private final ConcurrentHashMap<String, OResourcePool<String, DB>> pools = new ConcurrentHashMap();
    private int maxSize;
    private int timeout;
    protected Object owner;

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize) {
        this(iOwner, iMinSize, iMaxSize, OGlobalConfiguration.CLIENT_CONNECT_POOL_WAIT_TIMEOUT.getValueAsInteger());
    }

    public ODatabasePoolAbstract(Object iOwner, int iMinSize, int iMaxSize, int iTimeout) {
        this.maxSize = iMaxSize;
        this.timeout = iTimeout;
        this.owner = iOwner;
        Orient.instance().registerListener(this);
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword) throws OLockException {
        return this.acquire(iURL, iUserName, iUserPassword, null);
    }

    public DB acquire(String iURL, String iUserName, String iUserPassword, Map<String, Object> iOptionalParams) throws OLockException {
        String dbPooledName = iUserName + "@" + iURL;
        OResourcePool<String, Object> pool = this.pools.get(dbPooledName);
        if (pool == null) {
            pool = new OResourcePool(this.maxSize, this);
        }
        ODatabase db = (ODatabase)pool.getResource(iURL, this.timeout, iUserName, iUserPassword, iOptionalParams);
        this.pools.putIfAbsent(dbPooledName, pool);
        return (DB)db;
    }

    public void release(DB iDatabase) {
        String dbPooledName = iDatabase instanceof ODatabaseComplex ? ((ODatabaseComplex)iDatabase).getUser().getName() + "@" + iDatabase.getURL() : iDatabase.getURL();
        OResourcePool<String, DB> pool = this.pools.get(dbPooledName);
        if (pool == null) {
            throw new OLockException("Cannot release a database URL not acquired before. URL: " + iDatabase.getName());
        }
        pool.returnResource(iDatabase);
    }

    public DB reuseResource(String iKey, DB iValue) {
        return iValue;
    }

    public Map<String, OResourcePool<String, DB>> getPools() {
        return this.pools;
    }

    public void close() {
        for (Map.Entry<String, OResourcePool<String, DB>> pool : this.pools.entrySet()) {
            for (ODatabase db : pool.getValue().getResources()) {
                pool.getValue().close();
                try {
                    OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", db.getName());
                    ((ODatabasePooled)((Object)db)).forceClose();
                    OLogManager.instance().debug((Object)this, "OK", db.getName());
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error: %d", e.toString());
                }
            }
        }
    }

    public void remove(String iName, String iUser) {
        this.remove(iUser + "@" + iName);
    }

    public void remove(String iPoolName) {
        OResourcePool<String, DB> pool = this.pools.get(iPoolName);
        if (pool != null) {
            for (ODatabase db : pool.getResources()) {
                if (db.getStorage().getStatus() != OStorage.STATUS.OPEN) continue;
                try {
                    OLogManager.instance().debug((Object)this, "Closing pooled database '%s'...", db.getName());
                    ((ODatabasePooled)((Object)db)).forceClose();
                    OLogManager.instance().debug((Object)this, "OK", db.getName());
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Error: %d", e.toString());
                }
            }
            pool.close();
            this.pools.remove(iPoolName);
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void onStorageRegistered(OStorage iStorage) {
    }

    @Override
    public void onStorageUnregistered(OStorage iStorage) {
        String storageURL = iStorage.getURL();
        HashSet<String> poolToClose = null;
        for (Map.Entry<String, OResourcePool<String, DB>> e : this.pools.entrySet()) {
            int pos = e.getKey().indexOf("@");
            String dbName = e.getKey().substring(pos + 1);
            if (!storageURL.equals(dbName)) continue;
            if (poolToClose == null) {
                poolToClose = new HashSet<String>();
            }
            poolToClose.add(e.getKey());
        }
        if (poolToClose != null) {
            for (String pool : poolToClose) {
                this.remove(pool);
            }
        }
    }
}

