/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.cache.ODefaultCache;
import com.orientechnologies.orient.core.config.OConfigurationChangeCallback;
import com.orientechnologies.orient.core.storage.fs.OMMapManagerOld;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OGlobalConfiguration {
    ENVIRONMENT_DUMP_CFG_AT_STARTUP("environment.dumpCfgAtStartup", "Dumps the configuration at application startup", Boolean.class, Boolean.FALSE),
    ENVIRONMENT_CONCURRENT("environment.concurrent", "Specifies if running in multi-thread environment. Setting this to false turns off the internal lock management", Boolean.class, Boolean.TRUE),
    MEMORY_OPTIMIZE_THRESHOLD("memory.optimizeThreshold", "Threshold for heap memory at which optimization of memory usage starts. ", Float.class, 0.7),
    STORAGE_KEEP_OPEN("storage.keepOpen", "Tells to the engine to not close the storage when a database is closed. Storages will be closed when the process shuts down", Boolean.class, Boolean.FALSE),
    STORAGE_RECORD_LOCK_TIMEOUT("storage.record.lockTimeout", "Maximum timeout in milliseconds to lock a shared record", Integer.class, 5000),
    CACHE_LEVEL1_ENABLED("cache.level1.enabled", "Use the level-1 cache", Boolean.class, true),
    CACHE_LEVEL1_SIZE("cache.level1.size", "Size of the cache that keeps the record in memory", Integer.class, -1),
    CACHE_LEVEL2_ENABLED("cache.level2.enabled", "Use the level-2 cache", Boolean.class, true),
    CACHE_LEVEL2_SIZE("cache.level2.size", "Size of the cache that keeps the record in memory", Integer.class, -1),
    CACHE_LEVEL2_IMPL("cache.level2.impl", "Actual implementation of secondary cache", String.class, ODefaultCache.class.getCanonicalName()),
    CACHE_LEVEL2_STRATEGY("cache.level2.strategy", "Strategy to use when a database requests a record: 0 = pop the record, 1 = copy the record", Integer.class, 0, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
        }
    }),
    OBJECT_SAVE_ONLY_DIRTY("object.saveOnlyDirty", "Object Database only saves objects bound to dirty records", Boolean.class, false),
    DB_MVCC("db.mvcc", "Enables or disables MVCC (Multi-Version Concurrency Control) even outside transactions", Boolean.class, true),
    DB_VALIDATION("db.validation", "Enables or disables validation of records", Boolean.class, true),
    NON_TX_RECORD_UPDATE_SYNCH("nonTX.recordUpdate.synch", "Executes a synch against the file-system at every record operation. This slows down records updates but guarantee reliability on unreliable drives", Boolean.class, Boolean.FALSE),
    TX_USE_LOG("tx.useLog", "Transactions use log file to store temporary data to be rolled back in case of crash", Boolean.class, true),
    TX_LOG_TYPE("tx.log.fileType", "File type to handle transaction logs: mmap or classic", String.class, "classic"),
    TX_LOG_SYNCH("tx.log.synch", "Executes a synch against the file-system at every log entry. This slows down transactions but guarantee transaction reliability on unreliable drives", Boolean.class, Boolean.FALSE),
    TX_COMMIT_SYNCH("tx.commit.synch", "Synchronizes the storage after transaction commit", Boolean.class, false),
    BLUEPRINTS_TX_MODE("blueprints.graph.txMode", "Transaction mode used in TinkerPop Blueprints implementation. 0 = Automatic (default), 1 = Manual", Integer.class, 0),
    MVRBTREE_TIMEOUT("mvrbtree.timeout", "Maximum timeout to get lock against the OMVRB-Tree", Integer.class, 5000),
    MVRBTREE_LAZY_UPDATES("mvrbtree.lazyUpdates", "Configure the TreeMaps (indexes and dictionaries) as buffered or not. -1 means buffered until tx.commit() or db.close() are called", Integer.class, 5000),
    MVRBTREE_NODE_PAGE_SIZE("mvrbtree.nodePageSize", "Page size of each node. 256 means that 256 entries can be stored inside each node", Integer.class, 256),
    MVRBTREE_LOAD_FACTOR("mvrbtree.loadFactor", "HashMap load factor", Float.class, Float.valueOf(0.7f)),
    MVRBTREE_OPTIMIZE_THRESHOLD("mvrbtree.optimizeThreshold", "Auto optimize the TreeMap every X tree rotations. This forces the optimization of the tree after many changes to recompute entry points. -1 means never", Integer.class, 100000),
    MVRBTREE_ENTRYPOINTS("mvrbtree.entryPoints", "Number of entry points to start searching entries", Integer.class, 64),
    MVRBTREE_OPTIMIZE_ENTRYPOINTS_FACTOR("mvrbtree.optimizeEntryPointsFactor", "Multiplicand factor to apply to entry-points list (parameter mvrbtree.entrypoints) to determine optimization is needed", Float.class, Float.valueOf(1.0f)),
    MVRBTREE_ENTRY_KEYS_IN_MEMORY("mvrbtree.entryKeysInMemory", "Keep unserialized keys in memory", Boolean.class, Boolean.FALSE),
    MVRBTREE_ENTRY_VALUES_IN_MEMORY("mvrbtree.entryValuesInMemory", "Keep unserialized values in memory", Boolean.class, Boolean.FALSE),
    MVRBTREE_RID_BINARY_THRESHOLD("mvrbtree.ridBinaryThreshold", "Valid for set of rids. It's the threshold as number of entries to use the binary streaming instead of classic string streaming. -1 means never use binary streaming", Integer.class, 8),
    MVRBTREE_RID_NODE_PAGE_SIZE("mvrbtree.ridNodePageSize", "Page size of each treeset node. 16 means that 16 entries can be stored inside each node", Integer.class, 16),
    MVRBTREE_RID_NODE_SAVE_MEMORY("mvrbtree.ridNodeSaveMemory", "Save memory usage by avoid keeping RIDs in memory but creating them at every access", Boolean.class, Boolean.FALSE),
    LAZYSET_WORK_ON_STREAM("lazyset.workOnStream", "Upon add avoid unmarshalling set", Boolean.class, true),
    FILE_LOCK("file.lock", "Locks files when used. Default is false", Boolean.TYPE, false),
    FILE_DEFRAG_STRATEGY("file.defrag.strategy", "Strategy to recycle free space. 0 = Recycles the first hole with enough size: fast, 1 = recycles the best hole: better usage of space but slower", Integer.class, 0),
    FILE_DEFRAG_HOLE_MAX_DISTANCE("file.defrag.holeMaxDistance", "Max distance in bytes between holes to cause their defrag. Set it to -1 to use dynamic size. Beware that if the db is huge moving blocks to defrag could be expensive", Integer.class, 32768),
    FILE_MMAP_USE_OLD_MANAGER("file.mmap.useOldManager", "Manager that will be used to handle mmap files. true = USE OLD MANAGER, false = USE NEW MANAGER", Boolean.TYPE, false),
    FILE_MMAP_LOCK_MEMORY("file.mmap.lockMemory", "When using new map manager this parameter specify prevent memory swap or not. true = LOCK MEMORY, false = NOT LOCK MEMORY", Boolean.TYPE, true),
    FILE_MMAP_STRATEGY("file.mmap.strategy", "Strategy to use with memory mapped files. 0 = USE MMAP ALWAYS, 1 = USE MMAP ON WRITES OR ON READ JUST WHEN THE BLOCK POOL IS FREE, 2 = USE MMAP ON WRITES OR ON READ JUST WHEN THE BLOCK IS ALREADY AVAILABLE, 3 = USE MMAP ONLY IF BLOCK IS ALREADY AVAILABLE, 4 = NEVER USE MMAP", Integer.class, 0),
    FILE_MMAP_BLOCK_SIZE("file.mmap.blockSize", "Size of the memory mapped block, default is 1Mb", Integer.class, 0x100000, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManagerOld.setBlockSize(((Number)iNewValue).intValue());
        }
    }),
    FILE_MMAP_BUFFER_SIZE("file.mmap.bufferSize", "Size of the buffer for direct access to the file through the channel", Integer.class, 8192),
    FILE_MMAP_MAX_MEMORY("file.mmap.maxMemory", "Max memory allocatable by memory mapping manager. Note that on 32bit operating systems, the limit is 2Gb but will vary between operating systems", Long.class, 0x8000000, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManagerOld.setMaxMemory(OFileUtils.getSizeAsNumber(iNewValue));
        }
    }),
    FILE_MMAP_OVERLAP_STRATEGY("file.mmap.overlapStrategy", "Strategy to use when a request overlaps in-memory buffers: 0 = Use the channel access, 1 = force the in-memory buffer and use the channel access, 2 = always create an overlapped in-memory buffer (default)", Integer.class, 2, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OMMapManagerOld.setOverlapStrategy((Integer)iNewValue);
        }
    }),
    FILE_MMAP_FORCE_DELAY("file.mmap.forceDelay", "Delay time in ms to wait for another forced flush of the memory-mapped block to disk", Integer.class, 10),
    FILE_MMAP_FORCE_RETRY("file.mmap.forceRetry", "Number of times the memory-mapped block will try to flush to disk", Integer.class, 50),
    JNA_DISABLE_USE_SYSTEM_LIBRARY("jna.disable.system.library", "This property disable to using JNA installed in your system. And use JNA bundled with database.", Boolean.TYPE, true),
    NETWORK_SOCKET_BUFFER_SIZE("network.socketBufferSize", "TCP/IP Socket buffer size", Integer.class, 32768),
    NETWORK_LOCK_TIMEOUT("network.lockTimeout", "Timeout in ms to acquire a lock against a channel", Integer.class, 15000),
    NETWORK_SOCKET_TIMEOUT("network.socketTimeout", "TCP/IP Socket timeout in ms", Integer.class, 10000),
    NETWORK_SOCKET_RETRY("network.retry", "Number of times the client retries its connection to the server on failure", Integer.class, 5),
    NETWORK_SOCKET_RETRY_DELAY("network.retryDelay", "Number of ms the client waits before reconnecting to the server on failure", Integer.class, 500),
    NETWORK_BINARY_DNS_LOADBALANCING_ENABLED("network.binary.loadBalancing.enabled", "Asks for DNS TXT record to determine if load balancing is supported", Boolean.class, Boolean.FALSE),
    NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT("network.binary.loadBalancing.timeout", "Maximum time (in ms) to wait for the answer from DNS about the TXT record for load balancing", Integer.class, 2000),
    NETWORK_BINARY_MAX_CONTENT_LENGTH("network.binary.maxLength", "TCP/IP max content length in bytes of BINARY requests", Integer.class, 32736),
    NETWORK_BINARY_READ_RESPONSE_MAX_TIMES("network.binary.readResponse.maxTimes", "Maximum times to wait until response will be read. Otherwise response will be dropped from chanel", Integer.class, 20),
    NETWORK_BINARY_DEBUG("network.binary.debug", "Debug mode: print all data incoming on the binary channel", Boolean.class, false),
    NETWORK_HTTP_MAX_CONTENT_LENGTH("network.http.maxLength", "TCP/IP max content length in bytes for HTTP requests", Integer.class, 100000),
    NETWORK_HTTP_CONTENT_CHARSET("network.http.charset", "Http response charset", String.class, "utf-8"),
    NETWORK_HTTP_SESSION_EXPIRE_TIMEOUT("network.http.sessionExpireTimeout", "Timeout after which an http session is considered tp have expired (seconds)", Integer.class, 300),
    PROFILER_ENABLED("profiler.enabled", "Enable the recording of statistics and counters", Boolean.class, false, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            if (((Boolean)iNewValue).booleanValue()) {
                OProfiler.getInstance().startRecording();
            } else {
                OProfiler.getInstance().stopRecording();
            }
        }
    }),
    PROFILER_AUTODUMP_INTERVAL("profiler.autoDump.interval", "Dumps the profiler values at regular intervals. Time is expressed in seconds", Integer.class, 0, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OProfiler.getInstance().setAutoDump((Integer)iNewValue);
        }
    }),
    PROFILER_AUTODUMP_RESET("profiler.autoDump.reset", "Resets the profiler at every auto dump", Boolean.class, true, new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OProfiler.getInstance().setAutoDumpReset((Boolean)iNewValue);
        }
    }),
    LOG_CONSOLE_LEVEL("log.console.level", "Console logging level", String.class, "info", new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OLogManager.instance().setLevel((String)iNewValue, ConsoleHandler.class);
        }
    }),
    LOG_FILE_LEVEL("log.file.level", "File logging level", String.class, "fine", new OConfigurationChangeCallback(){

        public void change(Object iCurrentValue, Object iNewValue) {
            OLogManager.instance().setLevel((String)iNewValue, FileHandler.class);
        }
    }),
    CLIENT_CHANNEL_MIN_POOL("client.channel.minPool", "Minimum pool size", Integer.class, 1),
    CLIENT_CHANNEL_MAX_POOL("client.channel.maxPool", "Maximum channel pool size", Integer.class, 5),
    CLIENT_CONNECT_POOL_WAIT_TIMEOUT("client.connectionPool.waitTimeout", "Maximum time which client should wait connection from the pool", Integer.class, 5000),
    CLIENT_DB_RELEASE_WAIT_TIMEOUT("client.channel.dbReleaseWaitTimeout", "Delay in ms. after which data modification command will be resent if DB was frozen", Integer.class, 10000),
    SERVER_CHANNEL_CLEAN_DELAY("server.channel.cleanDelay", "Time in ms of delay to check pending closed connections", Integer.class, 5000),
    SERVER_CACHE_FILE_STATIC("server.cache.staticFile", "Cache static resources loading", Boolean.class, false),
    SERVER_LOG_DUMP_CLIENT_EXCEPTION_LEVEL("server.log.dumpClientExceptionLevel", "Logs client exceptions. Use any level supported by Java java.util.logging.Level class: OFF, FINE, CONFIG, INFO, WARNING, SEVERE", Level.class, Level.FINE),
    SERVER_LOG_DUMP_CLIENT_EXCEPTION_FULLSTACKTRACE("server.log.dumpClientExceptionFullStackTrace", "Dumps the full stack trace of the exception to sent to the client", Level.class, Boolean.TRUE);

    private final String key;
    private final Object defValue;
    private final Class<?> type;
    private Object value = null;
    private String description;
    private OConfigurationChangeCallback changeCallback = null;

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue, OConfigurationChangeCallback iChangeAction) {
        this(iKey, iDescription, iType, iDefValue);
        this.changeCallback = iChangeAction;
    }

    private OGlobalConfiguration(String iKey, String iDescription, Class<?> iType, Object iDefValue) {
        this.key = iKey;
        this.description = iDescription;
        this.defValue = iDefValue;
        this.type = iType;
    }

    public void setValue(Object iValue) {
        Object oldValue = this.value;
        if (iValue != null) {
            this.value = this.type == Boolean.class ? Boolean.valueOf(Boolean.parseBoolean(iValue.toString())) : (this.type == Integer.class ? Integer.valueOf(Integer.parseInt(iValue.toString())) : (this.type == Float.class ? Float.valueOf(Float.parseFloat(iValue.toString())) : (this.type == String.class ? iValue.toString() : iValue)));
        }
        if (this.changeCallback != null) {
            this.changeCallback.change(oldValue, this.value);
        }
    }

    public Object getValue() {
        return this.value != null ? this.value : this.defValue;
    }

    public boolean getValueAsBoolean() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Boolean ? (Boolean)v : Boolean.parseBoolean(v.toString());
    }

    public String getValueAsString() {
        Object v = this.value != null ? this.value : this.defValue;
        return v.toString();
    }

    public int getValueAsInteger() {
        Object v = this.value != null ? this.value : this.defValue;
        return (int)(v instanceof Number ? (long)((Number)v).intValue() : OFileUtils.getSizeAsNumber(v.toString()));
    }

    public long getValueAsLong() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Number ? ((Number)v).longValue() : OFileUtils.getSizeAsNumber(v.toString());
    }

    public float getValueAsFloat() {
        Object v = this.value != null ? this.value : this.defValue;
        return v instanceof Float ? ((Float)v).floatValue() : (float)OFileUtils.getSizeAsNumber(v.toString());
    }

    public String getKey() {
        return this.key;
    }

    public Class<?> getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public static void dumpConfiguration(PrintStream out) {
        out.print("OrientDB ");
        out.print(OConstants.getVersion());
        out.println(" configuration dump:");
        String lastSection = "";
        for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
            String section = v.key.substring(0, v.key.indexOf(46));
            if (!lastSection.equals(section)) {
                out.print("- ");
                out.println(section.toUpperCase());
                lastSection = section;
            }
            out.print("  + ");
            out.print(v.key);
            out.print(" = ");
            out.println(v.getValue());
        }
    }

    public static OGlobalConfiguration findByKey(String iKey) {
        for (OGlobalConfiguration v : OGlobalConfiguration.values()) {
            if (!v.getKey().equalsIgnoreCase(iKey)) continue;
            return v;
        }
        return null;
    }

    public static void setConfiguration(Map<String, Object> iConfig) {
        for (Map.Entry<String, Object> config : iConfig.entrySet()) {
            OGlobalConfiguration cfg = OGlobalConfiguration.valueOf(config.getKey());
            if (cfg == null) continue;
            cfg.setValue(config.getValue());
        }
    }

    private static void readConfiguration() {
        for (OGlobalConfiguration config : OGlobalConfiguration.values()) {
            String prop = System.getProperty(config.key);
            if (prop == null) continue;
            config.setValue(prop);
        }
    }

    private static void autoConfig() {
        if (System.getProperty("os.arch").indexOf("64") > -1 && FILE_MMAP_MAX_MEMORY.getValueAsInteger() == 0x8000000) {
            OperatingSystemMXBean bean = ManagementFactory.getOperatingSystemMXBean();
            try {
                Class<?> cls = Class.forName("com.sun.management.OperatingSystemMXBean");
                if (cls.isAssignableFrom(bean.getClass())) {
                    Long maxOsMemory = (Long)cls.getMethod("getTotalPhysicalMemorySize", new Class[0]).invoke((Object)bean, new Object[0]);
                    long maxProcessMemory = Runtime.getRuntime().maxMemory();
                    long mmapBestMemory = (maxOsMemory - maxProcessMemory) / 2L;
                    FILE_MMAP_MAX_MEMORY.setValue(mmapBestMemory);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        OGlobalConfiguration.readConfiguration();
        OGlobalConfiguration.autoConfig();
    }
}

