/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.config;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OContextConfiguration {
    private Map<String, Object> config = new HashMap<String, Object>();

    public OContextConfiguration() {
    }

    public OContextConfiguration(Map<String, Object> iConfig) {
        this.config = iConfig;
    }

    public OContextConfiguration(OContextConfiguration iParent) {
        if (iParent != null) {
            this.config.putAll(iParent.config);
        }
    }

    public Object setValue(OGlobalConfiguration iConfig, Object iValue) {
        return this.config.put(iConfig.getKey(), iValue);
    }

    public Object setValue(String iName, Object iValue) {
        return this.config.put(iName, iValue);
    }

    public Object getValue(OGlobalConfiguration iConfig) {
        if (this.config != null && this.config.containsKey(iConfig.getKey())) {
            return this.config.get(iConfig.getKey());
        }
        return iConfig.getValue();
    }

    public <T> T getValue(String iName, T iDefaultValue) {
        if (this.config != null && this.config.containsKey(iName)) {
            return (T)this.config.get(iName);
        }
        String sysProperty = System.getProperty(iName);
        if (sysProperty != null) {
            return (T)sysProperty;
        }
        return iDefaultValue;
    }

    public boolean getValueAsBoolean(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        return v instanceof Boolean ? (Boolean)v : Boolean.parseBoolean(v.toString());
    }

    public String getValueAsString(String iName, String iDefaultValue) {
        return this.getValue(iName, iDefaultValue);
    }

    public String getValueAsString(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        return v.toString();
    }

    public int getValueAsInteger(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        return v instanceof Integer ? (Integer)v : Integer.parseInt(v.toString());
    }

    public float getValueAsFloat(OGlobalConfiguration iConfig) {
        Object v = this.getValue(iConfig);
        return v instanceof Float ? ((Float)v).floatValue() : Float.parseFloat(v.toString());
    }
}

