/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.command.traverse;

import com.orientechnologies.orient.core.command.traverse.OTraverse;
import com.orientechnologies.orient.core.command.traverse.OTraverseAbstractProcess;
import com.orientechnologies.orient.core.command.traverse.OTraverseFieldProcess;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTraverseRecordProcess
extends OTraverseAbstractProcess<ODocument> {
    public OTraverseRecordProcess(OTraverse iCommand, ODocument iTarget) {
        super(iCommand, iTarget);
        ((OTraverse)this.command).getContext().incrementDepth();
    }

    @Override
    public OIdentifiable process() {
        Boolean conditionResult;
        if (this.target == null) {
            return this.drop();
        }
        if (((OTraverse)this.command).getContext().isAlreadyTraversed((OIdentifiable)this.target)) {
            return this.drop();
        }
        if (((ODocument)this.target).getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                ((ODocument)this.target).reload();
            }
            catch (ORecordNotFoundException e) {
                return this.drop();
            }
        }
        ((OTraverse)this.command).getContext().addTraversed((OIdentifiable)this.target);
        if (((OTraverse)this.command).getPredicate() != null && (conditionResult = Boolean.valueOf(((OTraverse)this.command).getPredicate().evaluate((ORecord)this.target, ((OTraverse)this.command).getContext()))) != Boolean.TRUE) {
            return this.drop();
        }
        ArrayList<String> fields = new ArrayList<String>();
        for (String cfgField : ((OTraverse)this.command).getFields()) {
            if ("*".equals(cfgField) || "ALL()".equalsIgnoreCase(cfgField) || "ANY()".equalsIgnoreCase(cfgField)) {
                for (String f : ((ODocument)this.target).fieldNames()) {
                    fields.add(f);
                }
                break;
            }
            int pos = cfgField.indexOf(46);
            if (pos > -1) {
                String className;
                OClass cls = ((ODocument)this.target).getSchemaClass();
                if (cls == null || !cls.isSubClassOf(className = cfgField.substring(0, pos))) continue;
                cfgField = cfgField.substring(pos + 1);
            }
            fields.add(cfgField);
        }
        new OTraverseFieldProcess((OTraverse)this.command, fields.iterator());
        return (OIdentifiable)this.target;
    }

    @Override
    public String getStatus() {
        return this.target != null ? ((ODocument)this.target).getIdentity().toString() : null;
    }

    @Override
    public String toString() {
        return this.target != null ? ((ODocument)this.target).getIdentity().toString() : "-";
    }

    @Override
    public OIdentifiable drop() {
        ((OTraverse)this.command).getContext().decrementDepth();
        return super.drop();
    }
}

