/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.cache;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODefaultCache
implements OCache {
    private static final int DEFAULT_LIMIT = 1000;
    private final OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);
    private final AtomicBoolean enabled = new AtomicBoolean(false);
    private final OLinkedHashMapCache cache;
    private final int limit;
    protected OMemoryWatchDog.Listener lowMemoryListener;

    public ODefaultCache(String iName, int initialLimit) {
        int initialCapacity = initialLimit > 0 ? initialLimit : 1000;
        this.limit = initialLimit;
        this.cache = new OLinkedHashMapCache(initialCapacity, 0.75f, this.limit);
    }

    @Override
    public void startup() {
        this.lowMemoryListener = Orient.instance().getMemoryWatchDog().addListener(new OLowMemoryListener());
        this.enable();
    }

    @Override
    public void shutdown() {
        Orient.instance().getMemoryWatchDog().removeListener(this.lowMemoryListener);
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled.get();
    }

    @Override
    public boolean enable() {
        return this.enabled.compareAndSet(false, true);
    }

    @Override
    public boolean disable() {
        this.clear();
        return this.enabled.compareAndSet(true, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> get(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.cache.get(id);
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            return oRecordInternal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> put(ORecordInternal<?> record) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal<?> oRecordInternal = this.cache.put(record.getIdentity(), record);
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            return oRecordInternal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> remove(ORID id) {
        if (!this.isEnabled()) {
            return null;
        }
        this.lock.acquireExclusiveLock();
        try {
            ORecordInternal oRecordInternal = (ORecordInternal)this.cache.remove(id);
            Object var4_3 = null;
            this.lock.releaseExclusiveLock();
            return oRecordInternal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        if (!this.isEnabled()) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            this.cache.clear();
            Object var2_1 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this.lock.acquireSharedLock();
        try {
            int n = this.cache.size();
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public int limit() {
        return this.limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ORID> keys() {
        this.lock.acquireExclusiveLock();
        try {
            ArrayList<ORID> arrayList = new ArrayList<ORID>(this.cache.keySet());
            Object var3_2 = null;
            this.lock.releaseExclusiveLock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeEldest(int threshold) {
        this.lock.acquireExclusiveLock();
        try {
            this.cache.removeEldest(threshold);
            Object var3_2 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public void lock(ORID id) {
        this.lock.acquireExclusiveLock();
    }

    @Override
    public void unlock(ORID id) {
        this.lock.releaseExclusiveLock();
    }

    class OLowMemoryListener
    implements OMemoryWatchDog.Listener {
        OLowMemoryListener() {
        }

        public void memoryUsageLow(long freeMemory, long freeMemoryPercentage) {
            try {
                int oldSize = ODefaultCache.this.size();
                if (oldSize == 0) {
                    return;
                }
                if (freeMemoryPercentage < 10L) {
                    OLogManager.instance().debug((Object)this, "Low memory (%d%%): clearing %d cached records", freeMemoryPercentage, ODefaultCache.this.size());
                    ODefaultCache.this.removeEldest(oldSize);
                } else {
                    int newSize = (int)((float)oldSize * 0.9f);
                    ODefaultCache.this.removeEldest(oldSize - newSize);
                    OLogManager.instance().debug((Object)this, "Low memory (%d%%): reducing cached records number from %d to %d", freeMemoryPercentage, oldSize, newSize);
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error occurred during default cache cleanup", (Throwable)e, new Object[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class OLinkedHashMapCache
    extends LinkedHashMap<ORID, ORecordInternal<?>> {
        private final int limit;

        public OLinkedHashMapCache(int initialCapacity, float loadFactor, int limit) {
            super(initialCapacity, loadFactor, true);
            this.limit = limit;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ORID, ORecordInternal<?>> eldest) {
            return this.limit > 0 ? this.size() - this.limit > 0 : false;
        }

        void removeEldest(int amount) {
            ORID[] victims = new ORID[amount];
            int skip = this.size() - amount;
            int skipped = 0;
            int selected = 0;
            for (Map.Entry entry : this.entrySet()) {
                if (((ORecordInternal)entry.getValue()).isDirty() || ((ORecordInternal)entry.getValue()).isPinned() == Boolean.TRUE || skipped++ < skip) continue;
                victims[selected++] = (ORID)entry.getKey();
            }
            for (ORID id : victims) {
                this.remove(id);
            }
        }
    }
}

