/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.client.remote;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.client.remote.OStorageRemoteAsynchEventListener;
import com.orientechnologies.orient.client.remote.OStorageRemoteThreadLocal;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequestAsynch;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerAnyStreamable;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.enterprise.channel.binary.OAsynchChannelServiceThread;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryClient;
import com.orientechnologies.orient.enterprise.channel.binary.OChannelBinaryProtocol;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.enterprise.channel.binary.ORemoteServerEventListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageRemote
extends OStorageAbstract {
    private static final String DEFAULT_HOST = "localhost";
    private static final int DEFAULT_PORT = 2424;
    private static final String ADDRESS_SEPARATOR = ";";
    public static final String PARAM_MIN_POOL = "minpool";
    public static final String PARAM_MAX_POOL = "maxpool";
    private static final String DRIVER_NAME = "OrientDB Java";
    protected final ExecutorService asynchExecutor;
    private OAsynchChannelServiceThread serviceThread;
    private OContextConfiguration clientConfiguration;
    private int connectionRetry;
    private int connectionRetryDelay;
    private static List<OChannelBinaryClient> networkPool = new ArrayList<OChannelBinaryClient>();
    protected List<String> serverURLs = new ArrayList<String>();
    protected final Map<String, Integer> clustersIds = new HashMap<String, Integer>();
    protected final Map<String, String> clustersTypes = new HashMap<String, String>();
    protected int defaultClusterId;
    private int networkPoolCursor = 0;
    private int minPool;
    private int maxPool;
    private final boolean debug = false;
    private ODocument clusterConfiguration;
    private ORemoteServerEventListener asynchEventListener;
    private String connectionUserName;
    private String connectionUserPassword;
    private Map<String, Object> connectionOptions;
    private final String clientId;

    public OStorageRemote(String iClientId, String iURL, String iMode) throws IOException {
        super(iURL, iURL, iMode);
        this.clientId = iClientId;
        this.configuration = null;
        this.clientConfiguration = new OContextConfiguration();
        this.connectionRetry = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY);
        this.connectionRetryDelay = this.clientConfiguration.getValueAsInteger(OGlobalConfiguration.NETWORK_SOCKET_RETRY_DELAY);
        this.asynchEventListener = new OStorageRemoteAsynchEventListener(this);
        this.parseServerURLs();
        this.asynchExecutor = Executors.newSingleThreadExecutor();
    }

    public int getSessionId() {
        return ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId;
    }

    public void setSessionId(int iSessionId) {
        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).sessionId = iSessionId;
    }

    public ORemoteServerEventListener getAsynchEventListener() {
        return this.asynchEventListener;
    }

    public void setAsynchEventListener(ORemoteServerEventListener iListener) {
        this.asynchEventListener = iListener;
    }

    public void removeRemoteServerEventListener() {
        this.asynchEventListener = null;
    }

    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        this.connectionUserName = iUserName;
        this.connectionUserPassword = iUserPassword;
        this.connectionOptions = iOptions != null ? new HashMap<String, Object>(iOptions) : null;
        try {
            this.openRemoteDatabase();
            this.configuration = new OStorageConfiguration((OStorage)this);
            this.configuration.load();
        }
        catch (Exception e) {
            if (!OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean()) {
                this.close();
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new OStorageException("Cannot open the remote storage: " + this.name, (Throwable)e);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)73);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    this.readDatabaseInformation(network);
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on reloading database information", e);
                continue;
            }
            break;
        }
    }

    public void create(Map<String, Object> iOptions) {
        throw new UnsupportedOperationException("Cannot create a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    public boolean exists() {
        throw new UnsupportedOperationException("Cannot check the existance of a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean iForce) {
        this.lock.acquireExclusiveLock();
        OChannelBinaryClient network = null;
        try {
            if (networkPool.size() > 0) {
                try {
                    network = this.beginRequest((byte)5);
                }
                finally {
                    this.endRequest(network);
                }
                this.getResponse(network);
            }
            this.setSessionId(-1);
            if (!this.checkForClose(iForce)) {
                return;
            }
            if (this.serviceThread != null) {
                this.serviceThread.sendShutdown();
                this.serviceThread.interrupt();
            }
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                for (OChannelBinaryClient n : networkPool) {
                    n.close();
                }
                networkPool.clear();
            }
            this.level2Cache.shutdown();
            super.close(iForce);
            this.status = OStorageAbstract.STATUS.CLOSED;
            Orient.instance().unregisterStorage((OStorage)this);
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            OLogManager.instance().debug((Object)this, "Error on closing remote connection: %s", new Object[]{network});
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    public void delete() {
        throw new UnsupportedOperationException("Cannot delete a database in a remote server. Please use the console or the OServerAdmin class.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            Set<String> set = this.clustersIds.keySet();
            return set;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameCluster(String iOldName, String iNewName) {
        this.lock.acquireSharedLock();
        try {
            this.checkConnection();
            Integer clusterId = this.clustersIds.remove(iOldName);
            this.clustersIds.put(iNewName, clusterId);
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType, int iMode, final ORecordCallback<Long> iCallback) {
        this.checkConnection();
        while (true) {
            try {
                while (true) {
                    final OChannelBinaryClient network = this.beginRequest((byte)31);
                    try {
                        network.writeShort((short)iRid.clusterId);
                        network.writeBytes(iContent);
                        network.writeByte(iRecordType);
                        network.writeByte((byte)iMode);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    if (iMode == 1) {
                        return -1L;
                    }
                    if (iCallback == null) {
                        try {
                            this.beginResponse(network);
                            long l = iRid.clusterPosition = network.readLong();
                            return l;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    Callable<Object> response = new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            Long result;
                            OStorageRemote.this.beginResponse(network);
                            try {
                                result = network.readLong();
                            }
                            finally {
                                OStorageRemote.this.endResponse(network);
                            }
                            iCallback.call((Object)result);
                            return null;
                        }
                    };
                    this.asynchExecutor.submit(new FutureTask<Object>(response));
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on create record in cluster: " + iRid.clusterId, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ORawBuffer readRecord(ORecordId iRid, String iFetchPlan, ORecordCallback<ORawBuffer> iCallback) {
        this.checkConnection();
        if (((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting) {
            return null;
        }
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)30);
                    network.writeRID((ORID)iRid);
                    network.writeString(iFetchPlan != null ? iFetchPlan : "");
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 0) {
                        ORawBuffer oRawBuffer = null;
                        return oRawBuffer;
                    }
                    ORawBuffer buffer = new ORawBuffer(network.readBytes(), network.readInt(), network.readByte());
                    ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.getIfDefined();
                    while (network.readByte() == 2) {
                        ORecordInternal record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                        if (database == null) continue;
                        database.getLevel1Cache().updateRecord(record);
                    }
                    ORawBuffer oRawBuffer = buffer;
                    return oRawBuffer;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on read record " + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, final ORecordCallback<Integer> iCallback) {
        this.checkConnection();
        while (true) {
            try {
                while (true) {
                    final OChannelBinaryClient network = this.beginRequest((byte)32);
                    try {
                        network.writeRID((ORID)iRid);
                        network.writeBytes(iContent);
                        network.writeInt(iVersion);
                        network.writeByte(iRecordType);
                        network.writeByte((byte)iMode);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    if (iMode == 1) {
                        return iVersion;
                    }
                    if (iCallback == null) {
                        try {
                            this.beginResponse(network);
                            int n = network.readInt();
                            return n;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    Callable<Object> response = new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            int result;
                            OStorageRemote.this.beginResponse(network);
                            try {
                                result = network.readInt();
                            }
                            finally {
                                OStorageRemote.this.endResponse(network);
                            }
                            iCallback.call((Object)result);
                            return null;
                        }
                    };
                    this.asynchExecutor.submit(new FutureTask<Object>(response));
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on update record " + iRid, e);
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean deleteRecord(ORecordId iRid, int iVersion, int iMode, final ORecordCallback<Boolean> iCallback) {
        this.checkConnection();
        while (true) {
            try {
                while (true) {
                    final OChannelBinaryClient network = this.beginRequest((byte)33);
                    try {
                        network.writeRID((ORID)iRid);
                        network.writeInt(iVersion);
                        network.writeByte((byte)iMode);
                    }
                    finally {
                        this.endRequest(network);
                    }
                    if (iMode == 1) {
                        return false;
                    }
                    if (iCallback == null) {
                        try {
                            this.beginResponse(network);
                            boolean bl = network.readByte() == 1;
                            return bl;
                        }
                        finally {
                            this.endResponse(network);
                        }
                    }
                    Callable<Object> response = new Callable<Object>(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Object call() throws Exception {
                            Boolean result;
                            OStorageRemote.this.beginResponse(network);
                            try {
                                result = network.readByte() == 1;
                            }
                            finally {
                                OStorageRemote.this.endResponse(network);
                            }
                            iCallback.call((Object)result);
                            return null;
                        }
                    };
                    this.asynchExecutor.submit(new FutureTask<Object>(response));
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on delete record " + iRid, e);
                continue;
            }
            break;
        }
    }

    public long count(int iClusterId) {
        return this.count(new int[]{iClusterId});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getClusterDataRange(int iClusterId) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)13);
                network.writeShort((short)iClusterId);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long[] lArray = new long[]{network.readLong(), network.readLong()};
                this.endResponse(network);
                return lArray;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on getting last entry position count in cluster: " + iClusterId, e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)8);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read database size", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countRecords() {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)9);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read database record count", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(int[] iClusterIds) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)12);
                network.writeShort((short)iClusterIds.length);
                for (int i = 0; i < iClusterIds.length; ++i) {
                    network.writeShort((short)iClusterIds[i]);
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                long l = network.readLong();
                this.endResponse(network);
                return l;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on read record count in clusters: " + Arrays.toString(iClusterIds), e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(OCommandRequestText iCommand) {
        this.checkConnection();
        if (!(iCommand instanceof OSerializableStream)) {
            throw new OCommandExecutionException("Cannot serialize the command to be executed to the server side.");
        }
        OCommandRequestText command = iCommand;
        Object result = null;
        ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
        while (true) {
            ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = true;
            OCommandRequestText aquery = iCommand;
            boolean asynch = iCommand instanceof OCommandRequestAsynch;
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)41);
                network.writeByte((byte)(asynch ? 97 : 115));
                network.writeBytes(OStreamSerializerAnyStreamable.INSTANCE.toStream((Object)command));
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                if (asynch) {
                    ORecordInternal record;
                    byte status;
                    block24: while ((status = network.readByte()) > 0 && (record = (ORecordInternal)OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network)) != null) {
                        switch (status) {
                            case 1: {
                                try {
                                    if (!aquery.getResultListener().result((Object)record)) {
                                        while (network.in.available() > 0) {
                                            network.in.read();
                                        }
                                        continue block24;
                                    }
                                }
                                catch (Throwable t) {
                                    t.printStackTrace();
                                }
                                database.getLevel1Cache().updateRecord(record);
                                break;
                            }
                            case 2: {
                                database.getLevel1Cache().updateRecord(record);
                            }
                        }
                    }
                } else {
                    byte type = network.readByte();
                    switch (type) {
                        case 110: {
                            result = null;
                            break;
                        }
                        case 114: {
                            result = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                            if (!(result instanceof ORecord)) break;
                            database.getLevel1Cache().updateRecord((ORecordInternal)result);
                            break;
                        }
                        case 108: {
                            int tot = network.readInt();
                            ArrayList<OIdentifiable> list = new ArrayList<OIdentifiable>();
                            for (int i = 0; i < tot; ++i) {
                                OIdentifiable resultItem = OChannelBinaryProtocol.readIdentifiable((OChannelBinaryClient)network);
                                if (resultItem instanceof ORecord) {
                                    database.getLevel1Cache().updateRecord((ORecordInternal)resultItem);
                                }
                                list.add(resultItem);
                            }
                            result = list;
                            break;
                        }
                        case 97: {
                            String value = new String(network.readBytes());
                            result = ORecordSerializerStringAbstract.fieldTypeFromStream(null, (OType)ORecordSerializerStringAbstract.getType((String)value), (Object)value);
                        }
                    }
                }
                this.endResponse(network);
                ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                break;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        this.endResponse(network);
                        throw throwable;
                    }
                    catch (OException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        this.handleException("Error on executing command: " + iCommand, e);
                        ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                    }
                }
                catch (Throwable throwable2) {
                    ((OStorageRemoteThreadLocal.OStorageRemoteSession)OStorageRemoteThreadLocal.INSTANCE.get()).commandExecuting = false;
                    throw throwable2;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit(OTransaction iTx) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)60);
                    network.writeInt(iTx.getId());
                    network.writeByte((byte)(iTx.isUsingLog() ? 1 : 0));
                    ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                    while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                        for (ORecordOperation txEntry : iTx.getCurrentRecordEntries()) {
                            tmpEntries.add(txEntry);
                        }
                        iTx.clearRecordEntries();
                        if (tmpEntries.size() <= 0) continue;
                        for (ORecordOperation txEntry : tmpEntries) {
                            this.commitEntry(network, txEntry);
                        }
                    }
                    network.writeByte((byte)0);
                    network.writeBytes(iTx.getIndexChanges().toStream());
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    int createdRecords = network.readInt();
                    block13: for (int i = 0; i < createdRecords; ++i) {
                        ORecordId currentRid = network.readRID();
                        ORecordId createdRid = network.readRID();
                        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                            if (!txEntry.getRecord().getIdentity().equals(currentRid)) continue;
                            txEntry.getRecord().setIdentity(createdRid);
                            continue block13;
                        }
                    }
                    int updatedRecords = network.readInt();
                    block15: for (int i = 0; i < updatedRecords; ++i) {
                        ORecordId rid = network.readRID();
                        for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                            if (!txEntry.getRecord().getIdentity().equals(rid)) continue;
                            txEntry.getRecord().setVersion(network.readInt());
                            continue block15;
                        }
                    }
                }
                finally {
                    this.endResponse(network);
                }
                for (ORecordOperation txEntry : iTx.getAllRecordEntries()) {
                    txEntry.getRecord().unload();
                }
                OTransactionAbstract.updateCacheFromEntries((OStorage)this, (OTransaction)iTx, (Iterable)iTx.getAllRecordEntries(), (boolean)false);
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on commit", e);
                continue;
            }
            break;
        }
    }

    public void rollback(OTransaction iTx) {
    }

    public int getClusterIdByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return -1;
        }
        if (Character.isDigit(iClusterName.charAt(0))) {
            return Integer.parseInt(iClusterName);
        }
        Integer id = this.clustersIds.get(iClusterName.toLowerCase());
        if (id == null) {
            return -1;
        }
        return id;
    }

    public String getClusterTypeByName(String iClusterName) {
        this.checkConnection();
        if (iClusterName == null) {
            return null;
        }
        return this.clustersTypes.get(iClusterName.toLowerCase());
    }

    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iArguments) {
        this.checkConnection();
        while (true) {
            network = null;
            try {
                network = this.beginRequest((byte)10);
                network.writeString(iClusterType.toString());
                network.writeString(iClusterName);
                switch (4.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[iClusterType.ordinal()]) {
                    case 1: {
                        network.writeString(iArguments.length > 0 ? (String)iArguments[0] : "").writeInt(iArguments.length > 0 ? (Integer)iArguments[1] : -1);
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        network.writeInt(iArguments.length > 0 ? (Integer)iArguments[0] : -1);
                        break;
                    }
                    ** default:
lbl22:
                    // 1 sources

                    break;
                }
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                clusterId = network.readShort();
                this.clustersIds.put(iClusterName.toLowerCase(), Integer.valueOf(clusterId));
                this.clustersTypes.put(iClusterName.toLowerCase(), iClusterType.toString());
                var6_9 = clusterId;
                this.endResponse(network);
                return var6_9;
            }
            catch (Throwable var7_10) {
                try {
                    this.endResponse(network);
                    throw var7_10;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on add new cluster", e);
                    continue;
                }
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dropCluster(int iClusterId) {
        this.checkConnection();
        while (true) {
            try {
                OChannelBinaryClient network = null;
                try {
                    network = this.beginRequest((byte)11);
                    network.writeShort((short)iClusterId);
                }
                finally {
                    this.endRequest(network);
                }
                try {
                    this.beginResponse(network);
                    if (network.readByte() == 1) {
                        for (Map.Entry<String, Integer> entry : this.clustersIds.entrySet()) {
                            if (entry.getValue() == null || entry.getValue() != iClusterId) continue;
                            this.clustersIds.remove(entry.getKey());
                            this.clustersTypes.remove(entry.getKey());
                            if (this.configuration.clusters.size() <= iClusterId) break;
                            this.configuration.dropCluster(iClusterId);
                            break;
                        }
                        this.getLevel2Cache().freeCluster(iClusterId);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                finally {
                    this.endResponse(network);
                }
            }
            catch (OException e) {
                throw e;
            }
            catch (Exception e) {
                this.handleException("Error on removing of cluster", e);
                continue;
            }
            break;
        }
    }

    public int addDataSegment(String iDataSegmentName) {
        return this.addDataSegment(iDataSegmentName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.checkConnection();
        while (true) {
            OChannelBinaryClient network = null;
            try {
                network = this.beginRequest((byte)20);
                network.writeString(iSegmentName).writeString(iSegmentFileName);
            }
            finally {
                this.endRequest(network);
            }
            try {
                this.beginResponse(network);
                short s = network.readShort();
                this.endResponse(network);
                return s;
            }
            catch (Throwable throwable) {
                try {
                    this.endResponse(network);
                    throw throwable;
                }
                catch (OException e) {
                    throw e;
                }
                catch (Exception e) {
                    this.handleException("Error on add new data segment", e);
                    continue;
                }
            }
            break;
        }
    }

    public void synch() {
    }

    public String getPhysicalClusterNameById(int iClusterId) {
        for (Map.Entry<String, Integer> clusterEntry : this.clustersIds.entrySet()) {
            if (clusterEntry.getValue() != iClusterId) continue;
            return clusterEntry.getKey();
        }
        return null;
    }

    public int getClusters() {
        return this.clustersIds.size();
    }

    public Collection<OCluster> getClusterInstances() {
        throw new UnsupportedOperationException("getClusters()");
    }

    public OCluster getClusterById(int iId) {
        throw new UnsupportedOperationException("getClusterById()");
    }

    public long getVersion() {
        throw new UnsupportedOperationException("getVersion");
    }

    public ODocument getClusterConfiguration() {
        return this.clusterConfiguration;
    }

    protected void handleException(String iMessage, Exception iException) {
        int currentRetryDelay;
        int currentMaxRetry;
        if (iException instanceof OException) {
            throw (OException)((Object)iException);
        }
        if (!(iException instanceof IOException)) {
            throw new OStorageException(iMessage, (Throwable)iException);
        }
        if (this.status != OStorageAbstract.STATUS.OPEN) {
            return;
        }
        long lostConnectionTime = System.currentTimeMillis();
        if (this.clusterConfiguration != null) {
            currentMaxRetry = 1;
            currentRetryDelay = 0;
        } else {
            currentMaxRetry = this.connectionRetry;
            currentRetryDelay = this.connectionRetryDelay;
        }
        for (int retry = 0; retry < currentMaxRetry; ++retry) {
            if (currentRetryDelay > 0) {
                try {
                    Thread.sleep(currentRetryDelay);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            try {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Retrying to connect to remote server #" + retry + "/" + currentMaxRetry + "...", new Object[0]);
                }
                this.openRemoteDatabase();
                OLogManager.instance().info((Object)this, "Connection re-acquired transparently after %dms and %d retries: no errors will be thrown at application level", new Object[]{System.currentTimeMillis() - lostConnectionTime, retry + 1});
                return;
            }
            catch (Throwable t) {
                if (this.clusterConfiguration == null) continue;
            }
        }
        throw new OStorageException(iMessage, (Throwable)iException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openRemoteDatabase() throws IOException {
        int sessionId;
        this.minPool = OGlobalConfiguration.CLIENT_CHANNEL_MIN_POOL.getValueAsInteger();
        this.maxPool = OGlobalConfiguration.CLIENT_CHANNEL_MAX_POOL.getValueAsInteger();
        if (this.connectionOptions != null && this.connectionOptions.size() > 0) {
            if (this.connectionOptions.containsKey(PARAM_MIN_POOL)) {
                this.minPool = Integer.parseInt(this.connectionOptions.get(PARAM_MIN_POOL).toString());
            }
            if (this.connectionOptions.containsKey(PARAM_MAX_POOL)) {
                this.maxPool = Integer.parseInt(this.connectionOptions.get(PARAM_MAX_POOL).toString());
            }
        }
        this.setSessionId(-1);
        this.createConnectionPool();
        OChannelBinaryClient network = null;
        try {
            network = this.beginRequest((byte)3);
            this.sendClientInfo(network);
            network.writeString(this.name).writeString(this.connectionUserName).writeString(this.connectionUserPassword);
        }
        finally {
            this.endRequest(network);
        }
        try {
            this.beginResponse(network);
            sessionId = network.readInt();
            OLogManager.instance().debug(null, "Client connected with session id: " + sessionId, new Object[0]);
            this.readDatabaseInformation(network);
            this.clusterConfiguration = new ODocument(network.readBytes());
        }
        finally {
            this.endResponse(network);
        }
        this.setSessionId(sessionId);
        this.defaultClusterId = this.clustersIds.get("default");
        this.status = OStorageAbstract.STATUS.OPEN;
    }

    protected void sendClientInfo(OChannelBinaryClient network) throws IOException {
        if (network.getSrvProtocolVersion() >= 7) {
            network.writeString(DRIVER_NAME).writeString("1.0rc8").writeShort((short)7).writeString(this.clientId);
        }
    }

    protected void parseServerURLs() {
        int dbPos = this.url.indexOf(47);
        if (dbPos == -1) {
            this.addHost(this.url);
            this.name = this.url;
        } else {
            this.name = this.url.substring(dbPos + 1);
            for (String host : this.url.substring(0, dbPos).split(ADDRESS_SEPARATOR)) {
                host = this.addHost(host);
            }
        }
        if (this.serverURLs.size() == 1 && OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_ENABLED.getValueAsBoolean()) {
            String primaryServer = this.serverURLs.get(0);
            try {
                Hashtable<String, String> env = new Hashtable<String, String>();
                env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
                env.put("com.sun.jndi.ldap.connect.timeout", OGlobalConfiguration.NETWORK_BINARY_DNS_LOADBALANCING_TIMEOUT.getValueAsString());
                InitialDirContext ictx = new InitialDirContext(env);
                String hostName = primaryServer.indexOf(":") == -1 ? primaryServer : primaryServer.substring(0, primaryServer.indexOf(":"));
                Attributes attrs = ictx.getAttributes(hostName, new String[]{"TXT"});
                Attribute attr = attrs.get("TXT");
                if (attr != null) {
                    String configuration = (String)attr.get();
                    if (configuration.startsWith("")) {
                        configuration = configuration.substring(1, configuration.length() - 1);
                    }
                    if (configuration != null) {
                        String[] parts;
                        for (String part : parts = configuration.split(" ")) {
                            if (!part.startsWith("s=")) continue;
                            this.addHost(part.substring("s=".length()));
                        }
                    }
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected String addHost(String host) {
        if (host.indexOf(":") == -1) {
            host = host + ":" + this.getDefaultPort();
        }
        if (!this.serverURLs.contains(host)) {
            this.serverURLs.add(host);
        }
        return host;
    }

    protected String getDefaultHost() {
        return DEFAULT_HOST;
    }

    protected int getDefaultPort() {
        return 2424;
    }

    protected OChannelBinaryClient createNetworkConnection() throws IOException, UnknownHostException {
        Iterator<String> i$ = this.serverURLs.iterator();
        if (i$.hasNext()) {
            String server = i$.next();
            OLogManager.instance().debug((Object)this, "Trying to connect to the remote host %s...", new Object[]{server});
            int sepPos = server.indexOf(":");
            String remoteHost = server.substring(0, sepPos);
            int remotePort = Integer.parseInt(server.substring(sepPos + 1));
            return new OChannelBinaryClient(remoteHost, remotePort, this.clientConfiguration, 7);
        }
        StringBuilder buffer = new StringBuilder();
        for (String server : this.serverURLs) {
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(server);
        }
        throw new OIOException("Cannot connect to any configured remote nodes: " + buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnection() {
        this.lock.acquireSharedLock();
        try {
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                if (networkPool.size() == 0) {
                    throw new ODatabaseException("Connection is closed");
                }
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OChannelBinaryClient beginRequest(byte iCommand) throws IOException {
        OChannelBinaryClient network = null;
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            int beginCursor = this.networkPoolCursor;
            while (network == null) {
                if (networkPool.size() == 0) {
                    throw new ONetworkProtocolException("Connection pool closed");
                }
                network = networkPool.get(this.networkPoolCursor);
                if (network.getLockWrite().tryLock()) break;
                network = null;
                ++this.networkPoolCursor;
                if (this.networkPoolCursor >= networkPool.size()) {
                    this.networkPoolCursor = 0;
                }
                if (this.networkPoolCursor != beginCursor) continue;
                if (networkPool.size() < this.maxPool) {
                    network = this.createNetworkConnection();
                    network.getLockWrite().lock();
                    networkPool.add(network);
                    continue;
                }
                long startToWait = System.currentTimeMillis();
                try {
                    networkPool.wait(5000L);
                    OProfiler.getInstance().updateCounter("network.connectionPool.timeout", 1L);
                }
                catch (InterruptedException e) {
                    break;
                }
                long elapsed = OProfiler.getInstance().stopChrono("network.connectionPool.waitingTime", startToWait);
            }
        }
        network.writeByte(iCommand);
        network.writeInt(this.getSessionId());
        return network;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRequest(OChannelBinaryClient iNetwork) throws IOException {
        if (iNetwork == null) {
            return;
        }
        try {
            iNetwork.flush();
        }
        finally {
            iNetwork.getLockWrite().unlock();
            List<OChannelBinaryClient> list = networkPool;
            synchronized (list) {
                networkPool.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeChannel(OChannelBinaryClient iNetwork) {
        iNetwork.close();
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            networkPool.remove(iNetwork);
        }
    }

    protected void beginResponse(OChannelBinaryClient iNetwork) throws IOException {
        iNetwork.beginResponse(this.getSessionId());
    }

    public void endResponse(OChannelBinaryClient iNetwork) {
        iNetwork.endResponse();
    }

    public boolean isPermanentRequester() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getResponse(OChannelBinaryClient iNetwork) throws IOException {
        try {
            this.beginResponse(iNetwork);
        }
        finally {
            this.endResponse(iNetwork);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterConfiguration(ODocument obj) {
        if (obj == null) {
            return;
        }
        ODocument oDocument = this.clusterConfiguration;
        synchronized (oDocument) {
            this.clusterConfiguration = obj;
            if (OLogManager.instance().isDebugEnabled()) {
                OLogManager.instance().debug((Object)this, "Received new cluster configuration: %s", new Object[]{this.clusterConfiguration.toJSON("")});
            }
        }
    }

    private void commitEntry(OChannelBinaryClient iNetwork, ORecordOperation txEntry) throws IOException {
        if (txEntry.type == 0) {
            return;
        }
        byte[] stream = null;
        try {
            switch (txEntry.type) {
                case 1: 
                case 3: {
                    stream = txEntry.getRecord().toStream();
                }
            }
        }
        catch (Exception e) {
            iNetwork.writeByte((byte)-1);
            throw new OTransactionException("Error on transaction commit", (Throwable)e);
        }
        iNetwork.writeByte((byte)1);
        iNetwork.writeByte(txEntry.type);
        iNetwork.writeShort((short)txEntry.getRecord().getIdentity().getClusterId());
        iNetwork.writeLong(txEntry.getRecord().getIdentity().getClusterPosition());
        iNetwork.writeByte(txEntry.getRecord().getRecordType());
        switch (txEntry.type) {
            case 3: {
                iNetwork.writeBytes(stream);
                break;
            }
            case 1: {
                iNetwork.writeInt(txEntry.getRecord().getVersion());
                iNetwork.writeBytes(stream);
                break;
            }
            case 2: {
                iNetwork.writeInt(txEntry.getRecord().getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createConnectionPool() throws IOException, UnknownHostException {
        List<OChannelBinaryClient> list = networkPool;
        synchronized (list) {
            if (!networkPool.isEmpty()) {
                ArrayList<OChannelBinaryClient> editableList = new ArrayList<OChannelBinaryClient>(networkPool);
                for (OChannelBinaryClient net : editableList) {
                    if (net.isConnected()) continue;
                    this.closeChannel(net);
                }
            }
            if (networkPool.size() == 0) {
                OChannelBinaryClient firstChannel = this.createNetworkConnection();
                networkPool.add(firstChannel);
                this.serviceThread = new OAsynchChannelServiceThread(this.asynchEventListener, firstChannel, "OrientDB <- Asynch Client (" + firstChannel.socket.getRemoteSocketAddress() + ")");
            }
            for (int i = networkPool.size(); i < this.minPool; ++i) {
                networkPool.add(this.createNetworkConnection());
            }
        }
    }

    private void readDatabaseInformation(OChannelBinaryClient network) throws IOException {
        int tot = network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt();
        this.clustersIds.clear();
        this.clustersTypes.clear();
        for (int i = 0; i < tot; ++i) {
            String clusterName = network.readString().toLowerCase();
            this.clustersIds.put(clusterName, network.getSrvProtocolVersion() >= 7 ? network.readShort() : network.readInt());
            this.clustersTypes.put(clusterName, network.readString());
        }
        this.defaultClusterId = this.clustersIds.get("default");
    }

    public String getClientId() {
        return this.clientId;
    }

    static class 4 {
        static final /* synthetic */ int[] $SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE;

        static {
            $SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE = new int[OStorage.CLUSTER_TYPE.values().length];
            try {
                4.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[OStorage.CLUSTER_TYPE.PHYSICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                4.$SwitchMap$com$orientechnologies$orient$core$storage$OStorage$CLUSTER_TYPE[OStorage.CLUSTER_TYPE.LOGICAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

