/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.collection.OMVRBTree;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringBuilderSerializable;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRID;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDEntryProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeRIDProvider
extends OMVRBTreeProviderAbstract<OIdentifiable, OIdentifiable>
implements OStringBuilderSerializable {
    public static final String PERSISTENT_CLASS_NAME = "ORIDs";
    private static final long serialVersionUID = 1L;
    private OMVRBTreeRID tree;
    private boolean embeddedStreaming = true;
    private final StringBuilder buffer = new StringBuilder();
    private boolean marshalling = true;

    public OMVRBTreeRIDProvider(OMVRBTreeRIDProvider iSource) {
        this(null, iSource.getClusterId(), iSource.getRoot());
        this.buffer.append((CharSequence)iSource.buffer);
        this.marshalling = false;
    }

    public OMVRBTreeRIDProvider(OStorage iStorage, int iClusterId, ORID iRID) {
        this(iStorage, OMVRBTreeRIDProvider.getDatabase().getClusterNameById(iClusterId));
        if (iRID != null) {
            this.root = (ORecordId)iRID.copy();
        }
        this.marshalling = false;
    }

    public OMVRBTreeRIDProvider(ORID iRID) {
        this(null, OMVRBTreeRIDProvider.getDatabase().getDefaultClusterId());
        if (iRID != null) {
            this.root = (ORecordId)iRID.copy();
        }
        this.marshalling = false;
    }

    public OMVRBTreeRIDProvider(OStorage iStorage, int iClusterId) {
        this(iStorage, OMVRBTreeRIDProvider.getDatabase().getClusterNameById(iClusterId));
        this.marshalling = false;
    }

    public OMVRBTreeRIDProvider(String iClusterName) {
        this(null, iClusterName);
        this.marshalling = false;
    }

    protected OMVRBTreeRIDProvider(OStorage iStorage, String iClusterName) {
        super(new ODocument(), iStorage, iClusterName);
        ((ODocument)this.record).field("pageSize", this.pageSize);
    }

    public OMVRBTreeRIDEntryProvider getEntry(ORID iRid) {
        return new OMVRBTreeRIDEntryProvider(this, iRid);
    }

    public OMVRBTreeRIDEntryProvider createEntry() {
        return new OMVRBTreeRIDEntryProvider(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OStringBuilderSerializable toStream(StringBuilder iBuffer) throws OSerializationException {
        long timer = OProfiler.getInstance().startChrono();
        if (this.buffer.length() > 0 && OMVRBTreeRIDProvider.getDatabase().getTransaction().isActive() && this.buffer.indexOf("-") > -1) {
            this.lazyUnmarshall();
            this.buffer.setLength(0);
        }
        this.tree.saveAllNewEntries();
        if (this.buffer.length() == 0) {
            try {
                if (this.isEmbeddedStreaming()) {
                    this.marshalling = true;
                    this.buffer.append('[');
                    boolean first = true;
                    for (OIdentifiable rid : this.tree.keySet()) {
                        if (!first) {
                            this.buffer.append(',');
                        } else {
                            first = false;
                        }
                        rid.getIdentity().toString(this.buffer);
                    }
                    IdentityHashMap<ORecord<?>, Object> tempRIDs = this.tree.getTemporaryEntries();
                    if (tempRIDs != null && !tempRIDs.isEmpty()) {
                        for (ORecord<?> rec : tempRIDs.keySet()) {
                            if (!first) {
                                this.buffer.append(',');
                            } else {
                                first = false;
                            }
                            rec.getIdentity().toString(this.buffer);
                        }
                    }
                    this.buffer.append(']');
                } else {
                    this.marshalling = true;
                    this.buffer.append('(');
                    this.buffer.append(new String(this.toDocument().toStream()));
                    this.buffer.append(')');
                }
                Object var9_7 = null;
                this.marshalling = false;
                OProfiler.getInstance().stopChrono("OMVRBTreeRIDProvider.toStream", timer);
            }
            catch (Throwable throwable) {
                Object var9_8 = null;
                this.marshalling = false;
                OProfiler.getInstance().stopChrono("OMVRBTreeRIDProvider.toStream", timer);
                throw throwable;
            }
            {
            }
        }
        iBuffer.append((CharSequence)this.buffer);
        return this;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        this.record.fromStream(iStream);
        this.fromDocument((ODocument)this.record);
        return this;
    }

    @Override
    public OStringBuilderSerializable fromStream(StringBuilder iInput) throws OSerializationException {
        if (iInput != null) {
            this.buffer.setLength(0);
            this.buffer.append((CharSequence)iInput);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lazyUnmarshall() {
        if (this.getSize() > 0 || this.marshalling || this.buffer.length() == 0) {
            return;
        }
        this.marshalling = true;
        try {
            String value;
            char firstChar = this.buffer.charAt(0);
            String string = value = firstChar == '[' ? this.buffer.substring(1, this.buffer.length() - 1) : this.buffer.toString();
            if (firstChar == '[' || firstChar == '#') {
                this.setEmbeddedStreaming(true);
                StringTokenizer tokenizer = new StringTokenizer(value, ",");
                while (tokenizer.hasMoreElements()) {
                    ORecordId rid = new ORecordId(tokenizer.nextToken());
                    this.tree.put(rid, rid);
                }
            } else {
                this.setEmbeddedStreaming(false);
                value = firstChar == '(' ? value.substring(1, value.length() - 1) : value.toString();
                this.fromStream(value.getBytes());
                this.tree.load();
            }
            Object var6_5 = null;
            this.marshalling = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.marshalling = false;
            throw throwable;
        }
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        return this.toDocument().toStream();
    }

    public OMVRBTree<OIdentifiable, OIdentifiable> getTree() {
        return this.tree;
    }

    public void setTree(OMVRBTreePersistent<OIdentifiable, OIdentifiable> tree) {
        this.tree = (OMVRBTreeRID)tree;
    }

    @Override
    public int getSize() {
        if (this.embeddedStreaming) {
            return this.size;
        }
        OMVRBTreeEntryPersistent r = (OMVRBTreeEntryPersistent)this.tree.getRoot();
        return r == null ? 0 : ((OMVRBTreeRIDEntryProvider)r.getProvider()).getTreeSize();
    }

    @Override
    public boolean setSize(int iSize) {
        if (this.embeddedStreaming) {
            super.setSize(iSize);
        } else {
            OMVRBTreeEntryPersistent r = (OMVRBTreeEntryPersistent)this.tree.getRoot();
            if (r != null) {
                OMVRBTreeRIDEntryProvider provider = (OMVRBTreeRIDEntryProvider)r.getProvider();
                if (provider != null && provider.setTreeSize(iSize)) {
                    r.markDirty();
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setDirty() {
        if (!this.marshalling) {
            if (this.buffer != null) {
                this.buffer.setLength(0);
            }
            return super.setDirty();
        }
        return false;
    }

    public ODocument toDocument() {
        this.tree.saveAllNewEntries();
        ODocument doc = (ODocument)this.record;
        doc.setClassName(PERSISTENT_CLASS_NAME);
        doc.field("root", this.root != null ? this.root : null);
        if (this.tree.getTemporaryEntries() != null && this.tree.getTemporaryEntries().size() > 0) {
            doc.field("tempEntries", new ArrayList(this.tree.getTemporaryEntries().keySet()));
        }
        return doc;
    }

    public void fromDocument(ODocument iDocument) {
        this.pageSize = (Integer)iDocument.field("pageSize");
        this.root = (ORecordId)iDocument.field("root", OType.LINK);
        Collection tempEntries = (Collection)iDocument.field("tempEntries");
        if (tempEntries != null && !tempEntries.isEmpty()) {
            for (OIdentifiable entry : tempEntries) {
                this.tree.put(entry, null);
            }
        }
    }

    public boolean isEmbeddedStreaming() {
        int binaryThreshold;
        if (this.embeddedStreaming && !this.marshalling && (binaryThreshold = OGlobalConfiguration.MVRBTREE_RID_BINARY_THRESHOLD.getValueAsInteger()) > 0 && this.getSize() > binaryThreshold && this.tree != null) {
            this.tree.setDirtyOwner();
            this.setEmbeddedStreaming(false);
        }
        return this.embeddedStreaming;
    }

    protected void setEmbeddedStreaming(boolean iValue) {
        if (this.embeddedStreaming != iValue) {
            this.embeddedStreaming = iValue;
            if (!iValue) {
                this.setSize(this.size);
            }
        }
    }

    @Override
    public boolean updateConfig() {
        this.pageSize = OGlobalConfiguration.MVRBTREE_RID_NODE_PAGE_SIZE.getValueAsInteger();
        return false;
    }
}

