/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ORecordBytesLazy;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerFactory;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapEntryProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeMapProvider<K, V>
extends OMVRBTreeProviderAbstract<K, V> {
    private static final long serialVersionUID = 1L;
    public static final byte CURRENT_PROTOCOL_VERSION = 0;
    protected final OMemoryStream stream;
    protected OStreamSerializer keySerializer;
    protected OStreamSerializer valueSerializer;
    protected boolean keepKeysInMemory;
    protected boolean keepValuesInMemory;

    public OMVRBTreeMapProvider(OStorage iStorage, String iClusterName, ORID iRID) {
        this(iStorage, iClusterName, null, null);
        this.record.setIdentity(iRID.getClusterId(), iRID.getClusterPosition());
    }

    public OMVRBTreeMapProvider(OStorage iStorage, String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(new ORecordBytesLazy(), iStorage, iClusterName);
        ((ORecordBytesLazy)this.record).recycle(this);
        this.stream = new OMemoryStream();
        this.keySerializer = iKeySerializer;
        this.valueSerializer = iValueSerializer;
    }

    @Override
    public OMVRBTreeEntryDataProvider<K, V> getEntry(ORID iRid) {
        return new OMVRBTreeMapEntryProvider(this, iRid);
    }

    @Override
    public OMVRBTreeEntryDataProvider<K, V> createEntry() {
        return new OMVRBTreeMapEntryProvider(this);
    }

    @Override
    protected void load(ODatabaseRecord iDb) {
        ((ORecordBytesLazy)this.record).recycle(this);
        super.load(iDb);
    }

    @Override
    protected void load(OStorage iSt) {
        ((ORecordBytesLazy)this.record).recycle(this);
        super.load(iSt);
    }

    @Override
    public boolean updateConfig() {
        boolean changed = super.updateConfig();
        this.keepKeysInMemory = OGlobalConfiguration.MVRBTREE_ENTRY_KEYS_IN_MEMORY.getValueAsBoolean();
        this.keepValuesInMemory = OGlobalConfiguration.MVRBTREE_ENTRY_VALUES_IN_MEMORY.getValueAsBoolean();
        return changed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] byArray;
        long timer = OProfiler.getInstance().startChrono();
        try {
            this.stream.jump(0);
            this.stream.set((byte)0);
            this.stream.setAsFixed(this.root != null ? this.root.toStream() : ORecordId.EMPTY_RECORD_ID_STREAM);
            this.stream.set(this.size);
            this.stream.set(this.pageSize);
            this.stream.set(this.keySerializer.getName());
            this.stream.set(this.valueSerializer.getName());
            byte[] result = this.stream.toByteArray();
            this.record.fromStream(result);
            byArray = result;
            Object var6_4 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapProvider.toStream", timer);
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapProvider.toStream", timer);
            throw throwable;
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        long timer = OProfiler.getInstance().startChrono();
        try {
            try {
                this.stream.setSource(iStream);
                byte protocolVersion = this.stream.peek();
                if (protocolVersion != -1) {
                    this.stream.getAsByte();
                    if (protocolVersion != 0) {
                        throw new OSerializationException("The index has been created with a previous version of OrientDB. Soft transitions between versions is supported since 0.9.25. To use it with this version of OrientDB you need to export and import your database. " + protocolVersion + "<->" + 0);
                    }
                }
                this.root = new ORecordId();
                this.root.fromStream(this.stream.getAsByteArrayFixed(10));
                this.size = this.stream.getAsInteger();
                this.pageSize = protocolVersion == -1 ? (int)this.stream.getAsShort() : this.stream.getAsInteger();
                this.serializerFromStream(this.stream);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on unmarshalling OMVRBTreeMapProvider object from record: %s", (Throwable)e, OSerializationException.class, this.root);
                Object var6_6 = null;
                OProfiler.getInstance().stopChrono("OMVRBTreeMapProvider.fromStream", timer);
                return this;
            }
            Object var6_5 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapProvider.fromStream", timer);
            return this;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapProvider.fromStream", timer);
            throw throwable;
        }
    }

    protected void serializerFromStream(OMemoryStream stream) throws IOException {
        this.keySerializer = OStreamSerializerFactory.get(stream.getAsString());
        this.valueSerializer = OStreamSerializerFactory.get(stream.getAsString());
    }
}

