/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProviderAbstract;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapProvider;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeMapEntryProvider<K, V>
extends OMVRBTreeEntryDataProviderAbstract<K, V> {
    private static final long serialVersionUID = 1L;
    protected K[] keys;
    protected V[] values;
    protected int[] serializedKeys;
    protected int[] serializedValues;

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider) {
        super(iTreeDataProvider, 1024);
        this.keys = new Object[this.pageSize];
        this.values = new Object[this.pageSize];
        this.serializedKeys = new int[this.pageSize];
        this.serializedValues = new int[this.pageSize];
    }

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider, ORID iRID) {
        super(iTreeDataProvider, iRID);
    }

    @Override
    public K getKeyAt(int iIndex) {
        Object k = this.keys[iIndex];
        if (k == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.unserializeKey", 1L);
                k = this.keyFromStream(iIndex);
                if (iIndex == 0 || iIndex == this.size || ((OMVRBTreeMapProvider)this.treeDataProvider).keepKeysInMemory) {
                    this.keys[iIndex] = k;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the key #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return k;
    }

    @Override
    public V getValueAt(int iIndex) {
        Object v = this.values[iIndex];
        if (v == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.unserializeValue", 1L);
                v = this.valueFromStream(iIndex);
                if (((OMVRBTreeMapProvider)this.treeDataProvider).keepValuesInMemory) {
                    this.values[iIndex] = v;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the value #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return v;
    }

    @Override
    public boolean setValueAt(int iIndex, V iValue) {
        this.values[iIndex] = iValue;
        this.serializedValues[iIndex] = 0;
        return this.setDirty();
    }

    @Override
    public boolean insertAt(int iIndex, K iKey, V iValue) {
        if (iIndex < this.size) {
            System.arraycopy(this.keys, iIndex, this.keys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.values, iIndex, this.values, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedKeys, iIndex, this.serializedKeys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedValues, iIndex, this.serializedValues, iIndex + 1, this.size - iIndex);
        }
        this.keys[iIndex] = iKey;
        this.values[iIndex] = iValue;
        this.serializedKeys[iIndex] = 0;
        this.serializedValues[iIndex] = 0;
        ++this.size;
        return this.setDirty();
    }

    @Override
    public boolean removeAt(int iIndex) {
        if (iIndex != this.size - 1 && iIndex > -1) {
            System.arraycopy(this.keys, iIndex + 1, this.keys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.values, iIndex + 1, this.values, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedKeys, iIndex + 1, this.serializedKeys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedValues, iIndex + 1, this.serializedValues, iIndex, this.size - iIndex - 1);
        }
        --this.size;
        this.serializedKeys[this.size] = 0;
        this.serializedValues[this.size] = 0;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        return this.setDirty();
    }

    @Override
    public boolean copyDataFrom(OMVRBTreeEntryDataProvider<K, V> iFrom, int iStartPosition) {
        OMVRBTreeMapEntryProvider parent = (OMVRBTreeMapEntryProvider)iFrom;
        this.size = iFrom.getSize() - iStartPosition;
        System.arraycopy(parent.serializedKeys, iStartPosition, this.serializedKeys, 0, this.size);
        System.arraycopy(parent.serializedValues, iStartPosition, this.serializedValues, 0, this.size);
        System.arraycopy(parent.keys, iStartPosition, this.keys, 0, this.size);
        System.arraycopy(parent.values, iStartPosition, this.values, 0, this.size);
        this.stream.setSource(parent.stream.copy());
        return this.setDirty();
    }

    @Override
    public boolean truncate(int iNewSize) {
        Arrays.fill(this.serializedKeys, iNewSize, this.pageSize, 0);
        Arrays.fill(this.serializedValues, iNewSize, this.pageSize, 0);
        Arrays.fill(this.keys, iNewSize, this.size, null);
        Arrays.fill(this.values, iNewSize, this.size, null);
        this.size = iNewSize;
        return this.setDirty();
    }

    @Override
    public boolean copyFrom(OMVRBTreeEntryDataProvider<K, V> iSource) {
        OMVRBTreeMapEntryProvider source = (OMVRBTreeMapEntryProvider)iSource;
        this.serializedKeys = new int[source.serializedKeys.length];
        System.arraycopy(source.serializedKeys, 0, this.serializedKeys, 0, source.serializedKeys.length);
        this.serializedValues = new int[source.serializedValues.length];
        System.arraycopy(source.serializedValues, 0, this.serializedValues, 0, source.serializedValues.length);
        this.keys = new Object[source.keys.length];
        System.arraycopy(source.keys, 0, this.keys, 0, source.keys.length);
        this.values = new Object[source.values.length];
        System.arraycopy(source.values, 0, this.values, 0, source.values.length);
        this.size = source.size;
        this.stream.setSource(source.stream.copy());
        return this.setDirty();
    }

    @Override
    public void delete() {
        super.delete();
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        OMVRBTreeMapEntryProvider oMVRBTreeMapEntryProvider;
        long timer = OProfiler.getInstance().startChrono();
        if (this.stream == null) {
            this.stream = new OMemoryStream(iStream);
        } else {
            this.stream.setSource(iStream);
        }
        try {
            int i;
            this.pageSize = this.stream.getAsInteger();
            this.parentRid = new ORecordId().fromStream(this.stream.getAsByteArrayFixed(10));
            this.leftRid = new ORecordId().fromStream(this.stream.getAsByteArrayFixed(10));
            this.rightRid = new ORecordId().fromStream(this.stream.getAsByteArrayFixed(10));
            this.color = this.stream.getAsBoolean();
            this.size = this.stream.getAsInteger();
            if (this.size > this.pageSize) {
                throw new OConfigurationException("Loaded index with page size setted to " + this.pageSize + " while the loaded was built with: " + this.size);
            }
            this.serializedKeys = new int[this.pageSize];
            for (i = 0; i < this.size; ++i) {
                this.serializedKeys[i] = this.stream.getAsByteArrayOffset();
            }
            this.keys = new Object[this.pageSize];
            this.serializedValues = new int[this.pageSize];
            for (i = 0; i < this.size; ++i) {
                this.serializedValues[i] = this.stream.getAsByteArrayOffset();
            }
            this.values = new Object[this.pageSize];
            oMVRBTreeMapEntryProvider = this;
            Object var6_5 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.fromStream", timer);
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.fromStream", timer);
            throw throwable;
        }
        return oMVRBTreeMapEntryProvider;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] byArray;
        long timer = OProfiler.getInstance().startChrono();
        try {
            int i;
            OMemoryStream outStream = new OMemoryStream();
            outStream.jump(0);
            outStream.set(this.pageSize);
            outStream.setAsFixed(this.parentRid.toStream());
            outStream.setAsFixed(this.leftRid.toStream());
            outStream.setAsFixed(this.rightRid.toStream());
            outStream.set(this.color);
            outStream.set(this.size);
            for (i = 0; i < this.size; ++i) {
                this.serializedKeys[i] = outStream.set(this.serializeNewKey(i));
            }
            for (i = 0; i < this.size; ++i) {
                this.serializedValues[i] = outStream.set(this.serializeNewValue(i));
            }
            byte[] buffer = outStream.toByteArray();
            this.stream.setSource(buffer);
            this.record.fromStream(buffer);
            byArray = buffer;
            Object var7_7 = null;
            OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.toStream", timer);
        }
        catch (IOException e) {
            try {
                throw new OSerializationException("Cannot marshall RB+Tree node", e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.toStream", timer);
                throw throwable;
            }
        }
        return byArray;
    }

    protected byte[] serializeNewKey(int iIndex) throws IOException {
        if (this.serializedKeys[iIndex] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.serializeValue", 1L);
            return ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer.toStream(this.keys[iIndex]);
        }
        return this.stream.getAsByteArray(this.serializedKeys[iIndex]);
    }

    protected byte[] serializeNewValue(int iIndex) throws IOException {
        if (this.serializedValues[iIndex] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.serializeKey", 1L);
            return ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.toStream(this.values[iIndex]);
        }
        return this.stream.getAsByteArray(this.serializedValues[iIndex]);
    }

    protected Object keyFromStream(int iIndex) throws IOException {
        return ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer.fromStream(this.stream.getAsByteArray(this.serializedKeys[iIndex]));
    }

    protected Object valueFromStream(int iIndex) throws IOException {
        return ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.fromStream(this.stream.getAsByteArray(this.serializedValues[iIndex]));
    }
}

