/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ORecordBytesLazy;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OMVRBTreeEntryDataProviderAbstract<K, V>
implements OMVRBTreeEntryDataProvider<K, V>,
OSerializableStream {
    private static final long serialVersionUID = 1L;
    protected final OMVRBTreeProviderAbstract<K, V> treeDataProvider;
    protected int size = 0;
    protected int pageSize;
    protected ORecordId parentRid;
    protected ORecordId leftRid;
    protected ORecordId rightRid;
    protected boolean color = false;
    protected ORecordBytesLazy record;
    protected OMemoryStream stream;

    public OMVRBTreeEntryDataProviderAbstract(OMVRBTreeProviderAbstract<K, V> iTreeDataProvider, int iFixedSize) {
        this(iTreeDataProvider, null);
        this.pageSize = this.treeDataProvider.getDefaultPageSize();
        this.stream = new OMemoryStream(iFixedSize);
    }

    public OMVRBTreeEntryDataProviderAbstract(OMVRBTreeProviderAbstract<K, V> iTreeDataProvider, ORID iRID) {
        this.treeDataProvider = iTreeDataProvider;
        this.parentRid = new ORecordId();
        this.leftRid = new ORecordId();
        this.rightRid = new ORecordId();
        this.record = new ORecordBytesLazy(this);
        if (iRID != null) {
            this.record.setIdentity(iRID.getClusterId(), iRID.getClusterPosition());
            if (this.treeDataProvider.storage == null) {
                this.load(OMVRBTreeProviderAbstract.getDatabase());
            } else {
                this.load(this.treeDataProvider.storage);
            }
        } else {
            this.record.setIdentity(new ORecordId());
        }
    }

    protected void load(ODatabaseRecord iDb) {
        try {
            this.record.reload();
        }
        catch (Exception e) {
            OLogManager.instance().warn((Object)this, "Error on loading index node record %s", e, this.record.getIdentity());
        }
        this.record.recycle(this);
        this.fromStream(this.record.toStream());
    }

    protected void load(OStorage iStorage) {
        ORawBuffer raw = iStorage.readRecord((ORecordId)this.record.getIdentity(), null, null);
        this.record.fill((ORecordId)this.record.getIdentity(), raw.version, raw.buffer, false);
        this.fromStream(raw.buffer);
    }

    @Override
    public ORID getIdentity() {
        return this.record.getIdentity();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getPageSize() {
        return this.pageSize;
    }

    @Override
    public ORID getParent() {
        return this.parentRid;
    }

    @Override
    public ORID getLeft() {
        return this.leftRid;
    }

    @Override
    public ORID getRight() {
        return this.rightRid;
    }

    @Override
    public boolean setLeft(ORID iRid) {
        if (this.leftRid.equals(iRid)) {
            return false;
        }
        this.leftRid.copyFrom(iRid);
        return this.setDirty();
    }

    @Override
    public boolean setRight(ORID iRid) {
        if (this.rightRid.equals(iRid)) {
            return false;
        }
        this.rightRid.copyFrom(iRid);
        return this.setDirty();
    }

    @Override
    public boolean setParent(ORID iRid) {
        if (this.parentRid.equals(iRid)) {
            return false;
        }
        this.parentRid.copyFrom(iRid);
        return this.setDirty();
    }

    @Override
    public boolean getColor() {
        return this.color;
    }

    @Override
    public boolean setColor(boolean iColor) {
        this.color = iColor;
        return this.setDirty();
    }

    @Override
    public boolean isEntryDirty() {
        return this.record.isDirty();
    }

    @Override
    public void save() {
        if (this.treeDataProvider.storage == null) {
            this.save(OMVRBTreeProviderAbstract.getDatabase());
        } else {
            this.save(this.treeDataProvider.storage);
        }
    }

    protected void save(ODatabaseRecord iDb) {
        if (iDb == null) {
            throw new IllegalStateException("Current thread has no database set and the tree cannot be saved correctly. Ensure that the database is closed before the application if off.");
        }
        this.record.save(this.treeDataProvider.clusterName);
    }

    protected void save(OStorage iSt) {
        this.record.fromStream(this.toStream());
        if (this.record.getIdentity().isValid()) {
            this.record.setVersion(iSt.updateRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), -1, this.record.getRecordType(), 0, null));
        } else {
            if (this.record.getIdentity().getClusterId() == -1) {
                ((ORecordId)this.record.getIdentity()).clusterId = this.treeDataProvider.clusterId;
            }
            this.record.setIdentity(this.record.getIdentity().getClusterId(), iSt.createRecord((ORecordId)this.record.getIdentity(), this.record.toStream(), this.record.getRecordType(), 0, null));
        }
        this.record.unsetDirty();
    }

    @Override
    public void delete() {
        if (this.treeDataProvider.storage == null) {
            this.delete((ODatabaseRecord)null);
        } else {
            this.delete(this.treeDataProvider.storage);
        }
    }

    protected void delete(ODatabaseRecord iDb) {
        this.record.delete();
    }

    protected void delete(OStorage iSt) {
        iSt.deleteRecord((ORecordId)this.record.getIdentity(), this.record.getVersion(), 0, null);
    }

    @Override
    public void clear() {
        if (this.stream != null) {
            this.stream.close();
            this.stream = null;
        }
        this.record.recycle(null);
        this.record = null;
        this.size = 0;
    }

    protected boolean setDirty() {
        if (this.record.isDirty()) {
            return false;
        }
        this.record.setDirty();
        return true;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("mvrb-tree entry ");
        buffer.append(this.record.getIdentity());
        buffer.append(" (size=");
        buffer.append(this.size);
        if (this.size > 0) {
            buffer.append(" [");
            if (this.size > 1) {
                buffer.append(this.getKeyAt(0));
                buffer.append(" ... ");
                buffer.append(this.getKeyAt(this.size - 1));
            } else {
                buffer.append(this.getKeyAt(0));
            }
            buffer.append("]");
        }
        buffer.append(")");
        return buffer.toString();
    }
}

