/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeDatabase<K, V>
extends OMVRBTreePersistent<K, V> {
    public OMVRBTreeDatabase(OMVRBTreeProvider<K, V> iProvider) {
        super(iProvider);
    }

    public OMVRBTreeDatabase(ODatabaseRecord iDatabase, ORID iRID) {
        super(new OMVRBTreeMapProvider(null, iDatabase.getClusterNameById(iRID.getClusterId()), iRID));
    }

    public OMVRBTreeDatabase(ODatabaseRecord iDatabase, String iClusterName, OStreamSerializer iKeySerializer, OStreamSerializer iValueSerializer) {
        super(new OMVRBTreeMapProvider(null, iClusterName, iKeySerializer, iValueSerializer));
    }

    public void onAfterTxCommit() {
        Set<ORID> nodesInMemory = this.getAllNodesInCache();
        if (nodesInMemory.isEmpty()) {
            return;
        }
        HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
        for (ORID rid : keys) {
            if (rid.getClusterPosition() >= -1L) continue;
            OMVRBTreeEntryPersistent entry = this.searchNodeInCache(rid);
            this.removeNodeFromCache(rid);
            this.addNodeInCache(entry);
        }
    }
}

