/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterMemory
extends OSharedResourceAbstract
implements OCluster {
    public static final String TYPE = "MEMORY";
    private int id;
    private String name;
    private List<OPhysicalPosition> entries = new ArrayList<OPhysicalPosition>();
    private List<Integer> removed = new ArrayList<Integer>();

    public OClusterMemory(int id, String name) {
        this.id = id;
        this.name = name;
    }

    public OClusterPositionIterator absoluteIterator() {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void open() throws IOException {
    }

    public void create(int iStartSize) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.close();
            this.entries.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.name = stringValue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEntries() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() - this.removed.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() {
        long l;
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (OPhysicalPosition e : this.entries) {
                if (e == null) continue;
                size += (long)e.recordSize;
            }
            l = size;
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    public long getRecordsSize() throws IOException {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstEntryPosition() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() == 0 ? -1L : 0L;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastEntryPosition() {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size() - 1;
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getAvailablePosition() throws IOException {
        long l;
        this.acquireSharedLock();
        try {
            l = this.entries.size();
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addPhysicalPosition(int iDataSegmentId, long iRecordPosition, byte iRecordType) {
        block3: {
            long l;
            this.acquireExclusiveLock();
            try {
                if (this.removed.isEmpty()) break block3;
                int recycledPosition = this.removed.remove(this.removed.size() - 1);
                this.entries.set(recycledPosition, new OPhysicalPosition(iDataSegmentId, iRecordPosition, iRecordType));
                l = recycledPosition;
                Object var9_7 = null;
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.releaseExclusiveLock();
                throw throwable;
            }
            this.releaseExclusiveLock();
            return l;
        }
        this.entries.add(new OPhysicalPosition(iDataSegmentId, iRecordPosition, iRecordType));
        long l = this.entries.size() - 1;
        Object var9_8 = null;
        this.releaseExclusiveLock();
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).type = iRecordType;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVersion(long iPosition, int iVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).version = iVersion;
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPhysicalPosition getPhysicalPosition(long iPosition, OPhysicalPosition iPPosition) {
        OPhysicalPosition oPhysicalPosition;
        this.acquireSharedLock();
        try {
            oPhysicalPosition = this.entries.get((int)iPosition);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            this.releaseSharedLock();
            throw throwable;
        }
        this.releaseSharedLock();
        return oPhysicalPosition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePhysicalPosition(long iPosition, OPhysicalPosition iPPosition) {
        this.acquireExclusiveLock();
        try {
            if (this.entries.set((int)iPosition, null) != null) {
                this.removed.add(new Integer((int)iPosition));
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalPosition(long iPosition, long iDataPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            ppos.dataChunkPosition = iDataPosition;
            Object var7_4 = null;
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPhysicalPosition(long iPosition, int iDataId, long iDataPosition, byte iRecordType, int iVersion) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            ppos.dataSegmentId = iDataId;
            ppos.dataChunkPosition = iDataPosition;
            ppos.type = iRecordType;
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            this.releaseExclusiveLock();
            throw throwable;
        }
        this.releaseExclusiveLock();
    }

    public void synch() {
    }

    public void lock() {
        this.acquireSharedLock();
    }

    public void unlock() {
        this.releaseSharedLock();
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return "OClusterMemory [name=" + this.name + ", id=" + this.id + ", entries=" + this.entries.size() + ", removed=" + this.removed + "]";
    }
}

