/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTxSegment
extends OSingleFileSegment {
    public static final byte STATUS_FREE = 0;
    public static final byte STATUS_COMMITTING = 1;
    public static final byte OPERATION_CREATE = 0;
    public static final byte OPERATION_DELETE = 1;
    public static final byte OPERATION_UPDATE = 2;
    private static final int DEF_START_SIZE = 262144;
    private static final int OFFSET_TX_ID = 2;
    private static final int OFFSET_RECORD_SIZE = 21;
    private static final int OFFSET_RECORD_CONTENT = 25;
    private final boolean synchEnabled = OGlobalConfiguration.TX_LOG_SYNCH.getValueAsBoolean();

    public OTxSegment(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        super(iStorage, iConfig, OGlobalConfiguration.TX_LOG_TYPE.getValueAsString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean open() throws IOException {
        this.acquireExclusiveLock();
        try {
            super.open();
            this.recoverTransactions();
            boolean bl = true;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(int iStartSize) throws IOException {
        super.create(iStartSize > -1 ? iStartSize : 262144);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLog(byte iOperation, int iTxId, int iClusterId, long iClusterOffset, byte iRecordType, int iRecordVersion, byte[] iRecordContent) throws IOException {
        int contentSize = iRecordContent != null ? iRecordContent.length : 0;
        this.acquireExclusiveLock();
        try {
            int size = 25 + contentSize;
            int offset = this.file.allocateSpace(size);
            this.file.writeByte(offset, (byte)1);
            this.file.writeByte(++offset, iOperation);
            this.file.writeInt(++offset, iTxId);
            this.file.writeShort(offset += 4, (short)iClusterId);
            this.file.writeLong(offset += 2, iClusterOffset);
            this.file.writeByte(offset += 8, iRecordType);
            this.file.writeInt(++offset, iRecordVersion);
            this.file.writeInt(offset += 4, contentSize);
            this.file.write(offset += 4, iRecordContent);
            offset += contentSize;
            if (this.synchEnabled) {
                this.file.synch();
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void clearLogEntries(int iTxId) throws IOException {
        this.truncate();
    }

    public void rollback(OTransaction iTx) throws IOException {
        this.recoverTransaction(iTx.getId());
    }

    private void recoverTransactions() throws IOException {
        if (this.file.getFilledUpTo() == 0) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Started the recovering of pending transactions after a hard shutdown. Scanning...", new Object[0]);
        int recoveredTxs = 0;
        int recoveredRecords = 0;
        Set<Integer> txToRecover = this.scanForTransactionsToRecover();
        for (Integer txId : txToRecover) {
            int recs = this.recoverTransaction(txId);
            if (recs <= 0) continue;
            ++recoveredTxs;
            recoveredRecords += recs;
        }
        this.file.shrink(0);
        if (recoveredRecords > 0) {
            OLogManager.instance().warn((Object)this, "Recovering successfully completed:", new Object[0]);
            OLogManager.instance().warn((Object)this, "- Recovered Tx.....: " + recoveredTxs, new Object[0]);
            OLogManager.instance().warn((Object)this, "- Recovered Records: " + recoveredRecords, new Object[0]);
        } else {
            OLogManager.instance().debug((Object)this, "Recovering successfully completed: no pending tx records found.", new Object[0]);
        }
    }

    private Set<Integer> scanForTransactionsToRecover() throws IOException {
        HashSet<Integer> txToRecover = new HashSet<Integer>();
        HashSet<Integer> txToNotRecover = new HashSet<Integer>();
        long offset = 0L;
        while (this.eof(offset)) {
            byte status = this.file.readByte(offset);
            int txId = this.file.readInt(offset + 2L);
            switch (status) {
                case 0: {
                    txToNotRecover.add(txId);
                    break;
                }
                case 1: {
                    txToRecover.add(txId);
                }
            }
            offset = this.nextEntry(offset);
        }
        if (txToNotRecover.size() > 0) {
            txToRecover.removeAll(txToNotRecover);
        }
        return txToRecover;
    }

    private int recoverTransaction(int iTxId) throws IOException {
        OPhysicalPosition ppos = new OPhysicalPosition();
        int recordsRecovered = 0;
        ORecordId rid = new ORecordId();
        long beginEntry = 0L;
        while (this.eof(beginEntry)) {
            long offset = beginEntry;
            byte status = this.file.readByte(offset);
            ++offset;
            if (status != 0) {
                int txId;
                byte operation = this.file.readByte(offset);
                if ((txId = this.file.readInt(++offset)) == iTxId) {
                    byte[] buffer;
                    rid.clusterId = this.file.readShort(offset += 4L);
                    rid.clusterPosition = this.file.readLong(offset += 2L);
                    byte recordType = this.file.readByte(offset += 8L);
                    int recordVersion = this.file.readInt(++offset);
                    int recordSize = this.file.readInt(offset += 4L);
                    offset += 4L;
                    if (recordSize > 0) {
                        buffer = new byte[recordSize];
                        this.file.read(offset, buffer, recordSize);
                        offset += (long)recordSize;
                    } else {
                        buffer = null;
                    }
                    this.recoverTransactionEntry(status, operation, txId, rid, recordType, recordVersion, buffer, ppos);
                    ++recordsRecovered;
                    this.file.writeByte(beginEntry, (byte)0);
                }
            }
            beginEntry = this.nextEntry(beginEntry);
        }
        return recordsRecovered;
    }

    private void recoverTransactionEntry(byte iStatus, byte iOperation, int iTxId, ORecordId iRid, byte iRecordType, int iRecordVersion, byte[] iRecordContent, OPhysicalPosition ppos) throws IOException {
        OClusterLocal cluster = (OClusterLocal)this.storage.getClusterById(iRid.clusterId);
        if (!(cluster instanceof OClusterLocal)) {
            return;
        }
        OLogManager.instance().debug((Object)this, "Recovering tx <%d>. Operation <%d> was in status <%d> on record %s size=%d...", iTxId, iOperation, iStatus, iRid, iRecordContent != null ? iRecordContent.length : 0);
        switch (iOperation) {
            case 0: {
                this.storage.deleteRecord(iRid, -1, 0, null);
                break;
            }
            case 2: {
                this.storage.updateRecord(cluster, iRid, iRecordContent, -3, iRecordType);
                break;
            }
            case 1: {
                cluster.removeHole(iRid.clusterPosition);
                cluster.updateBoundsAfterInsertion(iRid.clusterPosition);
                this.storage.updateRecord(cluster, iRid, iRecordContent, iRecordVersion, iRecordType);
            }
        }
    }

    private boolean eof(long iOffset) {
        return iOffset < (long)this.file.getFilledUpTo();
    }

    private long nextEntry(long iOffset) throws IOException {
        int recordSize = this.file.readInt(iOffset + 21L);
        return iOffset + 25L + (long)recordSize;
    }
}

