/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageTxConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OTransactionException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.core.storage.impl.local.OTxSegment;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import java.io.IOException;
import java.util.ArrayList;

public class OStorageLocalTxExecuter {
    private final OStorageLocal storage;
    private final OTxSegment txSegment;

    public OStorageLocalTxExecuter(OStorageLocal iStorage, OStorageTxConfiguration iConfig) throws IOException {
        this.storage = iStorage;
        iConfig.path = "${STORAGE_PATH}/txlog.otx";
        this.txSegment = new OTxSegment(this.storage, iStorage.getConfiguration().txSegment);
    }

    public void open() throws IOException {
        this.txSegment.open();
    }

    public void create() throws IOException {
        this.txSegment.create(1000000);
    }

    public void close() throws IOException {
        this.txSegment.close();
    }

    protected long createRecord(int iTxId, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, byte iRecordType) throws IOException {
        iRid.clusterPosition = -1L;
        try {
            iRid.clusterPosition = this.storage.createRecord(iClusterSegment, iContent, iRecordType);
            this.txSegment.addLog((byte)0, iTxId, iRid.clusterId, iRid.clusterPosition, iRecordType, 0, null);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on creating entry in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
        }
        return iRid.clusterPosition;
    }

    protected int updateRecord(int iTxId, OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        try {
            ORawBuffer buffer = this.storage.readRecord(iClusterSegment, iRid, false);
            this.txSegment.addLog((byte)2, iTxId, iRid.clusterId, iRid.clusterPosition, iRecordType, buffer.version - 1, buffer.buffer);
            return this.storage.updateRecord(iClusterSegment, iRid, iContent, iVersion, iRecordType);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on updating entry #" + iRid + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
            return -1;
        }
    }

    protected void deleteRecord(int iTxId, OCluster iClusterSegment, long iPosition, int iVersion) {
        try {
            ORecordId rid = new ORecordId(iClusterSegment.getId(), iPosition);
            ORawBuffer buffer = this.storage.readRecord(iClusterSegment, rid, false);
            this.txSegment.addLog((byte)1, iTxId, iClusterSegment.getId(), iPosition, buffer.recordType, buffer.version, buffer.buffer);
            this.storage.deleteRecord(iClusterSegment, rid, iVersion);
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on deleting entry #" + iPosition + " in log segment: " + iClusterSegment, (Throwable)e, OTransactionException.class, new Object[0]);
        }
    }

    public OTxSegment getTxSegment() {
        return this.txSegment;
    }

    public void commitAllPendingRecords(OTransaction iTx) throws IOException {
        ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
        while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
            for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                tmpEntries.add(oRecordOperation);
            }
            iTx.clearRecordEntries();
            if (tmpEntries.isEmpty()) continue;
            for (ORecordOperation oRecordOperation : tmpEntries) {
                this.commitEntry(iTx, oRecordOperation, iTx.isUsingLog());
            }
        }
        OTransactionAbstract.updateCacheFromEntries(this.storage, iTx, iTx.getAllRecordEntries(), true);
    }

    public void clearLogEntries(OTransaction iTx) throws IOException {
        this.txSegment.clearLogEntries(iTx.getId());
    }

    private void commitEntry(OTransaction iTx, ORecordOperation txEntry, boolean iUseLog) throws IOException {
        OCluster cluster;
        if (txEntry.type != 2 && !txEntry.getRecord().isDirty()) {
            return;
        }
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        if (rid.clusterId == -1 && txEntry.getRecord() instanceof ODocument && ((ODocument)txEntry.getRecord()).getSchemaClass() != null) {
            rid.clusterId = ((ODocument)txEntry.getRecord()).getSchemaClass().getDefaultClusterId();
        }
        if ((cluster = this.storage.getClusterById(rid.clusterId)).getName().equals("index")) {
            return;
        }
        if (!(cluster instanceof OClusterLocal)) {
            return;
        }
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, txEntry.getRecord())) {
                        stream = txEntry.getRecord().toStream();
                    }
                    rid.clusterId = cluster.getId();
                    rid.clusterPosition = iUseLog ? this.createRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getRecordType()) : iTx.getDatabase().getStorage().createRecord(rid, stream, txEntry.getRecord().getRecordType(), 0, null);
                    iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_CREATE, txEntry.getRecord());
                    break;
                }
                if (iUseLog) {
                    txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                    break;
                }
                txEntry.getRecord().setVersion(iTx.getDatabase().getStorage().updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, txEntry.getRecord())) {
                    stream = txEntry.getRecord().toStream();
                }
                if (iUseLog) {
                    txEntry.getRecord().setVersion(this.updateRecord(iTx.getId(), cluster, rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType()));
                } else {
                    txEntry.getRecord().setVersion(iTx.getDatabase().getStorage().updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                }
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, txEntry.getRecord());
                break;
            }
            case 2: {
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, txEntry.getRecord());
                if (iUseLog) {
                    this.deleteRecord(iTx.getId(), cluster, rid.clusterPosition, txEntry.getRecord().getVersion());
                } else {
                    iTx.getDatabase().getStorage().deleteRecord(rid, txEntry.getRecord().getVersion(), 0, null);
                }
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_DELETE, txEntry.getRecord());
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }
}

