/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.parser.OSystemVariableResolver;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageDataConfiguration;
import com.orientechnologies.orient.core.config.OStorageLogicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageSegmentConfiguration;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.fs.OMMapManager;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLogical;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.ODataLocal;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocalTxExecuter;
import com.orientechnologies.orient.core.storage.impl.local.OStorageVariableParser;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageLocal
extends OStorageEmbedded {
    private final int DELETE_MAX_RETRIES;
    private final int DELETE_WAIT_TIME;
    public static final String[] TYPES = new String[]{"PHYSICAL", "LOGICAL"};
    private final Map<String, OCluster> clusterMap = new LinkedHashMap<String, OCluster>();
    private OCluster[] clusters = new OCluster[0];
    private ODataLocal[] dataSegments = new ODataLocal[0];
    private final OStorageLocalTxExecuter txManager;
    private String storagePath;
    private final OStorageVariableParser variableParser;
    private int defaultClusterId = -1;
    private static String[] ALL_FILE_EXTENSIONS = new String[]{"ocf", ".och", ".ocl", ".oda", ".odh", ".otx"};
    private final String PROFILER_CREATE_RECORD;
    private final String PROFILER_READ_RECORD;
    private final String PROFILER_UPDATE_RECORD;
    private final String PROFILER_DELETE_RECORD;

    public OStorageLocal(String iName, String iFilePath, String iMode) throws IOException {
        super(iName, iFilePath, iMode);
        File f = new File(this.url);
        this.storagePath = f.exists() || !this.exists(f.getParent()) ? OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getPath())) : OSystemVariableResolver.resolveSystemVariables(OFileUtils.getPath(new File(this.url).getParent()));
        this.variableParser = new OStorageVariableParser(this.storagePath);
        this.configuration = new OStorageConfigurationSegment(this, this.storagePath);
        this.txManager = new OStorageLocalTxExecuter(this, this.configuration.txSegment);
        this.PROFILER_CREATE_RECORD = "storage." + this.name + ".createRecord";
        this.PROFILER_READ_RECORD = "storage." + this.name + ".readRecord";
        this.PROFILER_UPDATE_RECORD = "storage." + this.name + ".updateRecord";
        this.PROFILER_DELETE_RECORD = "storage." + this.name + ".deleteRecord";
        this.DELETE_MAX_RETRIES = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        this.DELETE_WAIT_TIME = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        this.installProfilerHooks();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void open(String iUserName, String iUserPassword, Map<String, Object> iProperties) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                int i;
                this.addUser();
                if (this.status != OStorageAbstract.STATUS.CLOSED) {
                    Object var11_5 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
                    return;
                }
                if (!this.exists()) {
                    throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
                }
                this.status = OStorageAbstract.STATUS.OPEN;
                int pos = this.registerDataSegment(new OStorageDataConfiguration(this.configuration, "default"));
                this.dataSegments[pos].open();
                pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "internal", this.clusters.length));
                this.clusters[pos].open();
                this.configuration.load();
                pos = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "index", this.clusters.length));
                this.clusters[pos].open();
                this.defaultClusterId = this.createClusterFromConfig(new OStoragePhysicalClusterConfiguration(this.configuration, "default", this.clusters.length));
                this.clusters[this.defaultClusterId].open();
                for (i = 0; i < this.configuration.dataSegments.size(); ++i) {
                    OStorageDataConfiguration dataConfig = this.configuration.dataSegments.get(i);
                    pos = this.registerDataSegment(dataConfig);
                    if (pos == -1) {
                        this.dataSegments[i].close();
                        this.dataSegments[i] = new ODataLocal(this, dataConfig, i);
                        this.dataSegments[i].open();
                        continue;
                    }
                    this.dataSegments[pos].open();
                }
                for (i = 0; i < this.configuration.clusters.size(); ++i) {
                    OStorageClusterConfiguration clusterConfig = this.configuration.clusters.get(i);
                    if (clusterConfig != null) {
                        pos = this.createClusterFromConfig(clusterConfig);
                        try {
                            if (pos == -1) {
                                this.clusters[i].close();
                                this.clusters[i] = new OClusterLocal(this, (OStoragePhysicalClusterConfiguration)clusterConfig);
                                this.clusterMap.put(this.clusters[i].getName(), this.clusters[i]);
                                this.clusters[i].open();
                                continue;
                            }
                            if (clusterConfig.getName().equals("default")) {
                                this.defaultClusterId = pos;
                            }
                            this.clusters[pos].open();
                        }
                        catch (FileNotFoundException e) {
                            OLogManager.instance().warn((Object)this, "Error on loading cluster '" + this.clusters[i].getName() + "' (" + i + "): file not found. It will be excluded from current database '" + this.getName() + "'.", new Object[0]);
                            this.clusterMap.remove(this.clusters[i].getName());
                            this.clusters[i] = null;
                        }
                        continue;
                    }
                    this.clusters = Arrays.copyOf(this.clusters, this.clusters.length + 1);
                    this.clusters[i] = null;
                }
                this.loadVersion();
                this.txManager.open();
            }
            catch (Exception e) {
                this.close(true);
                throw new OStorageException("Cannot open local storage '" + this.url + "' with mode=" + this.mode, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_7 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
            throw throwable;
        }
        Object var11_6 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".open", timer);
    }

    @Override
    public void create(Map<String, Object> iProperties) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                if (this.status != OStorageAbstract.STATUS.CLOSED) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it is not closed");
                }
                this.addUser();
                File storageFolder = new File(this.storagePath);
                if (!storageFolder.exists()) {
                    storageFolder.mkdir();
                }
                if (this.exists()) {
                    throw new OStorageException("Cannot create new storage '" + this.name + "' because it already exists");
                }
                this.status = OStorageAbstract.STATUS.OPEN;
                this.addDataSegment("default");
                this.addCluster("internal", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.addCluster("index", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.defaultClusterId = this.addCluster("default", OStorage.CLUSTER_TYPE.PHYSICAL, new Object[0]);
                this.configuration.create();
                this.txManager.create();
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage '" + this.name + "'", e);
            }
            Object var6_6 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".create", timer);
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".create", timer);
            throw throwable;
        }
    }

    @Override
    public void reload() {
    }

    @Override
    public boolean exists() {
        return this.exists(this.storagePath);
    }

    private boolean exists(String path) {
        return new File(path + "/" + "default" + ".0" + ".oda").exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close(boolean iForce) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                if (!this.checkForClose(iForce)) {
                    Object var9_3 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
                    return;
                }
                this.status = OStorageAbstract.STATUS.CLOSING;
                this.saveVersion();
                for (OCluster cluster : this.clusters) {
                    if (cluster == null) continue;
                    cluster.close();
                }
                this.clusters = new OCluster[0];
                this.clusterMap.clear();
                for (ODataLocal data : this.dataSegments) {
                    data.close();
                }
                this.dataSegments = new ODataLocal[0];
                this.txManager.close();
                if (this.configuration != null) {
                    this.configuration.close();
                }
                this.level2Cache.shutdown();
                OMMapManager.flush();
                super.close(iForce);
                Orient.instance().unregisterStorage(this);
                this.status = OStorageAbstract.STATUS.CLOSED;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on closing of storage '" + this.name, (Throwable)e, OStorageException.class, new Object[0]);
                Object var9_5 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var9_6 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
            throw throwable;
        }
        Object var9_4 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".close", timer);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void delete() {
        long timer;
        block11: {
            if (this.status != OStorageAbstract.STATUS.CLOSED && this.getUsers() > 0) {
                while (this.removeUser() > 0) {
                }
            }
            this.close(true);
            try {
                Orient.instance().unregisterStorage(this);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot unregister storage", (Throwable)e, new Object[0]);
            }
            timer = OProfiler.getInstance().startChrono();
            File dbDir = new File(OSystemVariableResolver.resolveSystemVariables(this.url));
            if (!dbDir.exists() || !dbDir.isDirectory()) {
                dbDir = dbDir.getParentFile();
            }
            this.lock.acquireExclusiveLock();
            try {
                int i = 0;
                while (i < this.DELETE_MAX_RETRIES) {
                    if (!dbDir.exists() || !dbDir.isDirectory()) break block11;
                    int notDeletedFiles = 0;
                    block6: for (File f : dbDir.listFiles()) {
                        for (String ext : ALL_FILE_EXTENSIONS) {
                            if (!f.getPath().endsWith(ext)) continue;
                            if (f.delete()) continue block6;
                            ++notDeletedFiles;
                            continue block6;
                        }
                    }
                    if (notDeletedFiles == 0) {
                        dbDir.delete();
                        Object var15_14 = null;
                        this.lock.releaseExclusiveLock();
                        OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
                        return;
                    }
                    OLogManager.instance().debug((Object)this, "Cannot delete database files because they are still locked by the OrientDB process: waiting %d ms and retrying %d/%d...", this.DELETE_WAIT_TIME, i, this.DELETE_MAX_RETRIES);
                    OMemoryWatchDog.freeMemory(this.DELETE_WAIT_TIME);
                    ++i;
                }
                throw new OStorageException("Cannot delete database '" + this.name + "' located in: " + dbDir + ". Database files seem locked");
            }
            catch (Throwable throwable) {
                Object var15_16 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
                throw throwable;
            }
        }
        Object var15_15 = null;
        this.lock.releaseExclusiveLock();
        OProfiler.getInstance().stopChrono("storage." + this.name + ".delete", timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void check(OCommandOutputListener iListener) {
        int errors = 0;
        int warnings = 0;
        this.lock.acquireSharedLock();
        try {
            long totalRecors = 0L;
            long start = System.currentTimeMillis();
            iListener.onMessage("\nChecking database '" + this.getName() + "'...\n");
            iListener.onMessage("\n- Checking cluster coherence...\n");
            OPhysicalPosition ppos = new OPhysicalPosition();
            for (OCluster c : this.clusters) {
                if (!(c instanceof OClusterLocal)) continue;
                iListener.onMessage(" +- Checking cluster '" + c.getName() + "' (id=" + c.getId() + ")...\n");
                OClusterPositionIterator it = c.absoluteIterator();
                while (it.hasNext()) {
                    Long pos = it.next();
                    ++totalRecors;
                    try {
                        c.getPhysicalPosition(pos, ppos);
                        if (ppos.dataSegmentId >= this.dataSegments.length) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong data segment %d", ppos.dataSegmentId);
                            ++warnings;
                        }
                        if (ppos.recordSize < 0) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong record size %d", ppos.recordSize);
                            ++warnings;
                        }
                        if (ppos.recordSize >= 1000000) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found suspected big record size %d. Is it corrupted?", ppos.recordSize);
                            ++warnings;
                        }
                        if (ppos.dataChunkPosition > this.dataSegments[ppos.dataSegmentId].getFilledUpTo()) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong pointer to data chunk %d out of data segment size (%d)", ppos.dataChunkPosition, this.dataSegments[ppos.dataSegmentId].getFilledUpTo());
                            ++warnings;
                        }
                        if (ppos.version < -1) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong record version %d", ppos.version);
                            ++warnings;
                            continue;
                        }
                        if (ppos.version != -1) continue;
                        boolean found = false;
                        int tot = ((OClusterLocal)c).holeSegment.getHoles();
                        for (int i = 0; i < tot; ++i) {
                            long recycledPosition = ((OClusterLocal)c).holeSegment.getEntryPosition(i) / 15L;
                            if (recycledPosition != pos) continue;
                            found = true;
                            break;
                        }
                        if (found) continue;
                        OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Cannot find hole for deleted record %d:%d", c.getId(), pos);
                        ++warnings;
                    }
                    catch (IOException e) {
                        OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Error while reading record #%d:%d", e, c.getId(), pos);
                        ++warnings;
                    }
                }
                int tot = ((OClusterLocal)c).holeSegment.getHoles();
                if (tot <= 0) continue;
                iListener.onMessage("  +- Checking " + tot + " hole(s)...\n");
                for (int i = 0; i < tot; ++i) {
                    long recycledPosition = -1L;
                    try {
                        recycledPosition = ((OClusterLocal)c).holeSegment.getEntryPosition(i) / 15L;
                        c.getPhysicalPosition(recycledPosition, ppos);
                        if (ppos.version == -1) continue;
                        OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong hole %d/%d for deleted record %d:%d. The record seems good", i, tot - 1, c.getId(), recycledPosition);
                        ++warnings;
                        continue;
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong hole %d/%d for deleted record %d:%d. The record not exists", i, tot - 1, c.getId(), recycledPosition);
                        ++warnings;
                    }
                }
            }
            int totalChunks = 0;
            iListener.onMessage("\n- Checking data chunks integrity...\n");
            block12: for (ODataLocal d : this.dataSegments) {
                int pos = 0;
                while ((long)pos < d.getFilledUpTo()) {
                    ++totalChunks;
                    int recordSize = Integer.MIN_VALUE;
                    try {
                        recordSize = d.getRecordSize(pos);
                        ORecordId rid = d.getRecordRid(pos);
                        if (recordSize < 0) {
                            boolean found = false;
                            for (ODataHoleInfo hole : this.getHolesList()) {
                                if (hole.dataOffset != (long)pos) continue;
                                found = true;
                                break;
                            }
                            if (!found) {
                                OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Cannot find hole for deleted chunk %d", pos);
                                ++warnings;
                            }
                            if (rid.isValid()) {
                                OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Deleted chunk at position %d (recordSize=%d) points to the valid RID %s instead of #-1:-1", pos, recordSize, rid);
                                ++warnings;
                            }
                            pos += (recordSize *= -1);
                            continue;
                        }
                        byte[] buffer = d.getRecord(pos);
                        if (buffer.length != recordSize) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Wrong record size: found %d but record length is %d", recordSize, buffer.length);
                            ++warnings;
                        }
                        if (!rid.isValid()) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Chunk at position %d points to invalid RID %s", pos, rid);
                            ++warnings;
                        } else if (this.clusters[rid.clusterId] == null) {
                            OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found ghost chunk at position %d pointed from %s. The cluster %d not exists", pos, rid, rid.clusterId);
                            ++warnings;
                        } else {
                            this.clusters[rid.clusterId].getPhysicalPosition(rid.clusterPosition, ppos);
                            if (ppos.dataSegmentId != d.getId()) {
                                OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Wrong record chunk data segment: found %d but current id is %d", ppos.dataSegmentId, d.getId());
                                ++warnings;
                            }
                            if (ppos.dataChunkPosition != (long)pos) {
                                OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Wrong chunk position: cluster record points to %d, but current chunk is at %d", ppos.dataChunkPosition, pos);
                                ++warnings;
                            }
                        }
                        pos += 14 + recordSize;
                    }
                    catch (Exception e) {
                        OLogManager.instance().warn((Object)this, "[OStorageLocal.check] Found wrong chunk %d, cause: ", e, pos, e.toString());
                        ++errors;
                        continue block12;
                    }
                }
            }
            iListener.onMessage("\nCheck of database completed in " + (System.currentTimeMillis() - start) + "ms:\n- Total records checked: " + totalRecors + "\n- Total chunks checked.: " + totalChunks + "\n- Warnings.............: " + warnings + "\n- Errors...............: " + errors + "\n");
            Object var21_34 = null;
            this.lock.releaseSharedLock();
        }
        catch (Throwable throwable) {
            Object var21_35 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ODataLocal getDataSegment(int iDataSegmentId) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            if (iDataSegmentId >= this.dataSegments.length) {
                throw new IllegalArgumentException("Data segment #" + iDataSegmentId + " does not exist in storage '" + this.name + "'");
            }
            ODataLocal oDataLocal = this.dataSegments[iDataSegmentId];
            Object var4_3 = null;
            this.lock.releaseSharedLock();
            return oDataLocal;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        String segmentFileName = this.storagePath + "/" + iDataSegmentName;
        return this.addDataSegment(iDataSegmentName, segmentFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int addDataSegment(String iSegmentName, String iSegmentFileName) {
        this.checkOpeness();
        iSegmentName = iSegmentName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            OStorageDataConfiguration conf = new OStorageDataConfiguration(this.configuration, iSegmentName);
            this.configuration.dataSegments.add(conf);
            int pos = this.registerDataSegment(conf);
            if (pos == -1) {
                throw new OConfigurationException("Cannot add segment " + conf.name + " because it is already part of storage '" + this.name + "'");
            }
            this.dataSegments[pos].create(-1);
            this.configuration.update();
            int n = pos;
            Object var7_8 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable e) {
            try {
                OLogManager.instance().error((Object)this, "Error on creation of new data segment '" + iSegmentName + "' in: " + iSegmentFileName, e, OStorageException.class, new Object[0]);
                int n = -1;
                Object var7_9 = null;
                this.lock.releaseExclusiveLock();
                return n;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.lock.releaseExclusiveLock();
                throw throwable;
            }
        }
    }

    @Override
    public int addCluster(String iClusterName, OStorage.CLUSTER_TYPE iClusterType, Object ... iParameters) {
        this.checkOpeness();
        try {
            iClusterName = iClusterName != null ? iClusterName.toLowerCase() : null;
            switch (iClusterType) {
                case PHYSICAL: {
                    String clusterFileName = (String)(iParameters.length < 1 ? this.storagePath + "/" + iClusterName : iParameters[0]);
                    int startSize = iParameters.length < 2 ? -1 : (Integer)iParameters[1];
                    return this.addPhysicalCluster(iClusterName, clusterFileName, startSize);
                }
                case LOGICAL: {
                    int physicalClusterId = iParameters.length < 1 ? this.getClusterIdByName("internal") : ((Integer)iParameters[0]).intValue();
                    return this.addLogicalCluster(iClusterName, physicalClusterId);
                }
                case MEMORY: {
                    return this.addMemoryCluster(iClusterName);
                }
            }
            OLogManager.instance().exception("Cluster type '" + (Object)((Object)iClusterType) + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error in creation of new cluster '" + iClusterName + "' of type: " + (Object)((Object)iClusterType), e, OStorageException.class, new Object[0]);
        }
        return -1;
    }

    public ODataLocal[] getDataSegments() {
        return this.dataSegments;
    }

    public OStorageLocalTxExecuter getTxManager() {
        return this.txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean dropCluster(int iClusterId) {
        OCluster cluster;
        block6: {
            this.lock.acquireExclusiveLock();
            if (iClusterId < 0 || iClusterId >= this.clusters.length) {
                throw new IllegalArgumentException("Cluster id '" + iClusterId + "' is outside the of range of configured clusters (0-" + (this.clusters.length - 1) + ") in storage '" + this.name + "'");
            }
            cluster = this.clusters[iClusterId];
            if (cluster != null) break block6;
            boolean bl = false;
            Object var5_6 = null;
            this.lock.releaseExclusiveLock();
            return bl;
        }
        try {
            this.getLevel2Cache().freeCluster(iClusterId);
            cluster.delete();
            this.clusterMap.remove(cluster.getName());
            this.clusters[iClusterId] = null;
            this.configuration.dropCluster(iClusterId);
            boolean bl = true;
            Object var5_7 = null;
            this.lock.releaseExclusiveLock();
            return bl;
        }
        catch (Exception e) {
            try {
                OLogManager.instance().exception("Error while removing cluster '" + iClusterId + "'", e, OStorageException.class, new Object[0]);
                Object var5_8 = null;
                this.lock.releaseExclusiveLock();
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                this.lock.releaseExclusiveLock();
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int[] iClusterIds) {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            for (int i = 0; i < iClusterIds.length; ++i) {
                if (iClusterIds[i] >= this.clusters.length) {
                    throw new OConfigurationException("Cluster id " + iClusterIds[i] + " was not found in storage '" + this.name + "'");
                }
                OCluster c = this.clusters[iClusterIds[i]];
                if (c == null) continue;
                tot += c.getEntries();
            }
            long l = tot;
            Object var7_6 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getClusterDataRange(int iClusterId) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in storage '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long[] lArray;
            if (this.clusters[iClusterId] != null) {
                long[] lArray2 = new long[2];
                lArray2[0] = this.clusters[iClusterId].getFirstEntryPosition();
                lArray = lArray2;
                lArray2[1] = this.clusters[iClusterId].getLastEntryPosition();
            } else {
                lArray = new long[]{};
            }
            long[] lArray3 = lArray;
            Object var4_3 = null;
            this.lock.releaseSharedLock();
            return lArray3;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long count(int iClusterId) {
        if (iClusterId == -1) {
            throw new OStorageException("Cluster Id " + iClusterId + " is invalid in storage '" + this.name + "'");
        }
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            long l = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getEntries() : 0L;
            Object var5_3 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    @Override
    public long createRecord(ORecordId iRid, byte[] iContent, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        this.checkOpeness();
        iRid.clusterPosition = this.createRecord(this.getClusterById(iRid.clusterId), iContent, iRecordType);
        return iRid.clusterPosition;
    }

    @Override
    public ORawBuffer readRecord(ORecordId iRid, String iFetchPlan, ORecordCallback<ORawBuffer> iCallback) {
        this.checkOpeness();
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        this.checkOpeness();
        return this.updateRecord(this.getClusterById(iRid.clusterId), iRid, iContent, iVersion, iRecordType);
    }

    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        this.checkOpeness();
        return this.deleteRecord(this.getClusterById(iRid.clusterId), iRid, iVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getClusterNames() {
        this.checkOpeness();
        this.lock.acquireSharedLock();
        try {
            Set<String> set = this.clusterMap.keySet();
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return set;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusterIdByName(String iClusterName) {
        block6: {
            this.checkOpeness();
            if (iClusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            if (iClusterName.length() == 0) {
                throw new IllegalArgumentException("Cluster name is empty");
            }
            if (Character.isDigit(iClusterName.charAt(0))) {
                return Integer.parseInt(iClusterName);
            }
            this.lock.acquireSharedLock();
            try {
                OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
                if (segment == null) break block6;
                int n = segment.getId();
                Object var5_4 = null;
                this.lock.releaseSharedLock();
                return n;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.lock.releaseSharedLock();
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getClusterTypeByName(String iClusterName) {
        block4: {
            this.checkOpeness();
            if (iClusterName == null) {
                throw new IllegalArgumentException("Cluster name is null");
            }
            this.lock.acquireSharedLock();
            try {
                OCluster segment = this.clusterMap.get(iClusterName.toLowerCase());
                if (segment == null) break block4;
                String string = segment.getType();
                Object var5_4 = null;
                this.lock.releaseSharedLock();
                return string;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        Object var5_5 = null;
        this.lock.releaseSharedLock();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            block11: {
                block10: {
                    this.txManager.clearLogEntries(iTx);
                    this.txManager.commitAllPendingRecords(iTx);
                    this.incrementVersion();
                    if (!OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) break block10;
                    this.synch();
                }
                Object var4_2 = null;
                try {
                    this.txManager.clearLogEntries(iTx);
                }
                catch (Exception e) {
                    OLogManager.instance().error((Object)this, "Clear tx log entries failed", (Throwable)e, new Object[0]);
                }
                break block11;
                {
                    catch (RuntimeException e) {
                        this.rollback(iTx);
                        throw e;
                    }
                    catch (IOException e) {
                        this.rollback(iTx);
                        throw new OException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_3 = null;
                    try {
                        this.txManager.clearLogEntries(iTx);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Clear tx log entries failed", (Throwable)e, new Object[0]);
                    }
                    throw throwable;
                }
            }
            Object var7_9 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
        try {
            this.txManager.getTxSegment().rollback(iTx);
            if (OGlobalConfiguration.TX_COMMIT_SYNCH.getValueAsBoolean()) {
                this.synch();
            }
        }
        catch (IOException ioe) {
            OLogManager.instance().error((Object)this, "Error executing rollback for transaction with id '" + iTx.getId() + "' cause: " + ioe.getMessage(), (Throwable)ioe, new Object[0]);
        }
    }

    @Override
    public void synch() {
        this.checkOpeness();
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            block6: {
                try {
                    this.saveVersion();
                    for (OCluster cluster : this.clusters) {
                        if (cluster == null) continue;
                        cluster.synch();
                    }
                    for (ODataLocal data : this.dataSegments) {
                        if (data == null) continue;
                        data.synch();
                    }
                    if (this.configuration == null) break block6;
                    this.configuration.synch();
                }
                catch (IOException e) {
                    throw new OStorageException("Error on synch storage '" + this.name + "'", e);
                }
            }
            Object var8_7 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".synch", timer);
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono("storage." + this.name + ".synch", timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ODataHoleInfo> getHolesList() {
        ArrayList<ODataHoleInfo> holes = new ArrayList<ODataHoleInfo>();
        this.lock.acquireSharedLock();
        try {
            for (ODataLocal d : this.dataSegments) {
                holes.addAll(d.getHolesList());
            }
            ArrayList<ODataHoleInfo> arrayList = holes;
            Object var7_6 = null;
            this.lock.releaseSharedLock();
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoles() {
        this.lock.acquireSharedLock();
        try {
            long holes = 0L;
            for (ODataLocal d : this.dataSegments) {
                holes += d.getHoles();
            }
            long l = holes;
            Object var8_7 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getHoleSize() {
        this.lock.acquireSharedLock();
        try {
            List<ODataHoleInfo> holes = this.getHolesList();
            long size = 0L;
            for (ODataHoleInfo h : holes) {
                if (h.dataOffset <= -1L || h.size <= 0) continue;
                size += (long)h.size;
            }
            long l = size;
            Object var7_6 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        block3: {
            this.checkOpeness();
            this.lock.acquireSharedLock();
            try {
                if (iClusterId < this.clusters.length) break block3;
                String string = null;
                Object var4_4 = null;
                this.lock.releaseSharedLock();
                return string;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.lock.releaseSharedLock();
                throw throwable;
            }
        }
        String string = this.clusters[iClusterId] != null ? this.clusters[iClusterId].getName() : null;
        Object var4_5 = null;
        this.lock.releaseSharedLock();
        return string;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            this.checkClusterSegmentIndexRange(iClusterId);
            OCluster cluster = this.clusters[iClusterId];
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterId + " is null");
            }
            OCluster oCluster = cluster;
            Object var5_4 = null;
            this.lock.releaseSharedLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                throw new IllegalArgumentException("Cluster " + iClusterName + " does not exist in storage '" + this.name + "'");
            }
            OCluster oCluster = cluster;
            Object var5_4 = null;
            this.lock.releaseSharedLock();
            return oCluster;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getSize() {
        this.lock.acquireSharedLock();
        try {
            long size = 0L;
            for (ODataLocal d : this.dataSegments) {
                if (d == null) continue;
                size += d.getFilledUpTo();
            }
            for (OCluster c : this.clusters) {
                if (c == null) continue;
                size += c.getSize();
            }
            long l = size;
            Object var8_7 = null;
            this.lock.releaseSharedLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public String getMode() {
        return this.mode;
    }

    public OStorageVariableParser getVariableParser() {
        return this.variableParser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusters.length;
            Object var3_2 = null;
            this.lock.releaseSharedLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<OCluster> getClusterInstances() {
        HashSet<OCluster> result = new HashSet<OCluster>();
        this.lock.acquireSharedLock();
        try {
            for (OCluster c : this.clusters) {
                result.add(c);
            }
            Object var7_6 = null;
            this.lock.releaseSharedLock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.lock.releaseSharedLock();
            throw throwable;
        }
        return result;
    }

    @Override
    public void renameCluster(String iOldName, String iNewName) {
        this.clusterMap.put(iNewName, this.clusterMap.remove(iOldName));
    }

    protected int registerDataSegment(OStorageDataConfiguration iConfig) throws IOException {
        this.checkOpeness();
        int pos = 0;
        for (ODataLocal data : this.dataSegments) {
            if (!data.getName().equals(iConfig.name)) continue;
            data.config = iConfig;
            return -1;
        }
        pos = this.dataSegments.length;
        ODataLocal segment = new ODataLocal(this, iConfig, pos);
        this.dataSegments = OArrays.copyOf(this.dataSegments, this.dataSegments.length + 1);
        this.dataSegments[pos] = segment;
        return pos;
    }

    private int createClusterFromConfig(OStorageClusterConfiguration iConfig) throws IOException {
        OCluster cluster = this.clusterMap.get(iConfig.getName());
        if (cluster != null) {
            if (cluster instanceof OClusterLocal) {
                ((OClusterLocal)cluster).config = (OStorageSegmentConfiguration)((Object)iConfig);
            }
            return -1;
        }
        cluster = iConfig instanceof OStoragePhysicalClusterConfiguration ? new OClusterLocal(this, (OStoragePhysicalClusterConfiguration)iConfig) : new OClusterLogical(this, (OStorageLogicalClusterConfiguration)iConfig);
        return this.registerCluster(cluster);
    }

    private int registerCluster(OCluster iCluster) throws IOException {
        int id;
        if (iCluster != null) {
            if (this.clusterMap.containsKey(iCluster.getName())) {
                throw new OConfigurationException("Cannot add segment '" + iCluster.getName() + "' because it is already registered in storage '" + this.name + "'");
            }
            this.clusterMap.put(iCluster.getName(), iCluster);
            id = iCluster.getId();
        } else {
            id = this.clusters.length;
        }
        this.clusters = OArrays.copyOf(this.clusters, this.clusters.length + 1);
        this.clusters[id] = iCluster;
        return id;
    }

    private void checkClusterSegmentIndexRange(int iClusterId) {
        if (iClusterId > this.clusters.length - 1) {
            throw new IllegalArgumentException("Cluster segment #" + iClusterId + " does not exist in storage '" + this.name + "'");
        }
    }

    protected int getDataSegmentForRecord(OCluster iCluster, byte[] iContent) {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long createRecord(OCluster iClusterSegment, byte[] iContent, byte iRecordType) {
        long l;
        this.checkOpeness();
        if (iContent == null) {
            throw new IllegalArgumentException("Record is null");
        }
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            int dataSegment = this.getDataSegmentForRecord(iClusterSegment, iContent);
            ODataLocal data = this.getDataSegment(dataSegment);
            ORecordId rid = new ORecordId(iClusterSegment.getId());
            rid.clusterPosition = iClusterSegment.addPhysicalPosition(-1, -1L, iRecordType);
            long dataOffset = data.addRecord(rid, iContent);
            iClusterSegment.setPhysicalPosition(rid.clusterPosition, dataSegment, dataOffset, iRecordType, 0);
            this.incrementVersion();
            l = rid.clusterPosition;
            Object var14_12 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
        }
        catch (IOException e) {
            long l2;
            try {
                OLogManager.instance().error((Object)this, "Error on creating record in cluster: " + iClusterSegment, (Throwable)e, new Object[0]);
                l2 = -1L;
                Object var14_13 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
            }
            catch (Throwable throwable) {
                Object var14_14 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_CREATE_RECORD, timer);
                throw throwable;
            }
            return l2;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        if (iRid.clusterPosition < 0L) {
            throw new IllegalArgumentException("Cannot read record " + iRid + " since the position is invalid in storage '" + this.name + "'");
        }
        long timer = OProfiler.getInstance().startChrono();
        if (iAtomicLock) {
            this.lock.acquireSharedLock();
        }
        try {
            try {
                OPhysicalPosition ppos;
                block15: {
                    ORawBuffer oRawBuffer;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    try {
                        long lastPos = iClusterSegment.getLastEntryPosition();
                        if (lastPos < 0L) {
                            throw new ORecordNotFoundException("Record " + iRid + " is outside cluster range. The cluster '" + iClusterSegment.getName() + "' is empty in storage '" + this.name + "'");
                        }
                        if (iRid.clusterPosition > lastPos) {
                            throw new ORecordNotFoundException("Record " + iRid + " is outside cluster range. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos + " in storage '" + this.name + "'");
                        }
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (ppos != null && this.checkForRecordValidity(ppos)) break block15;
                        oRawBuffer = null;
                        Object var12_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_12 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                    Object var14_13 = null;
                    if (iAtomicLock) {
                        this.lock.releaseSharedLock();
                    }
                    OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                    return oRawBuffer;
                }
                ODataLocal data = this.getDataSegment(ppos.dataSegmentId);
                ORawBuffer oRawBuffer = new ORawBuffer(data.getRecord(ppos.dataChunkPosition), ppos.version, ppos.type);
                Object var12_11 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                Object var14_14 = null;
                if (iAtomicLock) {
                    this.lock.releaseSharedLock();
                }
                OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                return oRawBuffer;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on reading record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                ORawBuffer oRawBuffer = null;
                Object var14_15 = null;
                if (iAtomicLock) {
                    this.lock.releaseSharedLock();
                }
                OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
                return oRawBuffer;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (iAtomicLock) {
                this.lock.releaseSharedLock();
            }
            OProfiler.getInstance().stopChrono(this.PROFILER_READ_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected int updateRecord(OCluster iClusterSegment, ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType) {
        if (iClusterSegment == null) {
            throw new OStorageException("Cluster not defined for record: " + iRid);
        }
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            try {
                long newDataSegmentOffset;
                OPhysicalPosition ppos;
                block16: {
                    int n;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (this.checkForRecordValidity(ppos)) break block16;
                        n = -1;
                        Object var13_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var13_13 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var15_14 = null;
                    this.lock.releaseSharedLock();
                    OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                    return n;
                }
                switch (iVersion) {
                    case -1: {
                        ++ppos.version;
                        iClusterSegment.updateVersion(iRid.clusterPosition, ppos.version);
                        break;
                    }
                    case -2: {
                        break;
                    }
                    case -3: {
                        --ppos.version;
                        iClusterSegment.updateVersion(iRid.clusterPosition, ppos.version);
                        break;
                    }
                    default: {
                        if (iVersion <= -1) throw new IllegalArgumentException("Cannot update record " + iRid + " in storage '" + this.name + "' because the version is not correct: recieved=" + iVersion + " expected=-1 (skip version control),-2 (skip version control and increment),-3 (rollback) or " + ppos.version + "(current version)");
                        if (iVersion != ppos.version) {
                            throw new OConcurrentModificationException("Cannot update record " + iRid + " in storage '" + this.name + "' because the version is not the latest. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")", iRid, ppos.version, iVersion);
                        }
                        ++ppos.version;
                        iClusterSegment.updateVersion(iRid.clusterPosition, ppos.version);
                        break;
                    }
                }
                if (ppos.type != iRecordType) {
                    iClusterSegment.updateRecordType(iRid.clusterPosition, iRecordType);
                }
                if ((newDataSegmentOffset = ppos.dataChunkPosition == -1L ? this.getDataSegment(ppos.dataSegmentId).addRecord(iRid, iContent) : this.getDataSegment(ppos.dataSegmentId).setRecord(ppos.dataChunkPosition, iRid, iContent)) != ppos.dataChunkPosition) {
                    iClusterSegment.setPhysicalPosition(iRid.clusterPosition, ppos.dataSegmentId, newDataSegmentOffset, iRecordType, ppos.version);
                }
                this.incrementVersion();
                int n = ppos.version;
                Object var13_12 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var15_15 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                return n;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on updating record " + iRid + " (cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                Object var15_16 = null;
                this.lock.releaseSharedLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
                return -1;
            }
        }
        catch (Throwable throwable) {
            Object var15_17 = null;
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_UPDATE_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean deleteRecord(OCluster iClusterSegment, ORecordId iRid, int iVersion) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireExclusiveLock();
        try {
            try {
                OPhysicalPosition ppos;
                block9: {
                    boolean bl;
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = iClusterSegment.getPhysicalPosition(iRid.clusterPosition, new OPhysicalPosition());
                        if (this.checkForRecordValidity(ppos)) break block9;
                        bl = false;
                        Object var9_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var9_11 = null;
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                        throw throwable;
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    Object var11_12 = null;
                    this.lock.releaseExclusiveLock();
                    OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                    return bl;
                }
                if (iVersion > -1 && ppos.version != iVersion) {
                    throw new OConcurrentModificationException("Cannot delete the record " + iRid + " in storage '" + this.name + "' because the version is not the latest. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.version + " your=v" + iVersion + ")", iRid, ppos.version, iVersion);
                }
                if (ppos.dataChunkPosition > -1L) {
                    this.getDataSegment(ppos.dataSegmentId).deleteRecord(ppos.dataChunkPosition);
                }
                iClusterSegment.removePhysicalPosition(iRid.clusterPosition, ppos);
                this.incrementVersion();
                boolean bl = true;
                Object var9_10 = null;
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                Object var11_13 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                return bl;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on deleting record " + iRid + "( cluster: " + iClusterSegment + ")", (Throwable)e, new Object[0]);
                Object var11_14 = null;
                this.lock.releaseExclusiveLock();
                OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var11_15 = null;
            this.lock.releaseExclusiveLock();
            OProfiler.getInstance().stopChrono(this.PROFILER_DELETE_RECORD, timer);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveVersion() throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            if (this.dataSegments.length > 0) {
                this.dataSegments[0].saveVersion(this.version.get());
            }
            Object var2_1 = null;
            this.lock.releaseExclusiveLock();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long loadVersion() throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            long v = this.dataSegments[0].loadVersion();
            this.version.set(v);
            long l = v;
            Object var6_3 = null;
            this.lock.releaseExclusiveLock();
            return l;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addPhysicalCluster(String iClusterName, String iClusterFileName, int iStartSize) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            OClusterLocal cluster;
            if (iClusterName != null) {
                int clusterPos = this.clusters.length;
                for (int i = 0; i < this.clusters.length; ++i) {
                    if (this.clusters[i] != null) continue;
                    clusterPos = i;
                    break;
                }
                OStoragePhysicalClusterConfiguration config = new OStoragePhysicalClusterConfiguration(this.configuration, iClusterName, clusterPos);
                this.configuration.setCluster(config);
                cluster = new OClusterLocal(this, config);
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.clusters[id].create(iStartSize);
                this.configuration.update();
            }
            int n = id;
            Object var8_9 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private int addLogicalCluster(String iClusterName, int iPhysicalCluster) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            OClusterLogical cluster;
            if (iClusterName != null) {
                OStorageLogicalClusterConfiguration config = new OStorageLogicalClusterConfiguration(iClusterName, this.clusters.length, iPhysicalCluster, null);
                this.configuration.setCluster(config);
                cluster = new OClusterLogical(this, this.clusters.length, iClusterName, iPhysicalCluster);
                config.map = cluster.getRID();
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.configuration.update();
            }
            int n = id;
            Object var7_7 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int addMemoryCluster(String iClusterName) throws IOException {
        this.lock.acquireExclusiveLock();
        try {
            OClusterMemory cluster;
            if (iClusterName != null) {
                OStorageMemoryClusterConfiguration config = new OStorageMemoryClusterConfiguration(iClusterName, this.clusters.length);
                this.configuration.setCluster(config);
                cluster = new OClusterMemory(this.clusters.length, iClusterName);
            } else {
                cluster = null;
            }
            int id = this.registerCluster(cluster);
            if (iClusterName != null) {
                this.configuration.update();
            }
            int n = id;
            Object var6_6 = null;
            this.lock.releaseExclusiveLock();
            return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.lock.releaseExclusiveLock();
            throw throwable;
        }
    }

    private void installProfilerHooks() {
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holes", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoles();
            }
        });
        OProfiler.getInstance().registerHookValue("storage." + this.name + ".data.holeSize", new OProfiler.OProfilerHookValue(){

            public Object getValue() {
                return OStorageLocal.this.getHoleSize();
            }
        });
    }
}

