/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;

public class OStorageConfigurationSegment
extends OStorageConfiguration {
    private static final int START_SIZE = 10000;
    private OSingleFileSegment segment;

    public OStorageConfigurationSegment(OStorageLocal iStorage, String iPath) throws IOException {
        super(iStorage);
        this.segment = new OSingleFileSegment((OStorageLocal)this.storage, new OStorageFileConfiguration(null, iPath + "/database.ocf", this.fileTemplate.fileType, this.fileTemplate.maxSize, this.fileTemplate.fileIncrementSize));
    }

    public void close() throws IOException {
        this.segment.close();
    }

    public void create() throws IOException {
        this.segment.create(10000);
        super.create();
    }

    public OStorageConfiguration load() throws OSerializationException {
        try {
            if (!this.segment.getFile().exists()) {
                this.segment.create(10000);
                ORawBuffer rawRecord = this.storage.readRecord(CONFIG_RID, null, null);
                if (rawRecord != null) {
                    this.fromStream(rawRecord.buffer);
                }
                this.update();
                return this;
            }
            this.segment.open();
            int size = this.segment.getFile().readInt(0L);
            byte[] buffer = new byte[size];
            this.segment.getFile().read(4L, buffer, size);
            this.fromStream(buffer);
        }
        catch (Exception e) {
            throw new OSerializationException("Cannot load database's configuration. The database seems to be corrupted.");
        }
        return this;
    }

    public void update() throws OSerializationException {
        try {
            if (!this.segment.getFile().isOpen()) {
                return;
            }
            byte[] buffer = this.toStream();
            int len = buffer.length + 4;
            if (len > this.segment.getFile().getFilledUpTo()) {
                this.segment.getFile().allocateSpace(len - this.segment.getFile().getFilledUpTo());
            }
            this.segment.getFile().writeInt(0L, buffer.length);
            this.segment.getFile().write(4L, buffer);
        }
        catch (Exception e) {
            throw new OSerializationException("Error on update storage configuration", e);
        }
    }

    public void synch() throws IOException {
        this.segment.getFile().synch();
    }
}

