/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMMapBufferEntry
implements Comparable<OMMapBufferEntry> {
    private static final int FORCE_DELAY;
    private static final int FORCE_RETRY;
    static Class<?> sunClass;
    OFileMMap file;
    MappedByteBuffer buffer;
    long beginOffset;
    int size;
    long counter;
    volatile boolean dirty;

    public OMMapBufferEntry(OFileMMap iFile, MappedByteBuffer buffer, long beginOffset, int size) {
        this.file = iFile;
        this.buffer = buffer;
        this.beginOffset = beginOffset;
        this.size = size;
        this.counter = 0L;
        this.dirty = false;
    }

    public boolean flush() {
        if (!this.dirty) {
            return true;
        }
        long timer = OProfiler.getInstance().startChrono();
        for (int i = 0; i < FORCE_RETRY; ++i) {
            try {
                this.buffer.force();
                this.dirty = false;
                break;
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Cannot write memory buffer to disk. Retrying (" + (i + 1) + "/" + FORCE_RETRY + ")...", new Object[0]);
                OMemoryWatchDog.freeMemory(FORCE_DELAY);
                continue;
            }
        }
        if (this.dirty) {
            OLogManager.instance().debug((Object)this, "Cannot commit memory buffer to disk after %d retries", FORCE_RETRY);
        } else {
            OProfiler.getInstance().updateCounter("OMMapManager.pagesCommitted", 1L);
        }
        OProfiler.getInstance().stopChrono("OMMapManager.commitPages", timer);
        return !this.dirty;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OMMapBufferEntry [file=").append(this.file).append(", beginOffset=").append(this.beginOffset).append(", size=").append(this.size).append("]");
        return builder.toString();
    }

    public void close() {
        this.flush();
        if (this.file != null) {
            if (!this.file.isClosed()) {
                try {
                    this.file.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            this.file = null;
        }
        if (this.buffer != null && sunClass != null) {
            try {
                Method m = sunClass.getMethod("cleaner", new Class[0]);
                Object cleaner = m.invoke((Object)this.buffer, new Object[0]);
                cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on calling MMap buffer clean", (Throwable)e, new Object[0]);
            }
        }
        this.buffer = null;
        this.counter = 0L;
    }

    @Override
    public int compareTo(OMMapBufferEntry iOther) {
        return (int)(this.beginOffset - iOther.beginOffset);
    }

    public boolean isValid() {
        return this.buffer != null;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty() {
        this.dirty = true;
    }

    static {
        sunClass = null;
        FORCE_DELAY = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        FORCE_RETRY = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
    }
}

