/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.io.OIOException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.storage.fs.OAbstractFile;
import java.io.IOException;
import java.nio.ByteBuffer;

public class OFileClassic
extends OAbstractFile {
    public static final String NAME = "classic";
    protected ByteBuffer internalWriteBuffer = ByteBuffer.allocate(8);

    public OFileClassic init(String iFileName, String iMode) {
        super.init(iFileName, iMode);
        return this;
    }

    public void close() throws IOException {
        if (this.channel != null) {
            this.setSoftlyClosed(true);
        }
        if (this.internalWriteBuffer != null) {
            this.internalWriteBuffer = null;
        }
        super.close();
    }

    public void read(long iOffset, byte[] iDestBuffer, int iLenght) throws IOException {
        iOffset = this.checkRegions(iOffset, iLenght);
        ByteBuffer buffer = ByteBuffer.wrap(iDestBuffer);
        this.channel.read(buffer, iOffset);
    }

    public int readInt(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        return this.readData(iOffset, 4).getInt();
    }

    public long readLong(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        return this.readData(iOffset, 8).getLong();
    }

    public short readShort(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 2);
        return this.readData(iOffset, 2).getShort();
    }

    public byte readByte(long iOffset) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        return this.readData(iOffset, 1).get();
    }

    public void writeInt(long iOffset, int iValue) throws IOException {
        this.setDirty();
        iOffset = this.checkRegions(iOffset, 4);
        ByteBuffer buffer = this.getWriteBuffer(4);
        buffer.putInt(iValue);
        this.writeBuffer(buffer, iOffset);
        this.setDirty();
    }

    public void writeLong(long iOffset, long iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 8);
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeBuffer(buffer, iOffset);
        this.setDirty();
    }

    public void writeShort(long iOffset, short iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 4);
        ByteBuffer buffer = this.getWriteBuffer(2);
        buffer.putShort(iValue);
        this.writeBuffer(buffer, iOffset);
        this.setDirty();
    }

    public void writeByte(long iOffset, byte iValue) throws IOException {
        iOffset = this.checkRegions(iOffset, 1);
        ByteBuffer buffer = this.getWriteBuffer(1);
        buffer.put(iValue);
        this.writeBuffer(buffer, iOffset);
        this.setDirty();
    }

    public void write(long iOffset, byte[] iSourceBuffer) throws IOException {
        if (iSourceBuffer != null) {
            iOffset = this.checkRegions(iOffset, iSourceBuffer.length);
            this.channel.write(ByteBuffer.wrap(iSourceBuffer), iOffset);
            this.setDirty();
        }
    }

    public void synch() throws IOException {
        this.flushHeader();
    }

    protected void flushHeader() throws IOException {
        if (this.headerDirty || this.dirty) {
            this.dirty = false;
            this.headerDirty = false;
            this.channel.force(false);
        }
    }

    protected void init() throws IOException {
        this.size = this.readData(0L, 4).getInt();
        this.filledUpTo = this.readData(4L, 4).getInt();
    }

    protected void setFilledUpTo(int iValue) throws IOException {
        if (iValue != this.filledUpTo) {
            this.filledUpTo = iValue;
            ByteBuffer buffer = this.getWriteBuffer(4);
            buffer.putInt(this.filledUpTo);
            this.writeBuffer(buffer, 4L);
            this.setHeaderDirty();
        }
    }

    public void setSize(int iSize) throws IOException {
        if (iSize != this.size) {
            super.checkSize(iSize);
            this.size = iSize;
            ByteBuffer buffer = this.getWriteBuffer(4);
            buffer.putInt(this.size);
            this.writeBuffer(buffer, 0L);
            this.setHeaderDirty();
            try {
                this.synch();
                this.channel.close();
                this.openChannel(iSize);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on changing the file size to " + iSize + " bytes", (Throwable)e, OIOException.class, new Object[0]);
            }
        }
    }

    public void writeHeaderLong(int iPosition, long iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(8);
        buffer.putLong(iValue);
        this.writeBuffer(buffer, 128 + iPosition);
        this.setHeaderDirty();
    }

    public long readHeaderLong(int iPosition) throws IOException {
        return this.readData(128 + iPosition, 8).getLong();
    }

    public boolean isSoftlyClosed() throws IOException {
        return this.readData(8L, 1).get() == 1;
    }

    protected void setSoftlyClosed(boolean iValue) throws IOException {
        ByteBuffer buffer = this.getWriteBuffer(1);
        buffer.put((byte)(iValue ? 1 : 0));
        this.writeBuffer(buffer, 8L);
        this.setHeaderDirty();
        this.synch();
    }

    protected long checkRegions(long iOffset, int iLength) {
        return super.checkRegions(iOffset, iLength) + 1024L;
    }

    private ByteBuffer readData(long iOffset, int iSize) throws IOException {
        ByteBuffer buffer = this.getBuffer(iSize);
        this.channel.read(buffer, iOffset);
        buffer.rewind();
        return buffer;
    }

    private void writeBuffer(ByteBuffer iBuffer, long iOffset) throws IOException {
        iBuffer.rewind();
        this.channel.write(iBuffer, iOffset);
    }

    private ByteBuffer getBuffer(int iLenght) {
        return ByteBuffer.allocate(iLenght);
    }

    private ByteBuffer getWriteBuffer(int iLenght) {
        this.setDirty();
        if (iLenght <= 8) {
            return (ByteBuffer)this.internalWriteBuffer.rewind();
        }
        return this.getBuffer(iLenght);
    }
}

