/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordLockManager;
import com.orientechnologies.orient.core.storage.OStorageAbstract;

public abstract class OStorageEmbedded
extends OStorageAbstract {
    protected final ORecordLockManager lockManager = new ORecordLockManager(OGlobalConfiguration.STORAGE_RECORD_LOCK_TIMEOUT.getValueAsInteger());

    public OStorageEmbedded(String iName, String iFilePath, String iMode) {
        super(iName, iFilePath, iMode);
    }

    protected abstract ORawBuffer readRecord(OCluster var1, ORecordId var2, boolean var3);

    public abstract OCluster getClusterByName(String var1);

    public Object command(OCommandRequestText iCommand) {
        OCommandExecutor executor = OCommandManager.instance().getExecutor(iCommand);
        executor.setProgressListener(iCommand.getProgressListener());
        executor.parse(iCommand);
        try {
            return executor.execute(iCommand.getParameters());
        }
        catch (OException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error on execution of command: " + iCommand, e);
        }
    }

    protected void checkOpeness() {
        if (this.status != OStorageAbstract.STATUS.OPEN) {
            throw new OStorageException("Storage " + this.name + " is not opened.");
        }
    }
}

