/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPhysicalPosition
implements OSerializableStream,
Comparable<OPhysicalPosition> {
    public int dataSegmentId;
    public long dataChunkPosition;
    public byte type;
    public int version = 0;
    public int recordSize;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(int iDataSegment, long iPosition, byte iRecordType) {
        this.dataSegmentId = iDataSegment;
        this.dataChunkPosition = iPosition;
        this.type = iRecordType;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.dataSegmentId = this.dataSegmentId;
        iDest.dataChunkPosition = this.dataChunkPosition;
        iDest.type = this.type;
        iDest.version = this.version;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "dataSegment=" + this.dataSegmentId + ", recordPosition=" + this.dataChunkPosition + ", type=" + this.type + ", recordSize=" + this.recordSize + ", v=" + this.version;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.dataSegmentId = OBinaryProtocol.bytes2int(iStream, pos);
        this.dataChunkPosition = OBinaryProtocol.bytes2long(iStream, pos += 4);
        this.type = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.version = OBinaryProtocol.bytes2int(iStream, pos += 4);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[21];
        int pos = 0;
        OBinaryProtocol.int2bytes(this.dataSegmentId, buffer, pos);
        OBinaryProtocol.long2bytes(this.dataChunkPosition, buffer, pos += 4);
        buffer[pos += 8] = this.type;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        OBinaryProtocol.int2bytes(this.version, buffer, pos += 4);
        return buffer;
    }

    @Override
    public int compareTo(OPhysicalPosition iOther) {
        return (int)(this.dataChunkPosition - iOther.dataChunkPosition);
    }
}

