/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;

public class OQueryOperatorMajorEquals
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorMajorEquals() {
        super(">=", 5, false);
    }

    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Object right = OType.convert(iRight, iLeft.getClass());
        if (right == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right) >= 0;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iRight == null || iLeft == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_METHOD;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            if (iRight instanceof ORID) {
                return (ORID)iRight;
            }
            if (iRight instanceof OSQLFilterItemParameter && ((OSQLFilterItemParameter)iRight).getValue(null, null) instanceof ORID) {
                return (ORID)((OSQLFilterItemParameter)iRight).getValue(null, null);
            }
        }
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

