/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Iterator;
import java.util.Map;

public class OQueryOperatorContainsValue
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsValue() {
        super("CONTAINSVALUE", 5, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        OSQLFilterCondition condition = iCondition.getLeft() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getLeft() : (iCondition.getRight() instanceof OSQLFilterCondition ? (OSQLFilterCondition)iCondition.getRight() : null);
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            if (condition == null) return map.containsValue(iRight);
            for (Object v : map.values()) {
                Object object = this.loadIfNeed(v);
                if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, iContext)).booleanValue()) continue;
                return true;
            }
            return false;
        } else {
            Iterator i$;
            if (!(iRight instanceof Map)) return false;
            Map map = (Map)iRight;
            if (condition == null || !(i$ = map.values().iterator()).hasNext()) return false;
            Object v = i$.next();
            Object object = this.loadIfNeed(v);
            if (!((Boolean)condition.evaluate((ORecordSchemaAware)object, iContext)).booleanValue()) return map.containsValue(iLeft);
            return true;
        }
    }

    private Object loadIfNeed(Object o) {
        ORecord record = (ORecord)o;
        if (record.getRecord().getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                o = record.load();
            }
            catch (ORecordNotFoundException e) {
                throw new OException("Error during loading record with id : " + record.getIdentity());
            }
        }
        return o;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (!(iRight instanceof OSQLFilterCondition) && !(iLeft instanceof OSQLFilterCondition)) {
            return OIndexReuseType.INDEX_METHOD;
        }
        return OIndexReuseType.NO_INDEX;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

