/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Iterator;

public class OQueryOperatorBetween
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorBetween() {
        super("BETWEEN", 5, false, 3);
    }

    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        this.validate(iRight);
        Iterator<?> valueIterator = OMultiValue.getMultiValueIterator(iRight);
        Object right1 = OType.convert(valueIterator.next(), iLeft.getClass());
        if (right1 == null) {
            return false;
        }
        valueIterator.next();
        Object right2 = OType.convert(valueIterator.next(), iLeft.getClass());
        if (right2 == null) {
            return false;
        }
        return ((Comparable)iLeft).compareTo(right1) >= 0 && ((Comparable)iLeft).compareTo(right2) <= 0;
    }

    private void validate(Object iRight) {
        if (!OMultiValue.isMultiValue(iRight.getClass())) {
            throw new IllegalArgumentException("Found '" + iRight + "' while was expected: " + this.getSyntax());
        }
        if (OMultiValue.getSize(iRight) != 3) {
            throw new IllegalArgumentException("Found '" + OMultiValue.toString(iRight) + "' while was expected: " + this.getSyntax());
        }
    }

    public String getSyntax() {
        return "<left> " + this.keyword + " <minRange> AND <maxRange>";
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        this.validate(iRight);
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            Iterator<?> valueIterator = OMultiValue.getMultiValueIterator(iRight);
            Object right1 = valueIterator.next();
            if (right1 != null) {
                return (ORID)right1;
            }
            valueIterator.next();
            return (ORID)valueIterator.next();
        }
        return null;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        this.validate(iRight);
        this.validate(iRight);
        if (iLeft instanceof OSQLFilterItemField && "@rid".equals(((OSQLFilterItemField)iLeft).getRoot())) {
            Iterator<?> valueIterator = OMultiValue.getMultiValueIterator(iRight);
            Object right1 = valueIterator.next();
            valueIterator.next();
            Object right2 = valueIterator.next();
            if (right2 == null) {
                return (ORID)right1;
            }
            return (ORID)right2;
        }
        return null;
    }
}

