/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.geo;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;

public class OSQLFunctionDistance
extends OSQLFunctionAbstract {
    public static final String NAME = "distance";
    private static final double EARTH_RADIUS = 6371.0;

    public OSQLFunctionDistance() {
        super(NAME, 4, 5);
    }

    public Object execute(OIdentifiable iCurrentRecord, Object[] iParameters, OCommandExecutor iRequester) {
        try {
            double[] values = new double[4];
            for (int i = 0; i < iParameters.length; ++i) {
                if (iParameters[i] == null) {
                    return null;
                }
                values[i] = (Double)OType.convert(iParameters[i], Double.class);
            }
            double deltaLat = Math.toRadians(values[2] - values[0]);
            double deltaLon = Math.toRadians(values[3] - values[1]);
            double a = Math.pow(Math.sin(deltaLat / 2.0), 2.0) + Math.cos(Math.toRadians(values[0])) * Math.cos(Math.toRadians(values[2])) * Math.pow(Math.sin(deltaLon / 2.0), 2.0);
            double distance = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a)) * 6371.0;
            return distance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getSyntax() {
        return "Syntax error: distance(<field-x>,<field-y>,<x-value>,<y-value>[,<unit>])";
    }
}

