/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandToParse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import java.util.List;

public class OSQLFunctionRuntime
extends OSQLFilterItemAbstract {
    public OSQLFunction function;
    public Object[] configuredParameters;
    public Object[] runtimeParameters;

    public OSQLFunctionRuntime(OCommandToParse iQueryToParse, String iText) {
        super(iQueryToParse, iText);
    }

    public boolean aggregateResults() {
        return this.function.aggregateResults(this.configuredParameters);
    }

    public boolean filterResult() {
        return this.function.filterResult();
    }

    public Object execute(OIdentifiable o, OCommandExecutor iRequester) {
        for (int i = 0; i < this.configuredParameters.length; ++i) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField) {
                this.runtimeParameters[i] = ((OSQLFilterItemField)this.configuredParameters[i]).getValue(o, null);
                continue;
            }
            if (!(this.configuredParameters[i] instanceof OSQLFunctionRuntime)) continue;
            this.runtimeParameters[i] = ((OSQLFunctionRuntime)this.configuredParameters[i]).execute(o, iRequester);
        }
        Object functionResult = this.function.execute(o, this.runtimeParameters, iRequester);
        return this.transformValue(o, functionResult);
    }

    public Object getResult() {
        return this.transformValue(null, this.function.getResult());
    }

    public void setResult(Object iValue) {
        this.function.setResult(iValue);
    }

    public Object getValue(OIdentifiable iRecord, OCommandContext iContetx) {
        return this.execute(iRecord != null ? (ORecordSchemaAware)iRecord.getRecord() : null, null);
    }

    public String getRoot() {
        return this.function.getName();
    }

    protected void setRoot(OCommandToParse iQueryToParse, String iText) {
        int i;
        int beginParenthesis = iText.indexOf(40);
        String funcName = iText.substring(0, beginParenthesis);
        List<String> funcParamsText = OStringSerializerHelper.getParameters(iText);
        this.function = OSQLEngine.getInstance().getInlineFunction(funcName);
        if (this.function == null) {
            this.function = OSQLEngine.getInstance().getAggregationFunction(funcName);
        }
        if (this.function == null) {
            throw new OCommandSQLParsingException("Unknow function " + funcName + "()");
        }
        if (this.function.getMinParams() > -1 && funcParamsText.size() < this.function.getMinParams() || this.function.getMaxParams() > -1 && funcParamsText.size() > this.function.getMaxParams()) {
            throw new IllegalArgumentException("Syntax error. Expected: " + this.function.getSyntax());
        }
        this.configuredParameters = new Object[funcParamsText.size()];
        for (i = 0; i < funcParamsText.size(); ++i) {
            this.configuredParameters[i] = OSQLHelper.parseValue(null, iQueryToParse, funcParamsText.get(i), null);
        }
        this.runtimeParameters = new Object[this.configuredParameters.length];
        for (i = 0; i < this.configuredParameters.length; ++i) {
            if (this.configuredParameters[i] instanceof OSQLFilterItemField || this.configuredParameters[i] instanceof OSQLFunctionRuntime) continue;
            this.runtimeParameters[i] = this.configuredParameters[i];
        }
    }
}

