/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandToParse;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterFieldOperator;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemAbstract;
import java.util.List;

public class OSQLFilterItemField
extends OSQLFilterItemAbstract {
    protected String name;

    public OSQLFilterItemField(OCommandToParse iQueryToParse, String iName) {
        super(iQueryToParse, iName);
    }

    public Object getValue(OIdentifiable iRecord, OCommandContext iContetx) {
        if (iRecord == null) {
            throw new OCommandExecutionException("expression item '" + this.name + "' cannot be resolved");
        }
        return this.transformValue(iRecord, ODocumentHelper.getFieldValue((ODocument)iRecord, this.name));
    }

    public String getRoot() {
        return this.name;
    }

    public void setRoot(OCommandToParse iQueryToParse, String iRoot) {
        this.name = iRoot;
    }

    public boolean isFieldChain() {
        if (this.operationsChain == null) {
            return true;
        }
        for (OPair pair : this.operationsChain) {
            if (((Integer)pair.getKey()).equals(OSQLFilterFieldOperator.FIELD.id)) continue;
            return false;
        }
        return true;
    }

    public FieldChain getFieldChain() {
        if (!this.isFieldChain()) {
            throw new IllegalStateException("Filter item field contains not only field operators");
        }
        return new FieldChain();
    }

    public class FieldChain {
        private FieldChain() {
        }

        public String getItemName(int fieldIndex) {
            if (fieldIndex == 0) {
                return OSQLFilterItemField.this.name;
            }
            return (String)((List)((OPair)OSQLFilterItemField.this.operationsChain.get(fieldIndex - 1)).getValue()).get(0);
        }

        public int getItemCount() {
            if (OSQLFilterItemField.this.operationsChain == null) {
                return 1;
            }
            return OSQLFilterItemField.this.operationsChain.size() + 1;
        }

        public boolean isLong() {
            return OSQLFilterItemField.this.operationsChain != null && OSQLFilterItemField.this.operationsChain.size() > 0;
        }
    }
}

