/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandToParse;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLHelper {
    public static final String NAME = "sql";
    public static final String VALUE_NOT_PARSED = "_NOT_PARSED_";
    public static final String NOT_NULL = "_NOT_NULL_";
    public static final String DEFINED = "_DEFINED_";

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase) {
        return OSQLHelper.nextWord(iText, iTextUpperCase, ioCurrentPosition, ioWord, iForceUpperCase, " =><()");
    }

    public static int nextWord(String iText, String iTextUpperCase, int ioCurrentPosition, StringBuilder ioWord, boolean iForceUpperCase, String iSeparatorChars) {
        ioWord.setLength(0);
        ioCurrentPosition = OStringParser.jumpWhiteSpaces(iText, ioCurrentPosition);
        if (ioCurrentPosition < 0) {
            return -1;
        }
        String word = OStringParser.getWordFromString(iForceUpperCase ? iTextUpperCase : iText, ioCurrentPosition, iSeparatorChars);
        if (word != null && word.length() > 0) {
            ioWord.append(word);
            ioCurrentPosition += word.length();
        }
        return ioCurrentPosition;
    }

    public static Object parseValue(String iValue, OCommandContext iContext) {
        if (iValue == null) {
            return null;
        }
        iValue = iValue.trim();
        Object fieldValue = VALUE_NOT_PARSED;
        if (iValue.startsWith("'") && iValue.endsWith("'") || iValue.startsWith("\"") && iValue.endsWith("\"")) {
            fieldValue = OStringSerializerHelper.getStringContent(iValue);
        } else if (iValue.charAt(0) == '[' && iValue.charAt(iValue.length() - 1) == ']') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            ArrayList<Object> coll = new ArrayList<Object>();
            for (String item : items) {
                coll.add(OSQLHelper.parseValue(item, iContext));
            }
            fieldValue = coll;
        } else if (iValue.charAt(0) == '{' && iValue.charAt(iValue.length() - 1) == '}') {
            List<String> items = OStringSerializerHelper.smartSplit(iValue.substring(1, iValue.length() - 1), ',', new char[0]);
            HashMap<Object, Object> map = new HashMap<Object, Object>();
            for (String item : items) {
                List<String> parts = OStringSerializerHelper.smartSplit(item, ':', new char[0]);
                if (parts == null || parts.size() != 2) {
                    throw new OCommandSQLParsingException("Map found but entries are not defined as <key>:<value>");
                }
                map.put(OSQLHelper.parseValue(parts.get(0), iContext), OSQLHelper.parseValue(parts.get(1), iContext));
            }
            fieldValue = map;
        } else if (iValue.charAt(0) == '#') {
            fieldValue = new ORecordId(iValue.trim());
        } else {
            String upperCase = iValue.toUpperCase(Locale.ENGLISH);
            if (upperCase.equals("NULL")) {
                fieldValue = null;
            } else if (upperCase.equals("NOT NULL")) {
                fieldValue = NOT_NULL;
            } else if (upperCase.equals("DEFINED")) {
                fieldValue = DEFINED;
            } else if (upperCase.equals("TRUE")) {
                fieldValue = Boolean.TRUE;
            } else if (upperCase.equals("FALSE")) {
                fieldValue = Boolean.FALSE;
            } else {
                Object v = OSQLHelper.parseStringNumber(iValue);
                if (v != null) {
                    fieldValue = v;
                }
            }
        }
        return fieldValue;
    }

    public static Object parseStringNumber(String iValue) {
        OType t = ORecordSerializerCSVAbstract.getType(iValue);
        if (t == OType.INTEGER) {
            return Integer.parseInt(iValue);
        }
        if (t == OType.LONG) {
            return Long.parseLong(iValue);
        }
        if (t == OType.FLOAT) {
            return Float.valueOf(Float.parseFloat(iValue));
        }
        if (t == OType.SHORT) {
            return Short.parseShort(iValue);
        }
        if (t == OType.BYTE) {
            return Byte.parseByte(iValue);
        }
        if (t == OType.DOUBLE) {
            return Double.parseDouble(iValue);
        }
        if (t == OType.DATE || t == OType.DATETIME) {
            return new Date(Long.parseLong(iValue));
        }
        return null;
    }

    public static Object parseValue(OSQLFilter iSQLFilter, OCommandToParse iCommand, String iWord, OCommandContext iContext) {
        if (iWord.charAt(0) == '?' || iWord.charAt(0) == ':') {
            if (iSQLFilter != null) {
                return iSQLFilter.addParameter(iWord);
            }
            return new OSQLFilterItemParameter(iWord);
        }
        return OSQLHelper.parseValue(iCommand, iWord, iContext);
    }

    public static Object parseValue(OCommandToParse iCommand, String iWord, OCommandContext iContext) {
        if (iWord.equals("*")) {
            return "*";
        }
        Object v = OSQLHelper.parseValue(iWord, iContext);
        if (v != VALUE_NOT_PARSED) {
            return v;
        }
        Object func = OSQLHelper.getFunction(iCommand, iWord);
        if (func != null) {
            return func;
        }
        if (iWord.startsWith("$")) {
            return new OSQLFilterItemVariable(iCommand, iWord);
        }
        return new OSQLFilterItemField(iCommand, iWord);
    }

    public static Object getFunction(OCommandToParse iCommand, String iWord) {
        int endParenthesis;
        int separator = iWord.indexOf(46);
        int beginParenthesis = iWord.indexOf(40);
        if (beginParenthesis > -1 && (separator == -1 || separator > beginParenthesis) && (endParenthesis = iWord.indexOf(41, beginParenthesis)) > -1 && Character.isLetter(iWord.charAt(0))) {
            return new OSQLFunctionRuntime(iCommand, iWord);
        }
        return null;
    }

    public static Object getValue(Object iObject) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(null, null);
        }
        return iObject;
    }

    public static Object getValue(Object iObject, ORecordInternal<?> iRecord) {
        if (iObject == null) {
            return null;
        }
        if (iObject instanceof OSQLFilterItem) {
            return ((OSQLFilterItem)iObject).getValue(iRecord, null);
        }
        return iObject;
    }

    public static void bindParameters(ODocument iDocument, Map<String, Object> iFields, Map<Object, Object> iArgs) {
        int paramCounter = 0;
        for (Map.Entry<String, Object> field : iFields.entrySet()) {
            if (field.getValue() instanceof OSQLFilterItemField) {
                OSQLFilterItemField f = (OSQLFilterItemField)field.getValue();
                if (f.getRoot().equals("?")) {
                    iDocument.field(field.getKey(), iArgs.get(paramCounter++));
                    continue;
                }
                if (f.getRoot().startsWith(":")) {
                    iDocument.field(field.getKey(), iArgs.get(f.getRoot().substring(1)));
                    continue;
                }
            }
            iDocument.field(field.getKey(), OSQLHelper.getValue(field.getValue(), iDocument));
        }
    }
}

