/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterDatabase;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateLink;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelete;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFindReferences;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLGrant;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLInsert;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRebuildIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRevoke;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTraverse;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateRecord;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLUpdate;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDifference;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDistinct;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionIntersect;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionUnion;
import com.orientechnologies.orient.core.sql.functions.geo.OSQLFunctionDistance;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionAverage;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMax;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMin;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionSum;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDate;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionFormat;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionSysdate;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorAnd;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContains;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsAll;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsKey;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsText;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorContainsValue;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorInstanceof;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIs;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorLike;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMatches;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNot;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNotEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorOr;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorTraverse;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorDivide;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMinus;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMod;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorMultiply;
import com.orientechnologies.orient.core.sql.operator.math.OQueryOperatorPlus;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLEngine {
    private Map<String, OSQLFunction> inlineFunctions = new HashMap<String, OSQLFunction>();
    private Map<String, Class<? extends OSQLFunction>> aggregationFunctions = new HashMap<String, Class<? extends OSQLFunction>>();
    protected Map<String, Class<? extends OCommandExecutorSQLAbstract>> commands = new HashMap<String, Class<? extends OCommandExecutorSQLAbstract>>();
    public static OQueryOperator[] RECORD_OPERATORS = new OQueryOperator[]{new OQueryOperatorEquals(), new OQueryOperatorAnd(), new OQueryOperatorOr(), new OQueryOperatorNotEquals(), new OQueryOperatorNot(), new OQueryOperatorMinorEquals(), new OQueryOperatorMinor(), new OQueryOperatorMajorEquals(), new OQueryOperatorContainsAll(), new OQueryOperatorMajor(), new OQueryOperatorLike(), new OQueryOperatorMatches(), new OQueryOperatorInstanceof(), new OQueryOperatorIs(), new OQueryOperatorIn(), new OQueryOperatorContainsKey(), new OQueryOperatorContainsValue(), new OQueryOperatorContainsText(), new OQueryOperatorContains(), new OQueryOperatorContainsText(), new OQueryOperatorTraverse(), new OQueryOperatorBetween(), new OQueryOperatorPlus(), new OQueryOperatorMinus(), new OQueryOperatorMultiply(), new OQueryOperatorDivide(), new OQueryOperatorMod()};
    protected static OSQLEngine INSTANCE = new OSQLEngine();

    protected OSQLEngine() {
        this.commands.put("ALTER DATABASE", OCommandExecutorSQLAlterDatabase.class);
        this.commands.put("SELECT", OCommandExecutorSQLSelect.class);
        this.commands.put("TRAVERSE", OCommandExecutorSQLTraverse.class);
        this.commands.put("INSERT", OCommandExecutorSQLInsert.class);
        this.commands.put("UPDATE", OCommandExecutorSQLUpdate.class);
        this.commands.put("DELETE", OCommandExecutorSQLDelete.class);
        this.commands.put("GRANT", OCommandExecutorSQLGrant.class);
        this.commands.put("REVOKE", OCommandExecutorSQLRevoke.class);
        this.commands.put("CREATE LINK", OCommandExecutorSQLCreateLink.class);
        this.commands.put("CREATE INDEX", OCommandExecutorSQLCreateIndex.class);
        this.commands.put("DROP INDEX", OCommandExecutorSQLDropIndex.class);
        this.commands.put("REBUILD INDEX", OCommandExecutorSQLRebuildIndex.class);
        this.commands.put("CREATE CLASS", OCommandExecutorSQLCreateClass.class);
        this.commands.put("ALTER CLASS", OCommandExecutorSQLAlterClass.class);
        this.commands.put("CREATE PROPERTY", OCommandExecutorSQLCreateProperty.class);
        this.commands.put("ALTER PROPERTY", OCommandExecutorSQLAlterProperty.class);
        this.commands.put("DROP CLASS", OCommandExecutorSQLDropClass.class);
        this.commands.put("DROP PROPERTY", OCommandExecutorSQLDropProperty.class);
        this.commands.put("FIND REFERENCES", OCommandExecutorSQLFindReferences.class);
        this.commands.put("TRUNCATE CLASS", OCommandExecutorSQLTruncateClass.class);
        this.commands.put("TRUNCATE CLUSTER", OCommandExecutorSQLTruncateCluster.class);
        this.commands.put("TRUNCATE RECORD", OCommandExecutorSQLTruncateRecord.class);
        this.commands.put("ALTER CLUSTER", OCommandExecutorSQLAlterCluster.class);
        this.registerFunction("format", new OSQLFunctionFormat());
        this.registerFunction("date", OSQLFunctionDate.class);
        this.registerFunction("sysdate", OSQLFunctionSysdate.class);
        this.registerFunction("count", OSQLFunctionCount.class);
        this.registerFunction("distinct", OSQLFunctionDistinct.class);
        this.registerFunction("union", OSQLFunctionUnion.class);
        this.registerFunction("intersect", OSQLFunctionIntersect.class);
        this.registerFunction("difference", OSQLFunctionDifference.class);
        this.registerFunction("min", OSQLFunctionMin.class);
        this.registerFunction("max", OSQLFunctionMax.class);
        this.registerFunction("sum", OSQLFunctionSum.class);
        this.registerFunction("avg", OSQLFunctionAverage.class);
        this.registerFunction("distance", new OSQLFunctionDistance());
    }

    public OQueryOperator[] getRecordOperators() {
        return RECORD_OPERATORS;
    }

    public static void registerOperator(OQueryOperator iOperator) {
        OQueryOperator[] ops = new OQueryOperator[RECORD_OPERATORS.length + 1];
        System.arraycopy(RECORD_OPERATORS, 0, ops, 0, RECORD_OPERATORS.length);
        RECORD_OPERATORS = ops;
    }

    public void registerFunction(String iName, OSQLFunction iFunction) {
        this.inlineFunctions.put(iName.toUpperCase(Locale.ENGLISH), iFunction);
    }

    public void registerFunction(String iName, Class<? extends OSQLFunction> iFunctionClass) {
        this.aggregationFunctions.put(iName.toUpperCase(Locale.ENGLISH), iFunctionClass);
    }

    public void unregisterInlineFunction(String iName) {
        this.inlineFunctions.remove(iName.toUpperCase(Locale.ENGLISH));
    }

    public OSQLFunction getInlineFunction(String iFunctionName) {
        return this.inlineFunctions.get(iFunctionName.toUpperCase(Locale.ENGLISH));
    }

    public OSQLFunction getAggregationFunction(String iFunctionName) {
        Class<? extends OSQLFunction> f = this.aggregationFunctions.get(iFunctionName.toUpperCase(Locale.ENGLISH));
        if (f != null) {
            try {
                return f.newInstance();
            }
            catch (Exception e) {
                throw new OCommandExecutionException("Error in creation of function " + iFunctionName + "(). Probably there is not an empty constructor or the constructor generates errors", e);
            }
        }
        return null;
    }

    public void unregisterFunction(String iName) {
        String name = iName.toUpperCase(Locale.ENGLISH);
        if (this.inlineFunctions.remove(name) == null) {
            this.aggregationFunctions.remove(name);
        }
    }

    public OCommandExecutorSQLAbstract getCommand(String iText) {
        int pos = -1;
        Class<? extends OCommandExecutorSQLAbstract> commandClass = null;
        while (commandClass == null && (pos = iText.indexOf(32, pos + 1)) > -1) {
            String piece = iText.substring(0, pos);
            commandClass = this.commands.get(piece);
        }
        if (commandClass != null) {
            try {
                return (OCommandExecutorSQLAbstract)commandClass.newInstance();
            }
            catch (Exception e) {
                throw new OCommandExecutionException("Error in creation of command " + commandClass + "(). Probably there is not an empty constructor or the constructor generates errors", e);
            }
        }
        return null;
    }

    public OSQLFilter parseFromWhereCondition(String iText, OCommandContext iContext) {
        return new OSQLFilter(iText, iContext);
    }

    public static OSQLEngine getInstance() {
        return INSTANCE;
    }
}

