/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLExtractAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLTraverse
extends OCommandExecutorSQLExtractAbstract {
    public static final String KEYWORD_TRAVERSE = "TRAVERSE";
    private Set<String> fields;

    @Override
    public OCommandExecutorSQLTraverse parse(OCommandRequestText iRequest) {
        super.parse(iRequest);
        int pos = this.parseFields();
        if (pos == -1) {
            throw new OCommandSQLParsingException("Traverse must have the field list. Use " + this.getSyntax());
        }
        int endPosition = this.text.length();
        int endP = this.textUpperCase.indexOf(" LIMIT", this.currentPos);
        if (endP > -1 && endP < endPosition) {
            endPosition = endP;
        }
        this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(this.text.substring(pos, endPosition), this.context);
        this.optimize();
        int n = this.currentPos = this.compiledFilter.currentPos < 0 ? endPosition : this.compiledFilter.currentPos + pos;
        if (this.currentPos > -1 && this.currentPos < this.text.length()) {
            this.currentPos = OStringParser.jump(this.text, this.currentPos, " \r\n");
            StringBuilder word = new StringBuilder();
            while (this.currentPos > -1) {
                String w;
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                if (this.currentPos <= -1 || !(w = word.toString()).equals("LIMIT")) continue;
                this.parseLimit(word);
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (!this.assignTarget(iArgs)) {
            throw new OQueryParsingException("No source found in query: specify class, cluster(s) or single record(s)");
        }
        this.executeTraverse();
        this.applyLimit();
        return this.handleResult();
    }

    protected void executeTraverse() {
        if (this.target == null) {
            throw new OCommandExecutionException("Traverse error: target not specified");
        }
        this.context = new OTraverseContext();
        for (OIdentifiable id : this.target) {
            this.traverse(id, this.compiledFilter.getRootCondition());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void traverse(Object iTarget, OSQLFilterCondition iCondition) {
        Object conditionResult;
        if (!(iTarget instanceof OIdentifiable)) {
            return;
        }
        ++((OTraverseContext)this.context).traversedRecords;
        if (((OTraverseContext)this.context).evaluatedRecords.contains(((OIdentifiable)iTarget).getIdentity())) {
            return;
        }
        ORecord<?> record = ((OIdentifiable)iTarget).getRecord();
        if (!(record instanceof ODocument)) {
            return;
        }
        ODocument target = (ODocument)record;
        if (target.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            try {
                target.load();
            }
            catch (ORecordNotFoundException e) {
                return;
            }
        }
        ((OTraverseContext)this.context).evaluatedRecords.add(record.getIdentity());
        if (iCondition != null && (conditionResult = iCondition.evaluate(target, this.context)) != Boolean.TRUE) {
            return;
        }
        this.addResult(target);
        ((OTraverseContext)this.context).depth++;
        try {
            for (String cfgField : this.fields) {
                if ("*".equals(cfgField) || "ALL()".equals(cfgField) || "ANY()".equals(cfgField)) {
                    for (String fieldName : target.fieldNames()) {
                        this.traverseField(target.rawField(fieldName), iCondition);
                    }
                    continue;
                }
                int pos = cfgField.indexOf(46);
                if (pos > -1) {
                    String className;
                    OClass cls = target.getSchemaClass();
                    if (cls == null || !cls.isSubClassOf(className = cfgField.substring(0, pos))) continue;
                    cfgField = cfgField.substring(pos + 1);
                }
                this.traverseField(target.rawField(cfgField), iCondition);
            }
            Object var12_15 = null;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            ((OTraverseContext)this.context).depth--;
            throw throwable;
        }
        ((OTraverseContext)this.context).depth--;
    }

    protected void traverseField(Object iFieldValue, OSQLFilterCondition iCondition) {
        if (iFieldValue == null) {
            return;
        }
        if (OMultiValue.isMultiValue(iFieldValue)) {
            for (Object o : OMultiValue.getMultiValueIterable(iFieldValue)) {
                this.traverse(o, iCondition);
            }
        } else if (iFieldValue instanceof OIdentifiable) {
            this.traverse(iFieldValue, iCondition);
        }
    }

    protected int parseFields() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, currentPos, word, true);
        if (!word.toString().equals(KEYWORD_TRAVERSE)) {
            return -1;
        }
        int fromPosition = this.textUpperCase.indexOf(" FROM ", currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.text, currentPos);
        }
        String fieldString = this.text.substring(currentPos, fromPosition).trim();
        if (fieldString.length() > 0) {
            this.fields = new HashSet<String>();
            List<String> items = OStringSerializerHelper.smartSplit(fieldString, ',', new char[0]);
            for (String field : items) {
                this.fields.add(field.trim());
            }
        } else {
            throw new OQueryParsingException("Missed field list to cross in TRAVERSE. Use " + this.getSyntax(), this.text, currentPos);
        }
        currentPos = fromPosition + "FROM".length() + 1;
        return currentPos;
    }

    @Override
    public String getSyntax() {
        return "TRAVERSE <field>* FROM <target> [WHERE <filter>]";
    }

    public class OTraverseContext
    implements OCommandContext {
        public int traversedRecords = 0;
        public Set<ORID> evaluatedRecords = new HashSet<ORID>();
        private int depth;

        public Object getVariable(String iName) {
            if ("depth".equalsIgnoreCase(iName)) {
                return this.depth;
            }
            return null;
        }

        public void setVariable(String iName, Object iValue) {
            if ("depth".equalsIgnoreCase(iName)) {
                throw new OCommandExecutionException("Cannot change read-only 'depth' variable. Current value is: " + this.depth);
            }
        }
    }
}

