/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLInsert
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_INSERT = "INSERT";
    private static final String KEYWORD_VALUES = "VALUES";
    private static final String KEYWORD_INTO = "INTO";
    private String className = null;
    private String clusterName = null;
    private String indexName = null;
    private Map<String, Object> fields;

    public OCommandExecutorSQLInsert parse(OCommandRequestText iRequest) {
        int i;
        ODatabaseRecord database = this.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_CREATE);
        this.init(iRequest.getText());
        this.className = null;
        this.fields = null;
        StringBuilder word = new StringBuilder();
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, 0, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_INSERT)) {
            throw new OCommandSQLParsingException("Keyword INSERT not found. Use " + this.getSyntax(), this.text, 0);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_INTO)) {
            throw new OCommandSQLParsingException("Keyword INTO not found. Use " + this.getSyntax(), this.text, 0);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid subject name. Expected cluster, class or index. Use " + this.getSyntax(), this.text, pos);
        }
        String subjectName = word.toString();
        if (subjectName.startsWith("CLUSTER:")) {
            this.clusterName = subjectName.substring("CLUSTER:".length());
        } else if (subjectName.startsWith("INDEX:")) {
            this.indexName = subjectName.substring("INDEX:".length());
        } else {
            OClass cls;
            if (subjectName.startsWith("CLASS:")) {
                subjectName = subjectName.substring("CLASS:".length());
            }
            if ((cls = database.getMetadata().getSchema().getClass(subjectName)) == null) {
                throw new OCommandSQLParsingException("Class " + subjectName + " not found in database", this.text, pos);
            }
            this.className = cls.getName();
        }
        int beginFields = OStringParser.jumpWhiteSpaces(this.text, pos);
        if (beginFields == -1 || this.text.charAt(beginFields) != '(') {
            throw new OCommandSQLParsingException("Set of fields is missed. Example: (name, surname). Use " + this.getSyntax(), this.text, pos);
        }
        int endFields = this.text.indexOf(41, beginFields + 1);
        if (endFields == -1) {
            throw new OCommandSQLParsingException("Missed closed brace. Use " + this.getSyntax(), this.text, beginFields);
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        OStringSerializerHelper.getParameters(this.text, beginFields, endFields, fieldNames);
        if (fieldNames.size() == 0) {
            throw new OCommandSQLParsingException("Set of fields is empty. Example: (name, surname). Use " + this.getSyntax(), this.text, endFields);
        }
        for (int i2 = 0; i2 < fieldNames.size(); ++i2) {
            fieldNames.set(i2, OStringSerializerHelper.removeQuotationMarks(fieldNames.get(i2)));
        }
        pos = OSQLHelper.nextWord(this.text, this.textUpperCase, endFields + 1, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_VALUES)) {
            throw new OCommandSQLParsingException("Missed VALUES keyword. Use " + this.getSyntax(), this.text, endFields);
        }
        int beginValues = OStringParser.jumpWhiteSpaces(this.text, pos);
        if (pos == -1 || this.text.charAt(beginValues) != '(') {
            throw new OCommandSQLParsingException("Set of values is missed. Example: ('Bill', 'Stuart', 300). Use " + this.getSyntax(), this.text, pos);
        }
        int endValues = this.text.lastIndexOf(41);
        if (endValues == -1) {
            throw new OCommandSQLParsingException("Missed closed brace. Use " + this.getSyntax(), this.text, beginValues);
        }
        List<String> values = OStringSerializerHelper.smartSplit(this.text, new char[]{','}, beginValues + 1, endValues - 1, true, new char[0]);
        if (values.size() == 0) {
            throw new OCommandSQLParsingException("Set of values is empty. Example: ('Bill', 'Stuart', 300). Use " + this.getSyntax(), this.text, beginValues);
        }
        if (values.size() != fieldNames.size()) {
            throw new OCommandSQLParsingException("Fields not match with values", this.text, beginValues);
        }
        Object[] fieldValues = new Object[values.size()];
        for (i = 0; i < values.size(); ++i) {
            fieldValues[i] = OSQLHelper.parseValue(this, OStringSerializerHelper.decode(values.get(i).trim()), this.context);
        }
        this.fields = new LinkedHashMap<String, Object>();
        for (i = 0; i < fieldNames.size(); ++i) {
            this.fields.put(fieldNames.get(i), fieldValues[i]);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.fields == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.indexName != null) {
            OIndex<?> index = this.getDatabase().getMetadata().getIndexManager().getIndex(this.indexName);
            if (index == null) {
                throw new OCommandExecutionException("Target index '" + this.indexName + "' not found");
            }
            index.put(this.fields.get("key"), (OIdentifiable)this.fields.get("rid"));
            return null;
        }
        ODocument doc = this.className != null ? new ODocument(this.className) : new ODocument();
        OSQLHelper.bindParameters(doc, this.fields, iArgs);
        if (this.clusterName != null) {
            doc.save(this.clusterName);
        } else {
            doc.save();
        }
        return doc;
    }

    @Override
    public String getSyntax() {
        return "INSERT INTO <Class>|cluster:<cluster>|index:<index> (<field>[,]*) VALUES (<expression>[,]*)";
    }
}

