/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.object.OLazyObjectList;
import com.orientechnologies.orient.core.db.object.OLazyObjectMap;
import com.orientechnologies.orient.core.db.object.OLazyObjectSet;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordLazyList;
import com.orientechnologies.orient.core.db.record.ORecordLazyMap;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLFindReferences
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_FIND = "FIND";
    public static final String KEYWORD_REFERENCES = "REFERENCES";
    private ORID recordId;
    private String classList;

    public OCommandExecutorSQLFindReferences parse(OCommandRequestText iRequest) {
        this.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_FIND)) {
            throw new OCommandSQLParsingException("Keyword FIND not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_REFERENCES)) {
            throw new OCommandSQLParsingException("Keyword REFERENCES not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <recordId>. Use " + this.getSyntax(), this.text, oldPos);
        }
        String recordIdString = word.toString();
        if (recordIdString == null || recordIdString.equals("")) {
            throw new OCommandSQLParsingException("Record to search cannot be null. Use " + this.getSyntax(), this.text, pos);
        }
        try {
            this.recordId = new ORecordId(recordIdString);
            if (!this.recordId.isValid()) {
                throw new OCommandSQLParsingException("Record ID " + recordIdString + " is not valid", this.text, pos);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new OCommandSQLParsingException("Error reading record Id", this.text, pos, iae);
        }
        oldPos = pos;
        pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos != -1) {
            this.classList = word.toString().trim();
            if (!this.classList.startsWith("[") || !this.classList.endsWith("]")) {
                throw new OCommandSQLParsingException("Class list must be contained in []. Use " + this.getSyntax(), this.text, pos);
            }
            this.classList = this.classList.substring(1, this.classList.length() - 1);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.recordId == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = this.getDatabase();
        HashSet<ORID> result = new HashSet<ORID>();
        if (this.classList == null || this.classList.equals("")) {
            for (String clusterName : database.getClusterNames()) {
                this.browseCluster(clusterName, result);
            }
        } else {
            List<String> classes = OStringSerializerHelper.smartSplit(this.classList, ',', new char[0]);
            for (String clazz : classes) {
                if (clazz.startsWith("CLUSTER:")) {
                    this.browseCluster(clazz.substring(clazz.indexOf("CLUSTER:") + "CLUSTER:".length()), result);
                    continue;
                }
                this.browseClass(clazz, result);
            }
        }
        return new ArrayList(result);
    }

    private void browseCluster(String iClusterName, Set<ORID> ids) {
        ODatabaseRecord database = this.getDatabase();
        for (ORecordInternal record : database.browseCluster(iClusterName)) {
            if (!(record instanceof ODocument)) continue;
            try {
                for (String fieldName : ((ODocument)record).fieldNames()) {
                    Object value = ((ODocument)record).field(fieldName);
                    this.checkObject(ids, value, (ODocument)record);
                }
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error reading record " + record.getIdentity(), (Throwable)e, new Object[0]);
            }
        }
    }

    private void browseClass(String iClassName, Set<ORID> ids) {
        ODatabaseRecord database = this.getDatabase();
        OClass clazz = database.getMetadata().getSchema().getClass(iClassName);
        if (clazz == null) {
            throw new OCommandExecutionException("Class '" + iClassName + "' was not found");
        }
        for (int i : clazz.getClusterIds()) {
            this.browseCluster(database.getClusterNameById(i), ids);
        }
    }

    private void checkObject(Set<ORID> ids, Object value, ODocument iRootObject) {
        if (value instanceof OIdentifiable) {
            this.checkDocument(ids, (OIdentifiable)value, iRootObject);
        } else if (value instanceof Collection) {
            this.checkCollection(ids, (Collection)value, iRootObject);
        } else if (value instanceof Map) {
            this.checkMap(ids, (Map)value, iRootObject);
        }
    }

    private void checkDocument(Set<ORID> ids, OIdentifiable value, ODocument iRootObject) {
        if (value.getIdentity().equals(this.recordId)) {
            ids.add(iRootObject.getIdentity());
        }
    }

    private void checkCollection(Set<ORID> ids, Collection<?> values, ODocument iRootObject) {
        Iterator<Object> it;
        if (values instanceof OLazyObjectList) {
            ((OLazyObjectList)values).setConvertToRecord(false);
            it = ((OLazyObjectList)values).listIterator();
        } else if (values instanceof OLazyObjectSet) {
            ((OLazyObjectSet)values).setConvertToRecord(false);
            it = ((OLazyObjectSet)values).iterator();
        } else {
            it = values instanceof ORecordLazyList ? ((ORecordLazyList)values).rawIterator() : (values instanceof OMVRBTreeRIDSet ? ((OMVRBTreeRIDSet)values).iterator() : values.iterator());
        }
        while (it.hasNext()) {
            this.checkObject(ids, it.next(), iRootObject);
        }
    }

    private void checkMap(Set<ORID> ids, Map<?, ?> values, ODocument iRootObject) {
        Iterator<Object> it;
        if (values instanceof OLazyObjectMap) {
            ((OLazyObjectMap)values).setConvertToRecord(false);
            it = ((OLazyObjectMap)values).values().iterator();
        } else {
            it = values instanceof ORecordLazyMap ? ((ORecordLazyMap)values).rawIterator() : values.values().iterator();
        }
        while (it.hasNext()) {
            this.checkObject(ids, it.next(), iRootObject);
        }
    }

    @Override
    public String getSyntax() {
        return "FIND REFERENCES <rid> [class-list]";
    }
}

