/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropClass
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;

    public OCommandExecutorSQLDropClass parse(OCommandRequestText iRequest) {
        this.getDatabase().checkSecurity("database.command", ORole.PERMISSION_DELETE);
        this.init(iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>. Use " + this.getSyntax(), this.text, pos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class is null. Use " + this.getSyntax(), this.text, pos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = this.getDatabase();
        OClass oClass = database.getMetadata().getSchema().getClass(this.className);
        if (oClass == null) {
            return null;
        }
        for (OIndex<?> oIndex : oClass.getClassIndexes()) {
            database.getMetadata().getIndexManager().dropIndex(oIndex.getName());
        }
        int clusterId = oClass.getDefaultClusterId();
        ((OSchemaProxy)database.getMetadata().getSchema()).dropClassInternal(this.className);
        ((OSchemaProxy)database.getMetadata().getSchema()).saveInternal();
        ((OSchemaProxy)database.getMetadata().getSchema()).reload();
        this.deleteDefaultCluster(clusterId);
        return true;
    }

    protected void deleteDefaultCluster(int clusterId) {
        ODatabaseRecord database = this.getDatabase();
        OCluster cluster = database.getStorage().getClusterById(clusterId);
        if (cluster.getName().equalsIgnoreCase(this.className) && this.isClusterDeletable(clusterId)) {
            database.getStorage().dropCluster(clusterId);
        }
    }

    protected boolean isClusterDeletable(int clusterId) {
        ODatabaseRecord database = this.getDatabase();
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            for (int i : iClass.getClusterIds()) {
                if (i != clusterId) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DROP CLASS <class>";
    }
}

