/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilter;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLQuery;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDelete
extends OCommandExecutorSQLAbstract
implements OCommandResultListener {
    public static final String KEYWORD_DELETE = "DELETE";
    private static final String VALUE_NOT_FOUND = "_not_found_";
    private OSQLQuery<ODocument> query;
    private String indexName = null;
    private int recordCount = 0;
    private OSQLFilter compiledFilter;

    public OCommandExecutorSQLDelete parse(OCommandRequestText iRequest) {
        ODatabaseRecord database = this.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_DELETE);
        this.init(iRequest.getText());
        this.query = null;
        this.recordCount = 0;
        StringBuilder word = new StringBuilder();
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, 0, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DELETE)) {
            throw new OCommandSQLParsingException("Keyword DELETE not found. Use " + this.getSyntax(), this.text, 0);
        }
        int oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals("FROM")) {
            throw new OCommandSQLParsingException("Keyword FROM not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Invalid subject name. Expected cluster, class or index. Use " + this.getSyntax(), this.text, oldPos);
        }
        String subjectName = word.toString();
        if (subjectName.startsWith("INDEX:")) {
            this.indexName = subjectName.substring("INDEX:".length());
            this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(this.text.substring(oldPos), this.context);
        } else {
            this.query = (OSQLQuery)database.command(new OSQLAsynchQuery("select from " + subjectName + " " + this.text.substring(pos), this));
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.query == null && this.indexName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.query != null) {
            this.query.execute(iArgs);
            return this.recordCount;
        }
        OIndex<?> index = this.getDatabase().getMetadata().getIndexManager().getIndex(this.indexName);
        if (index == null) {
            throw new OCommandExecutionException("Target index '" + this.indexName + "' not found");
        }
        Object key = null;
        Object value = VALUE_NOT_FOUND;
        if (this.compiledFilter.getRootCondition() == null) {
            long total = index.getSize();
            index.clear();
            return total;
        }
        if ("key".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
            key = this.compiledFilter.getRootCondition().getRight();
        } else if (this.compiledFilter.getRootCondition().getLeft() instanceof OSQLFilterCondition) {
            OSQLFilterCondition rightCondition;
            OSQLFilterCondition leftCondition = (OSQLFilterCondition)this.compiledFilter.getRootCondition().getLeft();
            if ("key".equalsIgnoreCase(leftCondition.getLeft().toString())) {
                key = leftCondition.getRight();
            }
            if ("rid".equalsIgnoreCase((rightCondition = (OSQLFilterCondition)this.compiledFilter.getRootCondition().getRight()).getLeft().toString())) {
                value = rightCondition.getRight();
            }
        }
        if (key == null) {
            throw new OCommandExecutionException("'Key' field is required for queries against indexes");
        }
        boolean result = value != VALUE_NOT_FOUND ? index.remove(key, (OIdentifiable)value) : index.remove(key);
        return result ? 1 : 0;
    }

    @Override
    public boolean result(Object iRecord) {
        ORecordAbstract record = (ORecordAbstract)iRecord;
        record.delete();
        ++this.recordCount;
        return true;
    }

    @Override
    public String getSyntax() {
        return "DELETE FROM <Class>|cluster:<cluster [WHERE <condition>*]";
    }
}

