/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateClass
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_CLASS = "CLASS";
    public static final String KEYWORD_EXTENDS = "EXTENDS";
    public static final String KEYWORD_CLUSTER = "CLUSTER";
    private String className;
    private OClass superClass;
    private int[] clusterIds;

    public OCommandExecutorSQLCreateClass parse(OCommandRequestText iRequest) {
        int clusterId;
        ODatabaseRecord database = this.getDatabase();
        database.checkSecurity("database.command", ORole.PERMISSION_CREATE);
        this.init(iRequest.getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>", this.text, oldPos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class " + this.className + " already exists", this.text, oldPos);
        }
        oldPos = pos;
        while ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) > -1) {
            String k = word.toString();
            if (k.equals(KEYWORD_EXTENDS)) {
                oldPos = pos;
                if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
                    throw new OCommandSQLParsingException("Syntax error after EXTENDS for class " + this.className + ". Expected the super-class name. Use " + this.getSyntax(), this.text, oldPos);
                }
                if (!database.getMetadata().getSchema().existsClass(word.toString())) {
                    throw new OCommandSQLParsingException("Super-class " + word + " not exists", this.text, oldPos);
                }
                this.superClass = database.getMetadata().getSchema().getClass(word.toString());
            } else if (k.equals(KEYWORD_CLUSTER)) {
                oldPos = pos;
                if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
                    throw new OCommandSQLParsingException("Syntax error after CLUSTER for class " + this.className + ". Expected the cluster id or name. Use " + this.getSyntax(), this.text, oldPos);
                }
                String[] clusterIdsAsStrings = word.toString().split(",");
                if (clusterIdsAsStrings.length > 0) {
                    this.clusterIds = new int[clusterIdsAsStrings.length];
                    for (int i = 0; i < clusterIdsAsStrings.length; ++i) {
                        this.clusterIds[i] = Character.isDigit(clusterIdsAsStrings[i].charAt(0)) ? Integer.parseInt(clusterIdsAsStrings[i]) : database.getStorage().getClusterIdByName(clusterIdsAsStrings[i]);
                        if (database.getStorage().getClusterById(this.clusterIds[i]) != null) continue;
                        throw new OCommandSQLParsingException("Cluster with id " + this.clusterIds[i] + " does not exists", this.text, oldPos);
                    }
                }
            }
            oldPos = pos;
        }
        if (this.clusterIds == null && (clusterId = database.getStorage().getClusterIdByName(this.className)) > -1) {
            this.clusterIds = new int[]{clusterId};
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = this.getDatabase();
        if (database.getMetadata().getSchema().existsClass(this.className)) {
            throw new OCommandExecutionException("Class " + this.className + " already exists");
        }
        OClassImpl sourceClass = (OClassImpl)((OSchemaProxy)database.getMetadata().getSchema()).createClassInternal(this.className, this.superClass, this.clusterIds);
        sourceClass.saveInternal();
        return database.getMetadata().getSchema().getClasses().size();
    }

    @Override
    public String getSyntax() {
        return "CREATE CLASS <class> [EXTENDS <super-class>] [CLUSTER <clusterId>*]";
    }
}

