/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

public class OStringSerializerAnyStreamable
implements OStringSerializer {
    public static final OStringSerializerAnyStreamable INSTANCE = new OStringSerializerAnyStreamable();
    public static final String NAME = "st";

    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        OSerializableStream instance = null;
        int propertyPos = iStream.indexOf(58);
        int pos = iStream.indexOf("|");
        if (pos < 0 || pos > propertyPos) {
            instance = new ODocument();
            pos = -1;
        } else {
            String className = iStream.substring(0, pos);
            try {
                Class<?> clazz = Class.forName(className);
                instance = (OSerializableStream)clazz.newInstance();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Error on unmarshalling content. Class: " + className, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        instance.fromStream(OBinaryProtocol.string2bytes(iStream.substring(pos + 1)));
        return instance;
    }

    public StringBuilder toStream(StringBuilder iOutput, Object iValue) {
        if (iValue != null) {
            if (!(iValue instanceof OSerializableStream)) {
                throw new OSerializationException("Cannot serialize the object since it's not implements the OSerializableStream interface");
            }
            OSerializableStream stream = (OSerializableStream)iValue;
            iOutput.append(iValue.getClass().getName());
            iOutput.append("|");
            iOutput.append(OBinaryProtocol.bytes2string(stream.toStream()));
        }
        return iOutput;
    }

    public String getName() {
        return NAME;
    }
}

