/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.string;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializer;

public class OStringSerializerAnyRuntime
implements OStringSerializer {
    public static final OStringSerializerAnyRuntime INSTANCE = new OStringSerializerAnyRuntime();
    private static final String NAME = "au";

    public String getName() {
        return NAME;
    }

    public Object fromStream(String iStream) {
        if (iStream == null || iStream.length() == 0) {
            return null;
        }
        int pos = iStream.indexOf("|");
        if (pos < 0) {
            OLogManager.instance().error((Object)this, "Class signature not found in ANY element: " + iStream, OSerializationException.class);
        }
        String className = iStream.substring(0, pos);
        try {
            Class<?> clazz = Class.forName(className);
            return clazz.getDeclaredConstructor(String.class).newInstance(iStream.substring(pos + 1));
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling content. Class: " + className, (Throwable)e, OSerializationException.class, new Object[0]);
            return null;
        }
    }

    public StringBuilder toStream(StringBuilder iOutput, Object iObject) {
        if (iObject != null) {
            iOutput.append(iObject.getClass().getName());
            iOutput.append("|");
            iOutput.append(iObject.toString());
        }
        return iOutput;
    }
}

