/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;

public class OStreamSerializerAnyStreamable
implements OStreamSerializer {
    public static final OStreamSerializerAnyStreamable INSTANCE = new OStreamSerializerAnyStreamable();
    public static final String NAME = "at";

    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        int classNameSize = OBinaryProtocol.bytes2int(iStream);
        if (classNameSize <= 0) {
            OLogManager.instance().error((Object)this, "Class signature not found in ANY element: " + iStream, OSerializationException.class);
        }
        String className = OBinaryProtocol.bytes2string(iStream, 4, classNameSize);
        try {
            Class<?> clazz = Class.forName(className);
            OSerializableStream stream = (OSerializableStream)clazz.newInstance();
            return stream.fromStream(OArrays.copyOfRange(iStream, 4 + classNameSize, iStream.length));
        }
        catch (Exception e) {
            OLogManager.instance().error((Object)this, "Error on unmarshalling content. Class: " + className, (Throwable)e, OSerializationException.class, new Object[0]);
            return null;
        }
    }

    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (!(iObject instanceof OSerializableStream)) {
            throw new OSerializationException("Cannot serialize the object [" + iObject.getClass() + ":" + iObject + "] since it does not implement the OSerializableStream interface");
        }
        OSerializableStream stream = (OSerializableStream)iObject;
        byte[] className = OBinaryProtocol.string2bytes(iObject.getClass().getName());
        byte[] objectContent = stream.toStream();
        byte[] result = new byte[4 + className.length + objectContent.length];
        System.arraycopy(OBinaryProtocol.int2bytes(className.length), 0, result, 0, 4);
        System.arraycopy(className, 0, result, 4, className.length);
        System.arraycopy(objectContent, 0, result, 4 + className.length, objectContent.length);
        return result;
    }

    public String getName() {
        return NAME;
    }
}

