/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerHelper;
import java.io.IOException;
import java.lang.reflect.Constructor;

public class OStreamSerializerAnyRecord
implements OStreamSerializer {
    public static final String NAME = "ar";
    public static final OStreamSerializerAnyRecord INSTANCE = new OStreamSerializerAnyRecord();

    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        String stream = OBinaryProtocol.bytes2string(iStream);
        Class<?> cls = null;
        try {
            StringBuilder content = new StringBuilder();
            cls = OStreamSerializerHelper.readRecordType(stream, content);
            for (Constructor<?> c : cls.getDeclaredConstructors()) {
                Class<?>[] params = c.getParameterTypes();
                if (params.length != 2 || !params[1].equals(ORID.class)) continue;
                ORecord rec = (ORecord)c.newInstance(new ORecordId(content.toString()));
                return rec;
            }
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error on unmarshalling content. Class %s", e, OSerializationException.class, cls.getName());
        }
        OLogManager.instance().exception("Cannot unmarshall the record since the serialized object of class %s has no constructor with suitable parameters: %s(ORID)", null, OSerializationException.class, cls.getSimpleName(), cls.getSimpleName());
        return null;
    }

    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return null;
        }
        if (((ORecord)iObject).getIdentity() == null) {
            throw new OSerializationException("Cannot serialize record without identity. Store it before serialization.");
        }
        StringBuilder buffer = OStreamSerializerHelper.writeRecordType(iObject.getClass(), new StringBuilder());
        buffer.append(((ORecord)iObject).getIdentity().toString());
        return OBinaryProtocol.string2bytes(buffer.toString());
    }

    public String getName() {
        return NAME;
    }
}

