/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OMemoryInputStream;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.IOException;

public class OCompositeKeySerializer
implements OStreamSerializer {
    public static final String NAME = "cks";
    public static final OCompositeKeySerializer INSTANCE = new OCompositeKeySerializer();

    public byte[] toStream(Object iObject) throws IOException {
        OCompositeKey compositeKey = (OCompositeKey)iObject;
        OMemoryStream outputStream = new OMemoryStream();
        outputStream.set(compositeKey.getKeys().size());
        for (Comparable comparable : compositeKey.getKeys()) {
            StringBuilder builder = new StringBuilder();
            OType type = OType.getTypeByClass(comparable.getClass());
            builder.append(type.toString());
            builder.append(",");
            ORecordSerializerStringAbstract.fieldTypeToString(builder, type, comparable);
            outputStream.set(OBinaryProtocol.string2bytes(builder.toString()));
        }
        return outputStream.toByteArray();
    }

    public Object fromStream(byte[] iStream) throws IOException {
        OCompositeKey compositeKey = new OCompositeKey();
        OMemoryInputStream inputStream = new OMemoryInputStream(iStream);
        int keysSize = inputStream.getAsInteger();
        for (int i = 0; i < keysSize; ++i) {
            byte[] keyBytes = inputStream.getAsByteArray();
            String keyString = OBinaryProtocol.bytes2string(keyBytes);
            int typeSeparatorPos = keyString.indexOf(44);
            OType type = OType.valueOf(keyString.substring(0, typeSeparatorPos));
            compositeKey.addKey((Comparable)ORecordSerializerStringAbstract.simpleValueFromStream(keyString.substring(typeSeparatorPos + 1), type));
        }
        return compositeKey;
    }

    public String getName() {
        return NAME;
    }
}

