/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.OSerializationThreadLocal;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerAnyStreamable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ORecordSerializerStringAbstract
implements ORecordSerializer,
Serializable {
    private static final char DECIMAL_SEPARATOR = '.';
    private static final String MAX_INTEGER_AS_STRING = String.valueOf(Integer.MAX_VALUE);
    private static final int MAX_INTEGER_DIGITS = MAX_INTEGER_AS_STRING.length();

    protected abstract StringBuilder toString(ORecordInternal<?> var1, StringBuilder var2, String var3, OUserObject2RecordHandler var4, Set<Integer> var5, boolean var6);

    public abstract ORecordInternal<?> fromString(String var1, ORecordInternal<?> var2);

    public StringBuilder toString(ORecordInternal<?> iRecord, String iFormat) {
        return this.toString(iRecord, new StringBuilder(), iFormat, ODatabaseRecordThreadLocal.INSTANCE.get(), (Set)OSerializationThreadLocal.INSTANCE.get(), false);
    }

    public StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat) {
        return this.toString(iRecord, iOutput, iFormat, null, (Set)OSerializationThreadLocal.INSTANCE.get(), false);
    }

    public ORecordInternal<?> fromString(String iSource) {
        return this.fromString(iSource, (ORecordInternal)ODatabaseRecordThreadLocal.INSTANCE.get().newInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ORecordInternal<?> fromStream(byte[] iSource, ORecordInternal<?> iRecord) {
        ORecordInternal<?> oRecordInternal;
        long timer = OProfiler.getInstance().startChrono();
        try {
            oRecordInternal = this.fromString(OBinaryProtocol.bytes2string(iSource), iRecord);
            Object var7_5 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.fromStream", timer);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.fromStream", timer);
            throw throwable;
        }
        return oRecordInternal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] toStream(ORecordInternal<?> iRecord, boolean iOnlyDelta) {
        byte[] byArray;
        long timer = OProfiler.getInstance().startChrono();
        try {
            byArray = OBinaryProtocol.string2bytes(this.toString(iRecord, new StringBuilder(), null, null, (Set)OSerializationThreadLocal.INSTANCE.get(), iOnlyDelta).toString());
            Object var7_5 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.toStream", timer);
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            OProfiler.getInstance().stopChrono("ORecordSerializerStringAbstract.toStream", timer);
            throw throwable;
        }
        return byArray;
    }

    public static Object fieldTypeFromStream(ODocument iDocument, OType iType, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iType == null) {
            iType = OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: 
            case INTEGER: 
            case BOOLEAN: 
            case FLOAT: 
            case DECIMAL: 
            case LONG: 
            case DOUBLE: 
            case SHORT: 
            case BYTE: 
            case BINARY: 
            case DATE: 
            case DATETIME: 
            case LINK: {
                return ORecordSerializerStringAbstract.simpleValueFromStream(iValue, iType);
            }
            case EMBEDDED: 
            case CUSTOM: {
                Object result = OStringSerializerAnyStreamable.INSTANCE.fromStream((String)iValue);
                if (result instanceof ODocument) {
                    ((ODocument)result).addOwner(iDocument);
                }
                return result;
            }
            case EMBEDDEDSET: 
            case EMBEDDEDLIST: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionFromStream(iDocument, iType, null, null, value);
            }
            case EMBEDDEDMAP: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapFromStream(iDocument, null, value);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
    }

    public static Object convertValue(String iValue, OType iExpectedType) {
        Object v = ORecordSerializerStringAbstract.getTypeValue(iValue);
        return OType.convert(v, iExpectedType.getDefaultJavaType());
    }

    public static void fieldTypeToString(StringBuilder iBuffer, OType iType, Object iValue) {
        if (iValue == null) {
            return;
        }
        long timer = OProfiler.getInstance().startChrono();
        if (iType == null) {
            iType = iValue instanceof ORID ? OType.LINK : OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.string2string", timer);
                break;
            }
            case BOOLEAN: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.bool2string", timer);
                break;
            }
            case INTEGER: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.int2string", timer);
                break;
            }
            case FLOAT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.float2string", timer);
                break;
            }
            case DECIMAL: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.decimal2string", timer);
                break;
            }
            case LONG: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.long2string", timer);
                break;
            }
            case DOUBLE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.double2string", timer);
                break;
            }
            case SHORT: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.short2string", timer);
                break;
            }
            case BYTE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.byte2string", timer);
                break;
            }
            case BINARY: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.binary2string", timer);
                break;
            }
            case DATE: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.date2string", timer);
                break;
            }
            case DATETIME: {
                ORecordSerializerStringAbstract.simpleValueToStream(iBuffer, iType, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.datetime2string", timer);
                break;
            }
            case LINK: {
                if (iValue instanceof ORecordId) {
                    ((ORecordId)iValue).toString(iBuffer);
                } else {
                    ((ORecord)iValue).getIdentity().toString(iBuffer);
                }
                OProfiler.getInstance().stopChrono("serializer.rec.str.link2string", timer);
                break;
            }
            case EMBEDDEDSET: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(ODatabaseRecordThreadLocal.INSTANCE.get(), null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedSet2string", timer);
                break;
            }
            case EMBEDDEDLIST: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedCollectionToStream(ODatabaseRecordThreadLocal.INSTANCE.get(), null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedList2string", timer);
                break;
            }
            case EMBEDDEDMAP: {
                ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapToStream(ODatabaseRecordThreadLocal.INSTANCE.get(), null, iBuffer, null, null, iValue, null, true);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embedMap2string", timer);
                break;
            }
            case EMBEDDED: 
            case CUSTOM: {
                OStringSerializerAnyStreamable.INSTANCE.toStream(iBuffer, iValue);
                OProfiler.getInstance().stopChrono("serializer.rec.str.embed2string", timer);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " not supported to convert value: " + iValue);
            }
        }
    }

    public static OType getType(String iValue) {
        int numberLength;
        if (iValue.length() == 0) {
            return null;
        }
        char firstChar = iValue.charAt(0);
        if (firstChar == '#') {
            return OType.LINK;
        }
        if (firstChar == '\'' || firstChar == '\"') {
            return OType.STRING;
        }
        if (firstChar == '_') {
            return OType.BINARY;
        }
        if (firstChar == '(') {
            return OType.EMBEDDED;
        }
        if (firstChar == '#') {
            return OType.LINK;
        }
        if (firstChar == '[') {
            return OType.EMBEDDEDLIST;
        }
        if (firstChar == '{') {
            return OType.EMBEDDEDMAP;
        }
        if (firstChar == '^') {
            return OType.CUSTOM;
        }
        if (iValue.equalsIgnoreCase("true") || iValue.equalsIgnoreCase("false")) {
            return OType.BOOLEAN;
        }
        boolean integer = true;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c >= '0' && c <= '9' || index == 0 && (c == '+' || c == '-')) continue;
            if (c == '.') {
                integer = false;
                continue;
            }
            if (index > 0) {
                if (!integer && c == 'E') {
                    if (index < iValue.length()) {
                        ++index;
                    }
                    if (iValue.charAt(index) == '-') {
                        continue;
                    }
                } else {
                    if (c == 'f') {
                        return OType.FLOAT;
                    }
                    if (c == 'c') {
                        return OType.DECIMAL;
                    }
                    if (c == 'l') {
                        return OType.LONG;
                    }
                    if (c == 'd') {
                        return OType.DOUBLE;
                    }
                    if (c == 'b') {
                        return OType.BYTE;
                    }
                    if (c == 'a') {
                        return OType.DATE;
                    }
                    if (c == 't') {
                        return OType.DATETIME;
                    }
                    if (c == 's') {
                        return OType.SHORT;
                    }
                }
            }
            return OType.STRING;
        }
        if (integer && ((numberLength = iValue.length()) > MAX_INTEGER_DIGITS || numberLength == MAX_INTEGER_DIGITS && iValue.compareTo(MAX_INTEGER_AS_STRING) > 0)) {
            return OType.LONG;
        }
        return integer ? OType.INTEGER : OType.FLOAT;
    }

    public static Object getTypeValue(String iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue.length() == 0) {
            return "";
        }
        if (iValue.length() > 1) {
            if (iValue.charAt(0) == '\"' && iValue.charAt(iValue.length() - 1) == '\"') {
                return OStringSerializerHelper.decode(iValue.substring(1, iValue.length() - 1));
            }
            if (iValue.charAt(0) == '_' && iValue.charAt(iValue.length() - 1) == '_') {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
        }
        if (iValue.charAt(0) == '#') {
            return new ORecordId(iValue);
        }
        boolean integer = true;
        for (int index = 0; index < iValue.length(); ++index) {
            char c = iValue.charAt(index);
            if (c >= '0' && c <= '9' || index == 0 && (c == '+' || c == '-')) continue;
            if (c == '.') {
                integer = false;
                continue;
            }
            if (index > 0) {
                if (!integer && c == 'E') {
                    if (index < iValue.length()) {
                        ++index;
                    }
                    if (iValue.charAt(index) == '-') continue;
                }
                String v = iValue.substring(0, index);
                if (c == 'f') {
                    return new Float(v);
                }
                if (c == 'c') {
                    return new BigDecimal(v);
                }
                if (c == 'l') {
                    return new Long(v);
                }
                if (c == 'd') {
                    return new Double(v);
                }
                if (c == 'b') {
                    return new Byte(v);
                }
                if (c == 'a' || c == 't') {
                    return new Date(Long.parseLong(v));
                }
                if (c == 's') {
                    return new Short(v);
                }
            }
            return iValue;
        }
        if (integer) {
            return new Integer(iValue);
        }
        return new Float(iValue);
    }

    public static Object simpleValueFromStream(Object iValue, OType iType) {
        switch (iType) {
            case STRING: {
                if (iValue instanceof String) {
                    String s = OStringSerializerHelper.getStringContent(iValue);
                    return OStringSerializerHelper.decode(s);
                }
                return iValue.toString();
            }
            case INTEGER: {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                return new Integer(iValue.toString());
            }
            case BOOLEAN: {
                if (iValue instanceof Boolean) {
                    return iValue;
                }
                return new Boolean(iValue.toString());
            }
            case FLOAT: {
                if (iValue instanceof Float) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case DECIMAL: {
                if (iValue instanceof BigDecimal) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LONG: {
                if (iValue instanceof Long) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case DOUBLE: {
                if (iValue instanceof Double) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case SHORT: {
                if (iValue instanceof Short) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BYTE: {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case BINARY: {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            case DATE: 
            case DATETIME: {
                if (iValue instanceof Date) {
                    return iValue;
                }
                return ORecordSerializerStringAbstract.convertValue((String)iValue, iType);
            }
            case LINK: {
                if (iValue instanceof ORID) {
                    return iValue.toString();
                }
                if (iValue instanceof String) {
                    return new ORecordId((String)iValue);
                }
                return ((ORecord)iValue).getIdentity().toString();
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " is not simple type.");
    }

    public static void simpleValueToStream(StringBuilder iBuffer, OType iType, Object iValue) {
        if (iValue == null || iType == null) {
            return;
        }
        switch (iType) {
            case STRING: {
                iBuffer.append('\"');
                iBuffer.append(OStringSerializerHelper.encode(iValue.toString()));
                iBuffer.append('\"');
                break;
            }
            case BOOLEAN: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case INTEGER: {
                iBuffer.append(String.valueOf(iValue));
                break;
            }
            case FLOAT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('f');
                break;
            }
            case DECIMAL: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('c');
                break;
            }
            case LONG: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('l');
                break;
            }
            case DOUBLE: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('d');
                break;
            }
            case SHORT: {
                iBuffer.append(String.valueOf(iValue));
                iBuffer.append('s');
                break;
            }
            case BYTE: {
                if (iValue instanceof Character) {
                    iBuffer.append((int)((Character)iValue).charValue());
                } else if (iValue instanceof String) {
                    iBuffer.append(String.valueOf((int)((String)iValue).charAt(0)));
                } else {
                    iBuffer.append(String.valueOf(iValue));
                }
                iBuffer.append('b');
                break;
            }
            case BINARY: {
                iBuffer.append('_');
                if (iValue instanceof Byte) {
                    iBuffer.append(OBase64Utils.encodeBytes(new byte[]{(Byte)iValue}));
                } else {
                    iBuffer.append(OBase64Utils.encodeBytes((byte[])iValue));
                }
                iBuffer.append('_');
                break;
            }
            case DATE: {
                if (iValue instanceof Date) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTime((Date)iValue);
                    calendar.set(11, 0);
                    calendar.set(12, 0);
                    calendar.set(13, 0);
                    calendar.set(14, 0);
                    iBuffer.append(calendar.getTimeInMillis());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('a');
                break;
            }
            case DATETIME: {
                if (iValue instanceof Date) {
                    iBuffer.append(((Date)iValue).getTime());
                } else {
                    iBuffer.append(iValue);
                }
                iBuffer.append('t');
            }
        }
    }
}

