/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.object;

import com.orientechnologies.orient.core.serialization.serializer.object.OObjectSerializer;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OObjectSerializerContext
implements OObjectSerializer<Object, Object> {
    private final Map<Class<?>, OObjectSerializer> localSerializers = new LinkedHashMap();
    private final Map<Class<?>, OObjectSerializer> dbSerializers = new LinkedHashMap();

    public void bind(OObjectSerializer serializer) {
        ParameterizedType pt;
        Type genericType = serializer.getClass().getGenericInterfaces()[0];
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 1) {
            Type[] actualTypes = pt.getActualTypeArguments();
            if (actualTypes[0] instanceof Class) {
                this.localSerializers.put((Class)actualTypes[0], serializer);
            } else if (actualTypes[0] instanceof ParameterizedType) {
                this.localSerializers.put((Class)((ParameterizedType)actualTypes[0]).getRawType(), serializer);
            }
            if (actualTypes[1] instanceof Class) {
                this.dbSerializers.put((Class)actualTypes[1], serializer);
            } else if (actualTypes[1] instanceof ParameterizedType) {
                this.dbSerializers.put((Class)((ParameterizedType)actualTypes[1]).getRawType(), serializer);
            }
        }
    }

    public void unbind(OObjectSerializer serializer) {
        ParameterizedType pt;
        Type genericType = serializer.getClass().getGenericInterfaces()[0];
        if (genericType != null && genericType instanceof ParameterizedType && (pt = (ParameterizedType)genericType).getActualTypeArguments() != null && pt.getActualTypeArguments().length > 1) {
            Type[] actualTypes = pt.getActualTypeArguments();
            if (actualTypes[0] instanceof Class) {
                this.localSerializers.remove((Class)actualTypes[0]);
            } else if (actualTypes[0] instanceof ParameterizedType) {
                this.localSerializers.remove((Class)((ParameterizedType)actualTypes[0]).getRawType());
            }
            if (actualTypes[1] instanceof Class) {
                this.dbSerializers.remove((Class)actualTypes[1]);
            } else if (actualTypes[1] instanceof ParameterizedType) {
                this.dbSerializers.remove((Class)((ParameterizedType)actualTypes[1]).getRawType());
            }
        }
    }

    @Override
    public Object serializeFieldValue(Object iPojo, String iFieldName, Object iFieldValue) {
        for (Class<?> type : this.localSerializers.keySet()) {
            if (!type.isInstance(iFieldValue) && (iFieldValue != null || type != Void.class)) continue;
            iFieldValue = this.localSerializers.get(type).serializeFieldValue(iPojo, iFieldName, iFieldValue);
            break;
        }
        return iFieldValue;
    }

    @Override
    public Object unserializeFieldValue(Object iPojo, String iFieldName, Object iFieldValue) {
        for (Class<?> type : this.dbSerializers.keySet()) {
            if (!type.isInstance(iFieldValue) && (iFieldValue != null || type != Void.class)) continue;
            iFieldValue = this.dbSerializers.get(type).unserializeFieldValue(iPojo, iFieldName, iFieldValue);
            break;
        }
        return iFieldValue;
    }
}

