/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerSchemaAware2CSV;
import com.orientechnologies.orient.core.serialization.serializer.string.OStringSerializerAnyStreamable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OStringSerializerHelper {
    public static final char RECORD_SEPARATOR = ',';
    public static final String CLASS_SEPARATOR = "@";
    public static final char LINK = '#';
    public static final char EMBEDDED_BEGIN = '(';
    public static final char EMBEDDED_END = ')';
    public static final char COLLECTION_BEGIN = '[';
    public static final char COLLECTION_END = ']';
    public static final char MAP_BEGIN = '{';
    public static final char MAP_END = '}';
    public static final char BINARY_BEGINEND = '_';
    public static final char CUSTOM_TYPE = '^';
    public static final char ENTRY_SEPARATOR = ':';
    public static final char PARAMETER_NAMED = ':';
    public static final char PARAMETER_POSITIONAL = '?';
    public static final char[] PARAMETER_SEPARATOR = new char[]{',', ')'};
    public static final char[] PARAMETER_EXT_SEPARATOR = new char[]{' ', '.'};
    public static final char COLLECTION_SEPARATOR = ',';
    public static final List<String> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    public static final Map<String, String> EMPTY_MAP = Collections.unmodifiableMap(new HashMap());

    public static Object fieldTypeFromStream(ODocument iDocument, OType iType, Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iType == null) {
            iType = OType.EMBEDDED;
        }
        switch (iType) {
            case STRING: {
                if (iValue instanceof String) {
                    String s = (String)iValue;
                    return OStringSerializerHelper.decode(s.substring(1, s.length() - 1));
                }
                return iValue.toString();
            }
            case INTEGER: {
                if (iValue instanceof Integer) {
                    return iValue;
                }
                return new Integer(OStringSerializerHelper.getStringContent(iValue));
            }
            case BOOLEAN: {
                if (iValue instanceof Boolean) {
                    return iValue;
                }
                return new Boolean(OStringSerializerHelper.getStringContent(iValue));
            }
            case FLOAT: {
                if (iValue instanceof Float) {
                    return iValue;
                }
                return new Float(OStringSerializerHelper.getStringContent(iValue));
            }
            case LONG: {
                if (iValue instanceof Long) {
                    return iValue;
                }
                return new Long(OStringSerializerHelper.getStringContent(iValue));
            }
            case DOUBLE: {
                if (iValue instanceof Double) {
                    return iValue;
                }
                return new Double(OStringSerializerHelper.getStringContent(iValue));
            }
            case SHORT: {
                if (iValue instanceof Short) {
                    return iValue;
                }
                return new Short(OStringSerializerHelper.getStringContent(iValue));
            }
            case BYTE: {
                if (iValue instanceof Byte) {
                    return iValue;
                }
                return new Byte(OStringSerializerHelper.getStringContent(iValue));
            }
            case BINARY: {
                return OStringSerializerHelper.getBinaryContent(iValue);
            }
            case DATE: 
            case DATETIME: {
                if (iValue instanceof Date) {
                    return iValue;
                }
                return new Date(Long.parseLong(OStringSerializerHelper.getStringContent(iValue)));
            }
            case LINK: {
                if (iValue instanceof ORID) {
                    return iValue.toString();
                }
                if (iValue instanceof String) {
                    return new ORecordId((String)iValue);
                }
                return ((ORecord)iValue).getIdentity().toString();
            }
            case EMBEDDED: {
                return OStringSerializerAnyStreamable.INSTANCE.fromStream((String)iValue);
            }
            case EMBEDDEDMAP: {
                String value = (String)iValue;
                return ORecordSerializerSchemaAware2CSV.INSTANCE.embeddedMapFromStream(iDocument, null, value);
            }
        }
        throw new IllegalArgumentException("Type " + (Object)((Object)iType) + " does not support converting value: " + iValue);
    }

    public static List<String> smartSplit(String iSource, char iRecordSeparator, char ... iJumpChars) {
        return OStringSerializerHelper.smartSplit(iSource, new char[]{iRecordSeparator}, 0, -1, false, iJumpChars);
    }

    public static List<String> smartSplit(String iSource, char[] iRecordSeparator, int beginIndex, int endIndex, boolean iStringSeparatorExtended, char ... iJumpChars) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> parts = new ArrayList<String>();
        while ((beginIndex = OStringSerializerHelper.parse(iSource, buffer, beginIndex, endIndex, iRecordSeparator, iStringSeparatorExtended, iJumpChars)) > -1) {
            parts.add(buffer.toString());
            buffer.setLength(0);
        }
        if (buffer.length() > 0) {
            parts.add(buffer.toString());
        }
        return parts;
    }

    public static int parse(String iSource, StringBuilder iBuffer, int beginIndex, int endIndex, char[] iRecordSeparator, boolean iStringSeparatorExtended, char ... iJumpChars) {
        char stringBeginChar = ' ';
        boolean encodeMode = false;
        int insideParenthesis = 0;
        int insideCollection = 0;
        int insideMap = 0;
        int insideLinkPart = 0;
        int max = endIndex > -1 ? endIndex + 1 : iSource.length();
        char[] buffer = new char[max - beginIndex];
        iSource.getChars(beginIndex, max, buffer, 0);
        for (int i = 0; i < buffer.length; ++i) {
            char c = buffer[i];
            if (stringBeginChar == ' ') {
                if (c == '[') {
                    ++insideCollection;
                } else if (c == ']') {
                    if (!OStringSerializerHelper.isCharPresent(c, iRecordSeparator)) {
                        if (insideCollection == 0) {
                            throw new OSerializationException("Found invalid ] character. Ensure it is opened and closed correctly.");
                        }
                        --insideCollection;
                    }
                } else if (c == '(') {
                    ++insideParenthesis;
                } else if (c == ')') {
                    if (!OStringSerializerHelper.isCharPresent(c, iRecordSeparator)) {
                        if (insideParenthesis == 0) {
                            throw new OSerializationException("Found invalid ) character. Ensure it is opened and closed correctly.");
                        }
                        --insideParenthesis;
                    }
                } else if (c == '{') {
                    ++insideMap;
                } else if (c == '}') {
                    if (!OStringSerializerHelper.isCharPresent(c, iRecordSeparator)) {
                        if (insideMap == 0) {
                            throw new OSerializationException("Found invalid } character. Ensure it is opened and closed correctly.");
                        }
                        --insideMap;
                    }
                } else if (c == '#') {
                    insideLinkPart = 1;
                } else if (insideLinkPart == 1 && c == ':') {
                    insideLinkPart = 2;
                }
                if (insideLinkPart > 0 && c != '-' && !Character.isDigit(c) && c != ':' && c != '#') {
                    insideLinkPart = 0;
                }
                if ((c == '\"' || iStringSeparatorExtended && c == '\'') && !encodeMode) {
                    stringBeginChar = c;
                }
                if (insideParenthesis == 0 && insideCollection == 0 && insideMap == 0 && insideLinkPart == 0 && OStringSerializerHelper.isCharPresent(c, iRecordSeparator)) {
                    return beginIndex + i + 1;
                }
                if (iJumpChars.length > 0 && OStringSerializerHelper.isCharPresent(c, iJumpChars)) {
                    continue;
                }
            } else if ((c == '\"' || iStringSeparatorExtended && c == '\'') && !encodeMode && stringBeginChar == c) {
                stringBeginChar = ' ';
            }
            if (c == '\\' && !encodeMode) {
                char nextChar = buffer[i + 1];
                if (nextChar == 'u') {
                    i = OStringParser.readUnicode(buffer, i + 2, iBuffer);
                    continue;
                }
                if (nextChar == 'n') {
                    iBuffer.append("\n");
                    ++i;
                    continue;
                }
                if (nextChar == 'r') {
                    iBuffer.append("\r");
                    ++i;
                    continue;
                }
                if (nextChar == 't') {
                    iBuffer.append("\t");
                    ++i;
                    continue;
                }
                if (nextChar == 'f') {
                    iBuffer.append("\f");
                    ++i;
                    continue;
                }
                encodeMode = true;
            } else {
                encodeMode = false;
            }
            if (c != '\\' && encodeMode) {
                encodeMode = false;
            }
            iBuffer.append(c);
        }
        return -1;
    }

    public static boolean isCharPresent(char iCharacter, char[] iCharacters) {
        int len = iCharacters.length;
        for (int i = 0; i < len; ++i) {
            if (iCharacter != iCharacters[i]) continue;
            return true;
        }
        return false;
    }

    public static List<String> split(String iSource, char iRecordSeparator, char ... iJumpCharacters) {
        return OStringSerializerHelper.split(iSource, 0, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static Collection<String> split(Collection<String> iParts, String iSource, char iRecordSeparator, char ... iJumpCharacters) {
        return OStringSerializerHelper.split(iParts, iSource, 0, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static List<String> split(String iSource, int iStartPosition, int iEndPosition, char iRecordSeparator, char ... iJumpCharacters) {
        return (List)OStringSerializerHelper.split(new ArrayList<String>(), iSource, iStartPosition, iSource.length(), iRecordSeparator, iJumpCharacters);
    }

    public static Collection<String> split(Collection<String> iParts, String iSource, int iStartPosition, int iEndPosition, char iRecordSeparator, char ... iJumpCharacters) {
        StringBuilder buffer = new StringBuilder();
        for (int i = iStartPosition; i < iEndPosition; ++i) {
            char c = iSource.charAt(i);
            if (c == iRecordSeparator) {
                iParts.add(buffer.toString());
                buffer.setLength(0);
                continue;
            }
            if (iJumpCharacters.length > 0 && buffer.length() == 0) {
                if (OStringSerializerHelper.isCharPresent(c, iJumpCharacters)) continue;
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        if (iJumpCharacters.length > 0 && buffer.length() > 0) {
            int newSize = 0;
            for (int i = buffer.length() - 1; i >= 0; --i) {
                char b = buffer.charAt(i);
                boolean found = false;
                for (char j : iJumpCharacters) {
                    if (j != b) continue;
                    found = true;
                    ++newSize;
                    break;
                }
                if (!found) break;
            }
            if (newSize > 0) {
                buffer.setLength(buffer.length() - newSize);
            }
        }
        iParts.add(buffer.toString());
        return iParts;
    }

    public static String joinIntArray(int[] iArray) {
        StringBuilder ids = new StringBuilder();
        for (int id : iArray) {
            if (ids.length() > 0) {
                ids.append(',');
            }
            ids.append(id);
        }
        return ids.toString();
    }

    public static int[] splitIntArray(String iInput) {
        List<String> items = OStringSerializerHelper.split(iInput, ',', new char[0]);
        int[] values = new int[items.size()];
        for (int i = 0; i < items.size(); ++i) {
            values[i] = Integer.parseInt(items.get(i));
        }
        return values;
    }

    public static boolean contains(String iText, char iSeparator) {
        if (iText == null) {
            return false;
        }
        int max = iText.length();
        for (int i = 0; i < max; ++i) {
            if (iText.charAt(i) != iSeparator) continue;
            return true;
        }
        return false;
    }

    public static int getCollection(String iText, int iStartPosition, Collection<String> iCollection) {
        StringBuilder buffer = new StringBuilder();
        int openPos = iText.indexOf(91, iStartPosition);
        if (openPos == -1) {
            return -1;
        }
        int currentPos = openPos + 1;
        int deep = 1;
        while (deep > 0) {
            if (currentPos >= iText.length()) {
                return -1;
            }
            char c = iText.charAt(currentPos);
            if (buffer.length() != 0 || c != ' ') {
                switch (c) {
                    case '[': {
                        buffer.append(c);
                        ++deep;
                        break;
                    }
                    case ']': {
                        if (deep > 1) {
                            buffer.append(c);
                        }
                        --deep;
                        break;
                    }
                    case ',': {
                        if (deep > 1) {
                            buffer.append(c);
                            break;
                        }
                        iCollection.add(buffer.toString().trim());
                        buffer.setLength(0);
                        break;
                    }
                    default: {
                        buffer.append(c);
                    }
                }
            }
            ++currentPos;
        }
        iCollection.add(buffer.toString().trim());
        return --currentPos;
    }

    public static int getParameters(String iText, int iBeginPosition, int iEndPosition, List<String> iParameters) {
        iParameters.clear();
        int openPos = iText.indexOf(40, iBeginPosition);
        if (openPos == -1 || iEndPosition > -1 && openPos > iEndPosition) {
            return iBeginPosition;
        }
        StringBuilder buffer = new StringBuilder();
        OStringSerializerHelper.parse(iText, buffer, openPos, iEndPosition, PARAMETER_EXT_SEPARATOR, true, new char[0]);
        if (buffer.length() == 0) {
            return iBeginPosition;
        }
        String t = buffer.substring(1, buffer.length() - 1);
        List<String> pars = OStringSerializerHelper.smartSplit(t, PARAMETER_SEPARATOR, 0, -1, true, new char[0]);
        for (int i = 0; i < pars.size(); ++i) {
            iParameters.add(pars.get(i).trim());
        }
        return iBeginPosition + buffer.length();
    }

    public static int getEmbedded(String iText, int iBeginPosition, int iEndPosition, StringBuilder iEmbedded) {
        int openPos = iText.indexOf(40, iBeginPosition);
        if (openPos == -1 || iEndPosition > -1 && openPos > iEndPosition) {
            return iBeginPosition;
        }
        StringBuilder buffer = new StringBuilder();
        OStringSerializerHelper.parse(iText, buffer, openPos, iEndPosition, PARAMETER_EXT_SEPARATOR, true, new char[0]);
        if (buffer.length() == 0) {
            return iBeginPosition;
        }
        String t = buffer.substring(1, buffer.length() - 1).trim();
        iEmbedded.append(t);
        return iBeginPosition + buffer.length();
    }

    public static List<String> getParameters(String iText) {
        ArrayList<String> params = new ArrayList<String>();
        OStringSerializerHelper.getParameters(iText, 0, -1, params);
        return params;
    }

    public static Map<String, String> getMap(String iText) {
        int openPos = iText.indexOf(123);
        if (openPos == -1) {
            return EMPTY_MAP;
        }
        int closePos = iText.indexOf(125, openPos + 1);
        if (closePos == -1) {
            return EMPTY_MAP;
        }
        List<String> entries = OStringSerializerHelper.smartSplit(iText.substring(openPos + 1, closePos), ',', new char[0]);
        if (entries.size() == 0) {
            return EMPTY_MAP;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : entries) {
            if (item == null || item.isEmpty()) continue;
            List<String> entry = OStringSerializerHelper.split(item, ':', new char[0]);
            map.put((String)OStringSerializerHelper.fieldTypeFromStream(null, OType.STRING, entry.get(0)), entry.get(1));
        }
        return map;
    }

    public static String encode(String iText) {
        char c;
        int pos = -1;
        int newSize = iText.length();
        for (int i = 0; i < newSize; ++i) {
            c = iText.charAt(i);
            if (c != '\"' && c != '\\') continue;
            pos = i;
            break;
        }
        if (pos > -1) {
            StringBuilder iOutput = new StringBuilder();
            for (int i = 0; i < iText.length(); ++i) {
                c = iText.charAt(i);
                if (c == '\"' || c == '\\') {
                    iOutput.append('\\');
                }
                iOutput.append(c);
            }
            return iOutput.toString();
        }
        return iText;
    }

    public static String decode(String iText) {
        int pos = -1;
        for (int i = 0; i < iText.length(); ++i) {
            if (iText.charAt(i) != '\"' && iText.charAt(i) != '\\') continue;
            pos = i;
            break;
        }
        if (pos == -1) {
            return iText;
        }
        StringBuilder buffer = new StringBuilder(iText);
        for (int i = pos; i < buffer.length(); ++i) {
            char c = buffer.charAt(i);
            if (c != '\\') continue;
            buffer.deleteCharAt(i);
        }
        return buffer.toString();
    }

    public static OClass getRecordClassName(String iValue, OClass iLinkedClass) {
        int classSeparatorPos = iValue.indexOf(CLASS_SEPARATOR);
        if (classSeparatorPos > -1) {
            String className = iValue.substring(0, classSeparatorPos);
            ODatabaseRecord database = ODatabaseRecordThreadLocal.INSTANCE.get();
            if (className != null && database != null) {
                iLinkedClass = database.getMetadata().getSchema().getClass(className);
            }
            iValue = iValue.substring(classSeparatorPos + 1);
        }
        return iLinkedClass;
    }

    public static String java2unicode(String iInput) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < iInput.length(); ++i) {
            char ch = iInput.charAt(i);
            if (ch >= ' ' && ch <= '~') {
                result.append(ch);
                continue;
            }
            result.append("\\u");
            String hex = Integer.toHexString(iInput.charAt(i) & 0xFFFF);
            for (int j = 0; j < 4 - hex.length(); ++j) {
                result.append('0');
            }
            result.append(hex.toLowerCase());
        }
        return result.toString();
    }

    public static String getStringContent(Object iValue) {
        if (iValue == null) {
            return null;
        }
        String s = iValue.toString();
        if (s == null) {
            return null;
        }
        if (s.length() > 1 && (s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'' || s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    public static byte[] getBinaryContent(Object iValue) {
        if (iValue == null) {
            return null;
        }
        if (iValue instanceof byte[]) {
            return (byte[])iValue;
        }
        if (iValue instanceof String) {
            String s = (String)iValue;
            if (!(s.length() > 1 && s.charAt(0) == '_' && s.charAt(s.length() - 1) == '_' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'')) {
                throw new IllegalArgumentException("Not binary type: " + iValue);
            }
            s = s.substring(1, s.length() - 1);
            return OBase64Utils.decode(s);
        }
        throw new IllegalArgumentException("Cannot parse binary as the same type as the value (class=" + iValue.getClass().getName() + "): " + iValue);
    }

    public static boolean isAlphanumeric(String iContent) {
        int tot = iContent.length();
        for (int i = 0; i < tot; ++i) {
            if (Character.isLetterOrDigit(iContent.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String removeQuotationMarks(String iValue) {
        if (iValue != null && iValue.length() > 1 && (iValue.charAt(0) == '\'' && iValue.charAt(iValue.length() - 1) == '\'' || iValue.charAt(0) == '\"' && iValue.charAt(iValue.length() - 1) == '\"')) {
            return iValue.substring(1, iValue.length() - 1);
        }
        return iValue;
    }

    public static boolean startsWithIgnoreCase(String iFirst, String iSecond) {
        if (iFirst == null) {
            throw new IllegalArgumentException("Origin string to compare is null");
        }
        if (iSecond == null) {
            throw new IllegalArgumentException("String to match is null");
        }
        int iSecondLength = iSecond.length();
        if (iSecondLength > iFirst.length()) {
            return false;
        }
        for (int i = 0; i < iSecondLength; ++i) {
            if (Character.toUpperCase(iFirst.charAt(i)) == Character.toUpperCase(iSecond.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static int indexOf(String iSource, int iBegin, char ... iChars) {
        if (iChars.length == 1) {
            return iSource.indexOf(iChars[0], iBegin);
        }
        int len = iSource.length();
        for (int i = iBegin; i < len; ++i) {
            for (int k = 0; k < iChars.length; ++k) {
                char c = iSource.charAt(i);
                if (c != iChars[k]) continue;
                return i;
            }
        }
        return -1;
    }
}

