/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer;

import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.serialization.OBase64Utils;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;

public class OJSONWriter {
    private static final String DEF_FORMAT = "rid,type,version,class,attribSameRow,indent:6";
    private Writer out;
    private boolean prettyPrint = true;
    private boolean firstAttribute = true;
    private final String format;

    public OJSONWriter(Writer out, String iJsonFormat) {
        this.out = out;
        this.format = iJsonFormat;
    }

    public OJSONWriter(Writer out) {
        this.out = out;
        this.format = DEF_FORMAT;
    }

    public OJSONWriter beginObject() throws IOException {
        this.beginObject(0, false, null);
        return this;
    }

    public OJSONWriter beginObject(int iIdentLevel) throws IOException {
        this.beginObject(iIdentLevel, false, null);
        return this;
    }

    public OJSONWriter beginObject(Object iName) throws IOException {
        this.beginObject(0, false, iName);
        return this;
    }

    public OJSONWriter beginObject(int iIdentLevel, boolean iNewLine, Object iName) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(", ");
        }
        this.format(iIdentLevel, iNewLine);
        if (iName != null) {
            this.out.append("\"" + iName.toString() + "\":");
        }
        this.out.append('{');
        this.firstAttribute = true;
        return this;
    }

    public OJSONWriter endObject() throws IOException {
        this.format(0, true);
        this.out.append('}');
        return this;
    }

    public OJSONWriter endObject(int iIdentLevel) throws IOException {
        return this.endObject(iIdentLevel, true);
    }

    public OJSONWriter endObject(int iIdentLevel, boolean iNewLine) throws IOException {
        this.format(iIdentLevel, iNewLine);
        this.out.append('}');
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter beginCollection(int iIdentLevel, boolean iNewLine, String iName) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(", ");
        }
        this.format(iIdentLevel, iNewLine);
        this.out.append(OJSONWriter.writeValue(iName));
        this.out.append(": [");
        this.firstAttribute = true;
        return this;
    }

    public OJSONWriter endCollection(int iIdentLevel, boolean iNewLine) throws IOException {
        this.format(iIdentLevel, iNewLine);
        this.firstAttribute = false;
        this.out.append(']');
        return this;
    }

    public void writeObjects(int iIdentLevel, boolean iNewLine, String iName, Object[] ... iPairs) throws IOException {
        for (int i = 0; i < iPairs.length; ++i) {
            this.beginObject(iIdentLevel, true, iName);
            int k = 0;
            while (k < iPairs[i].length) {
                this.writeAttribute(iIdentLevel + 1, false, (String)iPairs[i][k++], iPairs[i][k++], this.format);
            }
            this.endObject(iIdentLevel, false);
        }
    }

    public OJSONWriter writeAttribute(int iIdentLevel, boolean iNewLine, String iName, Object iValue) throws IOException {
        return this.writeAttribute(iIdentLevel, iNewLine, iName, iValue, this.format);
    }

    public OJSONWriter writeAttribute(int iIdentLevel, boolean iNewLine, String iName, Object iValue, String iFormat) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(", ");
        }
        this.format(iIdentLevel, iNewLine);
        this.out.append(OJSONWriter.writeValue(iName, iFormat));
        this.out.append(": ");
        this.out.append(OJSONWriter.writeValue(iValue, iFormat));
        this.firstAttribute = false;
        return this;
    }

    public OJSONWriter writeValue(int iIdentLevel, boolean iNewLine, Object iValue) throws IOException {
        if (!this.firstAttribute) {
            this.out.append(", ");
        }
        this.format(iIdentLevel, iNewLine);
        this.out.append(OJSONWriter.writeValue(iValue, this.format));
        this.firstAttribute = false;
        return this;
    }

    public static String writeValue(Object iValue) throws IOException {
        return OJSONWriter.writeValue(iValue, DEF_FORMAT);
    }

    public static String writeValue(Object iValue, String iFormat) throws IOException {
        boolean oldAutoConvertSettings;
        StringBuilder buffer = new StringBuilder();
        if (iValue instanceof ORecordLazyMultiValue) {
            oldAutoConvertSettings = ((ORecordLazyMultiValue)iValue).isAutoConvertToRecord();
            ((ORecordLazyMultiValue)iValue).setAutoConvertToRecord(false);
        } else {
            oldAutoConvertSettings = false;
        }
        if (iValue == null) {
            buffer.append("null");
        } else if (iValue instanceof ORecordId) {
            ORecordId rid = (ORecordId)iValue;
            buffer.append('\"');
            rid.toString(buffer);
            buffer.append('\"');
        } else if (iValue instanceof ORecord) {
            ORecord linked = (ORecord)iValue;
            if (linked.getIdentity().isValid()) {
                buffer.append('\"');
                linked.getIdentity().toString(buffer);
                buffer.append('\"');
            } else {
                buffer.append(linked.toJSON(iFormat));
            }
        } else if (iValue.getClass().isArray()) {
            if (iValue instanceof byte[]) {
                buffer.append('\"');
                byte[] source = (byte[])iValue;
                buffer.append(OBase64Utils.encodeBytes(source));
                buffer.append('\"');
            } else {
                buffer.append('[');
                for (int i = 0; i < Array.getLength(iValue); ++i) {
                    if (i > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(OJSONWriter.writeValue(Array.get(iValue, i), iFormat));
                }
                buffer.append(']');
            }
        } else if (iValue instanceof Collection) {
            Collection coll = (Collection)iValue;
            buffer.append('[');
            int i = 0;
            Iterator it = coll.iterator();
            while (it.hasNext()) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(OJSONWriter.writeValue(it.next(), iFormat));
                ++i;
            }
            buffer.append(']');
        } else if (iValue instanceof Map) {
            Map map = (Map)iValue;
            buffer.append('{');
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(OJSONWriter.writeValue(entry.getKey(), iFormat));
                buffer.append(": ");
                buffer.append(OJSONWriter.writeValue(entry.getValue(), iFormat));
                ++i;
            }
            buffer.append('}');
        } else if (iValue instanceof Date) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            buffer.append('\"');
            buffer.append(dateFormat.format(iValue));
            buffer.append('\"');
        } else if (iValue instanceof String) {
            String v = (String)iValue;
            if (v.startsWith("\"")) {
                buffer.append(v);
            } else {
                buffer.append('\"');
                buffer.append(v);
                buffer.append('\"');
            }
        } else {
            buffer.append(iValue.toString());
        }
        if (iValue instanceof ORecordLazyMultiValue) {
            ((ORecordLazyMultiValue)iValue).setAutoConvertToRecord(oldAutoConvertSettings);
        }
        return buffer.toString();
    }

    public OJSONWriter flush() throws IOException {
        this.out.flush();
        return this;
    }

    public OJSONWriter close() throws IOException {
        this.out.close();
        return this;
    }

    private OJSONWriter format(int iIdentLevel, boolean iNewLine) throws IOException {
        if (iNewLine) {
            this.out.append('\n');
            if (this.prettyPrint) {
                for (int i = 0; i < iIdentLevel; ++i) {
                    this.out.append("  ");
                }
            }
        }
        return this;
    }

    public OJSONWriter append(String iText) throws IOException {
        this.out.append(iText);
        return this;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public OJSONWriter setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
        return this;
    }

    public void write(String iText) throws IOException {
        this.out.append(iText);
    }

    public static Object encode(Object iValue) {
        if (iValue instanceof String) {
            return OStringSerializerHelper.java2unicode(((String)iValue).replace("\\", "\\\\").replace("\"", "\\\""));
        }
        return iValue;
    }
}

