/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.security;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class OSecurityManager {
    public static final String ALGORITHM = "SHA-256";
    public static final String ALGORITHM_PREFIX = "{SHA-256}";
    private static final OSecurityManager instance = new OSecurityManager();
    private MessageDigest md;

    public OSecurityManager() {
        try {
            this.md = MessageDigest.getInstance(ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            OLogManager.instance().error((Object)this, "Cannot use OSecurityManager", (Throwable)e, new Object[0]);
        }
    }

    public boolean check(byte[] iInput1, byte[] iInput2) {
        return MessageDigest.isEqual(iInput1, iInput2);
    }

    public boolean check(String iInput1, byte[] iInput2) {
        return MessageDigest.isEqual(this.digest(iInput1), iInput2);
    }

    public boolean check(String iInput1, String iInput2) {
        String s = iInput2.startsWith(ALGORITHM_PREFIX) ? iInput2.substring(ALGORITHM_PREFIX.length()) : iInput2;
        return this.digest2String(iInput1, false).equals(s);
    }

    public String digest2String(String iInput) {
        return OSecurityManager.byteArrayToHexStr(this.digest(iInput));
    }

    public String digest2String(String iInput, boolean iIncludeAlgorithm) {
        StringBuilder buffer = new StringBuilder();
        if (iIncludeAlgorithm) {
            buffer.append(ALGORITHM_PREFIX);
        }
        buffer.append(OSecurityManager.instance().digest2String(iInput));
        return buffer.toString();
    }

    public synchronized byte[] digest(String iInput) {
        if (iInput == null) {
            return null;
        }
        try {
            return this.md.digest(iInput.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            OLogManager.instance().error((Object)this, "The requested encoding is not supported: cannot execute security checks", (Throwable)e, OConfigurationException.class, new Object[0]);
            return null;
        }
    }

    public synchronized byte[] digest(byte[] iInput) {
        return this.md.digest(iInput);
    }

    public SecretKey generateKey(String iAlgorithm, int iKeySize) {
        try {
            KeyGenerator kg = KeyGenerator.getInstance(iAlgorithm);
            kg.init(iKeySize);
            return kg.generateKey();
        }
        catch (Exception e) {
            throw new OSecurityException("Error on generating key for algorithm: " + iAlgorithm, e);
        }
    }

    public SecretKey createKey(String iAlgorithm, byte[] iKey) throws OSecurityAccessException {
        return new SecretKeySpec(iKey, iAlgorithm);
    }

    public byte[] encrypt(String iAlgorithm, Key iKey, byte[] iData) throws OSecurityAccessException {
        try {
            Cipher c = Cipher.getInstance(iAlgorithm);
            c.init(1, iKey);
            return c.doFinal(iData);
        }
        catch (Exception e) {
            throw new OSecurityException("Error on encrypting data", e);
        }
    }

    public byte[] decrypt(String iAlgorithm, Key iKey, byte[] iData) throws OSecurityAccessException {
        try {
            Cipher c = Cipher.getInstance(iAlgorithm);
            c.init(2, iKey);
            return c.doFinal(iData);
        }
        catch (Exception e) {
            throw new OSecurityException("Error on decrypting data", e);
        }
    }

    public static OSecurityManager instance() {
        return instance;
    }

    private static String byteArrayToHexStr(byte[] data) {
        if (data == null) {
            return null;
        }
        char[] chars = new char[data.length * 2];
        for (int i = 0; i < data.length; ++i) {
            byte current = data[i];
            int hi = (current & 0xF0) >> 4;
            int lo = current & 0xF;
            chars[2 * i] = (char)(hi < 10 ? 48 + hi : 65 + hi - 10);
            chars[2 * i + 1] = (char)(lo < 10 ? 48 + lo : 65 + lo - 10);
        }
        return new String(chars);
    }
}

