/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.record.impl;

import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.record.ORecordAbstract;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordBytes
extends ORecordAbstract<byte[]> {
    public static final byte RECORD_TYPE = 98;

    public ORecordBytes() {
        this.setup();
    }

    public ORecordBytes(ODatabaseRecord iDatabase) {
        this.setup();
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(ODatabaseRecord iDatabase, byte[] iSource) {
        this(iSource);
        ODatabaseRecordThreadLocal.INSTANCE.set(iDatabase);
    }

    public ORecordBytes(byte[] iSource) {
        super(iSource);
        this._dirty = true;
        this.setup();
    }

    public ORecordBytes(ORID iRecordId) {
        this._recordId = (ORecordId)iRecordId;
        this.setup();
    }

    public ORecordBytes reset(byte[] iSource) {
        this.reset();
        this._source = iSource;
        return this;
    }

    @Override
    public ORecordBytes copy() {
        return (ORecordBytes)this.copyTo(new ORecordBytes());
    }

    @Override
    public ORecordBytes fromStream(byte[] iRecordBuffer) {
        this._source = iRecordBuffer;
        this._status = ORecordElement.STATUS.LOADED;
        return this;
    }

    @Override
    public byte[] toStream() {
        return this._source;
    }

    @Override
    public byte getRecordType() {
        return 98;
    }

    @Override
    protected void setup() {
        super.setup();
        this._recordFormat = ORecordSerializerFactory.instance().getFormat("ORecordDocumentRaw");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int fromInputStream(InputStream in) throws IOException {
        OMemoryStream out = new OMemoryStream();
        try {
            while (in.available() > 0) {
                out.write(in.read());
            }
            out.flush();
            this._source = out.toByteArray();
            Object var4_3 = null;
            out.close();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            out.close();
            throw throwable;
        }
        this._size = this._source.length;
        return this._size;
    }

    public int fromInputStream(InputStream in, int iMaxSize) throws IOException {
        int bufferSize = Math.min(in.available(), iMaxSize);
        this._source = new byte[bufferSize];
        in.read(this._source);
        this._size = bufferSize;
        return this._size;
    }

    public void toOutputStream(OutputStream out) throws IOException {
        this.checkForLoading();
        if (this._source.length > 0) {
            ByteArrayInputStream in = new ByteArrayInputStream(this._source);
            while (in.available() > 0) {
                out.write(in.read());
            }
        }
    }
}

