/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.util.OCaseIncentiveComparator;
import com.orientechnologies.common.util.OCollections;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPropertyImpl
extends ODocumentWrapperNoClass
implements OProperty {
    private OClassImpl owner;
    private String name;
    private OType type;
    private OType linkedType;
    private OClass linkedClass;
    private transient String linkedClassName;
    private boolean mandatory;
    private boolean notNull = false;
    private String min;
    private String max;
    private String regexp;

    public OPropertyImpl() {
    }

    public OPropertyImpl(OClassImpl iOwner, String iName, OType iType) {
        this(iOwner);
        this.name = iName;
        this.type = iType;
    }

    public OPropertyImpl(OClassImpl iOwner) {
        this.document = new ODocument();
        this.owner = iOwner;
    }

    public OPropertyImpl(OClassImpl iOwner, ODocument iDocument) {
        this(iOwner);
        this.document = iDocument;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.owner.getName() + "." + this.name;
    }

    @Override
    public OType getType() {
        return this.type;
    }

    @Override
    public int compareTo(OProperty o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public OIndex<?> createIndex(OClass.INDEX_TYPE iType) {
        return this.owner.createIndex(this.getFullName(), iType, this.name);
    }

    @Override
    @Deprecated
    public OPropertyImpl dropIndexes() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        ArrayList relatedIndexes = new ArrayList();
        for (OIndex<?> oIndex : indexManager.getClassIndexes(this.owner.getName())) {
            OIndexDefinition definition = oIndex.getDefinition();
            if (OCollections.indexOf(definition.getFields(), this.name, new OCaseIncentiveComparator()) <= -1) continue;
            if (definition instanceof OPropertyIndexDefinition) {
                relatedIndexes.add(oIndex);
                continue;
            }
            throw new IllegalArgumentException("This operation applicable only for property indexes. " + oIndex.getName() + " is " + oIndex.getDefinition());
        }
        for (OIndex<Object> oIndex : relatedIndexes) {
            this.getDatabase().getMetadata().getIndexManager().dropIndex(oIndex.getName());
        }
        return this;
    }

    @Deprecated
    public void dropIndexesInternal() {
        this.dropIndexes();
    }

    @Override
    @Deprecated
    public Set<OIndex<?>> getIndex() {
        Set<OIndex<?>> indexes = this.owner.getInvolvedIndexes(this.name);
        if (indexes != null) {
            indexes.iterator().next();
        }
        return null;
    }

    @Override
    @Deprecated
    public Set<OIndex<?>> getIndexes() {
        return this.owner.getInvolvedIndexes(this.name);
    }

    @Override
    @Deprecated
    public boolean isIndexed() {
        return this.owner.areIndexed(this.name);
    }

    public OClass getOwnerClass() {
        return this.owner;
    }

    @Override
    public OProperty setName(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s name %s", this.getFullName(), iName);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.name = iName;
        return this;
    }

    public void setNameInternal(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.name = iName;
    }

    @Override
    public OClass getLinkedClass() {
        if (this.linkedClass == null && this.linkedClassName != null) {
            this.linkedClass = this.owner.owner.getClass(this.linkedClassName);
        }
        return this.linkedClass;
    }

    public OPropertyImpl setLinkedClass(OClass iLinkedClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s linkedclass %s", this.getFullName(), iLinkedClass);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.linkedClass = iLinkedClass;
        return this;
    }

    public void setLinkedClassInternal(OClass iLinkedClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.linkedClass = iLinkedClass;
    }

    @Override
    public OType getLinkedType() {
        return this.linkedType;
    }

    public OPropertyImpl setLinkedType(OType iLinkedType) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s linkedtype %s", new Object[]{this.getFullName(), iLinkedType});
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.linkedType = iLinkedType;
        return this;
    }

    public void setLinkedTypeInternal(OType iLinkedType) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.linkedType = iLinkedType;
    }

    @Override
    public boolean isNotNull() {
        return this.notNull;
    }

    @Override
    public OPropertyImpl setNotNull(boolean iNotNull) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s notnull %s", this.getFullName(), iNotNull);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.notNull = iNotNull;
        return this;
    }

    public void setNotNullInternal(boolean iNotNull) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.notNull = iNotNull;
    }

    @Override
    public boolean isMandatory() {
        return this.mandatory;
    }

    @Override
    public OPropertyImpl setMandatory(boolean iMandatory) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s mandatory %s", this.getFullName(), iMandatory);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.mandatory = iMandatory;
        return this;
    }

    public void setMandatoryInternal(boolean iMandatory) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.mandatory = iMandatory;
    }

    @Override
    public String getMin() {
        return this.min;
    }

    @Override
    public OPropertyImpl setMin(String iMin) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s min %s", this.getFullName(), iMin);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.min = iMin;
        this.checkForDateFormat(iMin);
        return this;
    }

    public void setMinInternal(String iMin) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.min = iMin;
        this.checkForDateFormat(iMin);
    }

    @Override
    public String getMax() {
        return this.max;
    }

    @Override
    public OPropertyImpl setMax(String iMax) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s max %s", this.getFullName(), iMax);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.max = iMax;
        this.checkForDateFormat(iMax);
        return this;
    }

    public void setMaxInternal(String iMax) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.max = iMax;
        this.checkForDateFormat(iMax);
    }

    @Override
    public String getRegexp() {
        return this.regexp;
    }

    @Override
    public OPropertyImpl setRegexp(String iRegexp) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s regexp %s", this.getFullName(), iRegexp);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.regexp = iRegexp;
        return this;
    }

    public void setRegexpInternal(String iRegexp) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.regexp = iRegexp;
    }

    @Override
    public OPropertyImpl setType(OType iType) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter property %s type %s", this.getFullName(), iType.toString());
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.type = iType;
        return this;
    }

    public void setTypeInternal(OType iType) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        if (iType == this.type) {
            return;
        }
        boolean ok = false;
        switch (this.type) {
            case LINKLIST: {
                ok = iType == OType.LINKSET;
                break;
            }
            case LINKSET: {
                boolean bl = ok = iType == OType.LINKLIST;
            }
        }
        if (!ok) {
            throw new IllegalArgumentException("Cannot change property type from " + (Object)((Object)this.type) + " to " + (Object)((Object)iType));
        }
        this.type = iType;
    }

    @Override
    public Object get(OProperty.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case LINKEDCLASS: {
                return this.getLinkedClass();
            }
            case LINKEDTYPE: {
                return this.getLinkedType();
            }
            case MIN: {
                return this.getMin();
            }
            case MANDATORY: {
                return this.isMandatory();
            }
            case MAX: {
                return this.getMax();
            }
            case NAME: {
                return this.getName();
            }
            case NOTNULL: {
                return this.isNotNull();
            }
            case REGEXP: {
                return this.getRegexp();
            }
            case TYPE: {
                return this.getType();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    public void setInternalAndSave(OProperty.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case LINKEDCLASS: {
                this.setLinkedClassInternal(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case LINKEDTYPE: {
                this.setLinkedTypeInternal(OType.valueOf(stringValue));
                break;
            }
            case MIN: {
                this.setMinInternal(stringValue);
                break;
            }
            case MANDATORY: {
                this.setMandatoryInternal(Boolean.parseBoolean(stringValue));
                break;
            }
            case MAX: {
                this.setMaxInternal(stringValue);
                break;
            }
            case NAME: {
                this.setNameInternal(stringValue);
                break;
            }
            case NOTNULL: {
                this.setNotNullInternal(Boolean.parseBoolean(stringValue));
                break;
            }
            case REGEXP: {
                this.setRegexpInternal(stringValue);
                break;
            }
            case TYPE: {
                this.setTypeInternal(OType.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
            }
        }
        try {
            this.saveInternal();
        }
        catch (Exception e) {
            this.owner.reload();
        }
    }

    @Override
    public void set(OProperty.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case LINKEDCLASS: {
                this.setLinkedClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case LINKEDTYPE: {
                this.setLinkedType(OType.valueOf(stringValue));
                break;
            }
            case MIN: {
                this.setMin(stringValue);
                break;
            }
            case MANDATORY: {
                this.setMandatory(Boolean.parseBoolean(stringValue));
                break;
            }
            case MAX: {
                this.setMax(stringValue);
                break;
            }
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case NOTNULL: {
                this.setNotNull(Boolean.parseBoolean(stringValue));
                break;
            }
            case REGEXP: {
                this.setRegexp(stringValue);
                break;
            }
            case TYPE: {
                this.setType(OType.valueOf(stringValue.toUpperCase(Locale.ENGLISH)));
            }
        }
    }

    @Override
    public String toString() {
        return this.name + " (type=" + (Object)((Object)this.type) + ")";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OPropertyImpl other = (OPropertyImpl)obj;
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    @Override
    public void fromStream() {
        this.name = (String)this.document.field("name");
        if (this.document.field("type") != null) {
            this.type = OType.getById(((Integer)this.document.field("type")).byteValue());
        }
        this.mandatory = (Boolean)this.document.field("mandatory");
        this.notNull = (Boolean)this.document.field("notNull");
        this.min = (String)this.document.field("min");
        this.max = (String)this.document.field("max");
        this.regexp = (String)this.document.field("regexp");
        this.linkedClassName = (String)this.document.field("linkedClass");
        if (this.document.field("linkedType") != null) {
            this.linkedType = OType.getById(((Integer)this.document.field("linkedType")).byteValue());
        }
    }

    @Override
    public Collection<OIndex<?>> getAllIndexes() {
        Set<OIndex<?>> indexes = this.owner.getIndexes();
        LinkedList indexList = new LinkedList();
        for (OIndex<?> index : indexes) {
            OIndexDefinition indexDefinition = index.getDefinition();
            if (!indexDefinition.getFields().contains(this.name)) continue;
            indexList.add(index);
        }
        return indexList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("type", this.type.id);
            this.document.field("mandatory", this.mandatory);
            this.document.field("notNull", this.notNull);
            this.document.field("min", this.min);
            this.document.field("max", this.max);
            this.document.field("regexp", this.regexp);
            this.document.field("linkedClass", this.linkedClass != null ? this.linkedClass.getName() : this.linkedClassName);
            this.document.field("linkedType", this.linkedType != null ? Integer.valueOf(this.linkedType.id) : null);
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    public void saveInternal() {
        if (this.getDatabase().getStorage() instanceof OStorageEmbedded) {
            ((OSchemaProxy)this.getDatabase().getMetadata().getSchema()).saveInternal();
        }
    }

    private void checkForDateFormat(String iDateAsString) {
        if (iDateAsString != null) {
            if (this.type == OType.DATE) {
                try {
                    this.owner.owner.getDocument().getDatabase().getStorage().getConfiguration().getDateFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw new OSchemaException("Invalid date format", e);
                }
            }
            if (this.type == OType.DATETIME) {
                try {
                    this.owner.owner.getDocument().getDatabase().getStorage().getConfiguration().getDateTimeFormatInstance().parse(iDateAsString);
                }
                catch (ParseException e) {
                    throw new OSchemaException("Invalid datetime format", e);
                }
            }
        }
    }

    protected ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }
}

