/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.metadata.schema;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.util.OArrays;
import com.orientechnologies.orient.core.annotation.OBeforeSerialization;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OSchemaException;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexManagerProxy;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyListIndexDefinition;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.schema.OSchemaShared;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.type.ODocumentWrapperNoClass;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClassImpl
extends ODocumentWrapperNoClass
implements OClass {
    protected OSchemaShared owner;
    protected String name;
    protected Class<?> javaClass;
    protected final Map<String, OProperty> properties = new HashMap<String, OProperty>();
    protected int[] clusterIds;
    protected int defaultClusterId;
    protected OClassImpl superClass;
    protected int[] polymorphicClusterIds;
    protected List<OClass> baseClasses;
    protected float overSize = 0.0f;
    protected String shortName;
    protected boolean strictMode = false;

    public OClassImpl() {
    }

    protected OClassImpl(OSchemaShared iOwner) {
        this.document = new ODocument();
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, ODocument iDocument) {
        this.document = iDocument;
        this.owner = iOwner;
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, String iJavaClassName, int[] iClusterIds) throws ClassNotFoundException {
        this(iOwner, iName, iClusterIds);
        this.javaClass = Class.forName(iJavaClassName);
    }

    protected OClassImpl(OSchemaShared iOwner, String iName, int[] iClusterIds) {
        this(iOwner);
        this.name = iName;
        this.setClusterIds(iClusterIds);
        this.setPolymorphicClusterIds(iClusterIds);
        this.defaultClusterId = iClusterIds[0];
    }

    @Override
    public <T> T newInstance() throws InstantiationException, IllegalAccessException {
        if (this.javaClass == null) {
            throw new IllegalArgumentException("Cannot create an instance of class '" + this.name + "' since no Java class was specified");
        }
        return (T)this.javaClass.newInstance();
    }

    public void validateInstances() {
        ODatabaseComplex current;
        for (current = this.getDatabase().getDatabaseOwner(); current != null && current.getUnderlying() instanceof ODatabaseComplex && !(current instanceof ODatabaseDocumentTx); current = (ODatabaseComplex)current.getUnderlying()) {
        }
        for (ODocument d : ((ODatabaseDocumentTx)current).browseClass(this.name, true)) {
            d.validate();
        }
    }

    @Override
    public OClass getSuperClass() {
        return this.superClass;
    }

    @Override
    public OClass setSuperClass(OClass iSuperClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s superclass %s", this.name, iSuperClass.getName());
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setSuperClassInternal(iSuperClass);
        return this;
    }

    public void setSuperClassInternal(OClass iSuperClass) {
        this.superClass = (OClassImpl)iSuperClass;
        this.superClass.addBaseClasses(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public OClass setName(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s name %s", this.name, iName);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.name = iName;
        return this;
    }

    public void setNameInternal(String iName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.owner.changeClassName(this.name, iName);
        this.name = iName;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public OClass setShortName(String iShortName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s shortname %s", this.name, iShortName);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setShortNameInternal(iShortName);
        return this;
    }

    public void setShortNameInternal(String shortName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        if (this.shortName != null) {
            this.owner.classes.remove(shortName);
        }
        this.shortName = shortName;
        this.owner.classes.put(shortName.toLowerCase(), this);
    }

    @Override
    public String getStreamableName() {
        return this.shortName != null ? this.shortName : this.name;
    }

    @Override
    public Collection<OProperty> declaredProperties() {
        return Collections.unmodifiableCollection(this.properties.values());
    }

    @Override
    public Collection<OProperty> properties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        ArrayList<OProperty> props = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            if (props == null) {
                props = new ArrayList<OProperty>();
            }
            props.addAll(currentClass.properties.values());
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return props != null ? props : Collections.emptyList();
    }

    @Override
    public Collection<OProperty> getIndexedProperties() {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_READ);
        List<OProperty> indexedProps = null;
        OClassImpl currentClass = this;
        do {
            if (currentClass.properties == null) continue;
            for (OProperty p : currentClass.properties.values()) {
                if (!this.areIndexed(p.getName())) continue;
                if (indexedProps == null) {
                    indexedProps = new ArrayList<OProperty>();
                }
                indexedProps.add(p);
            }
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return indexedProps != null ? indexedProps : Collections.emptyList();
    }

    @Override
    public OProperty getProperty(String iPropertyName) {
        OClassImpl currentClass = this;
        OProperty p = null;
        do {
            if (currentClass.properties != null) {
                p = currentClass.properties.get(iPropertyName.toLowerCase());
            }
            if (p == null) continue;
            return p;
        } while ((currentClass = (OClassImpl)currentClass.getSuperClass()) != null);
        return p;
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType) {
        return this.addProperty(iPropertyName, iType, null, null);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OClass iLinkedClass) {
        if (iLinkedClass == null) {
            throw new OSchemaException("Missing linked class");
        }
        return this.addProperty(iPropertyName, iType, null, iLinkedClass);
    }

    @Override
    public OProperty createProperty(String iPropertyName, OType iType, OType iLinkedType) {
        return this.addProperty(iPropertyName, iType, iLinkedType, null);
    }

    @Override
    public boolean existsProperty(String iPropertyName) {
        return this.properties.containsKey(iPropertyName.toLowerCase());
    }

    @Override
    public void dropProperty(String iPropertyName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        String lowerName = iPropertyName.toLowerCase();
        if (!this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
        StringBuilder cmd = new StringBuilder("drop property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            this.properties.remove(lowerName);
        }
    }

    public void dropPropertyInternal(String iPropertyName) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_DELETE);
        OProperty prop = this.properties.remove(iPropertyName.toLowerCase());
        if (prop == null) {
            throw new OSchemaException("Property '" + iPropertyName + "' not found in class " + this.name + "'");
        }
    }

    public OProperty addProperty(String iPropertyName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String lowerName = iPropertyName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has property '" + iPropertyName + "'");
        }
        StringBuilder cmd = new StringBuilder("create property ");
        cmd.append(this.name);
        cmd.append('.');
        cmd.append(iPropertyName);
        cmd.append(' ');
        cmd.append(iType.name);
        if (iLinkedType != null) {
            cmd.append(' ');
            cmd.append(iLinkedType.name);
        } else if (iLinkedClass != null) {
            cmd.append(' ');
            cmd.append(iLinkedClass.getName());
        }
        this.getDatabase().command(new OCommandSQL(cmd.toString())).execute(new Object[0]);
        if (this.existsProperty(iPropertyName)) {
            return this.properties.get(lowerName);
        }
        return this.addPropertyInternal(iPropertyName, iType, iLinkedType, iLinkedClass);
    }

    @Override
    public void fromStream() {
        Object cc;
        this.name = (String)this.document.field("name");
        this.shortName = (String)this.document.field("shortName");
        this.defaultClusterId = (Integer)this.document.field("defaultClusterId");
        if (this.document.containsField("strictMode")) {
            this.strictMode = (Boolean)this.document.field("strictMode");
        }
        if (this.document.field("overSize") != null) {
            this.overSize = ((Float)this.document.field("overSize")).floatValue();
        }
        if ((cc = this.document.field("clusterIds")) instanceof Collection) {
            Collection coll = (Collection)this.document.field("clusterIds");
            this.clusterIds = new int[coll.size()];
            int i = 0;
            for (Integer item : coll) {
                this.clusterIds[i++] = item;
            }
        } else {
            this.clusterIds = (int[])cc;
        }
        Arrays.sort(this.clusterIds);
        this.setPolymorphicClusterIds(this.clusterIds);
        Collection storedProperties = (Collection)this.document.field("properties");
        for (ODocument p : storedProperties) {
            OPropertyImpl prop = new OPropertyImpl(this, p);
            prop.fromStream();
            this.properties.put(prop.getName().toLowerCase(), prop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @OBeforeSerialization
    public ODocument toStream() {
        this.document.setInternalStatus(ORecordElement.STATUS.UNMARSHALLING);
        try {
            this.document.field("name", this.name);
            this.document.field("shortName", this.shortName);
            this.document.field("defaultClusterId", this.defaultClusterId);
            this.document.field("clusterIds", this.clusterIds);
            this.document.field("overSize", Float.valueOf(this.overSize));
            this.document.field("strictMode", this.strictMode);
            HashSet<ODocument> props = new HashSet<ODocument>();
            for (OProperty p : this.properties.values()) {
                props.add(((OPropertyImpl)p).toStream());
            }
            this.document.field("properties", props, OType.EMBEDDEDSET);
            if (this.superClass != null) {
                this.document.field("superClass", this.superClass.getName());
            }
        }
        finally {
            this.document.setInternalStatus(ORecordElement.STATUS.LOADED);
        }
        return this.document;
    }

    @Override
    public Class<?> getJavaClass() {
        return this.javaClass;
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public void setDefaultClusterId(int iDefaultClusterId) {
        this.defaultClusterId = iDefaultClusterId;
        this.setDirty();
    }

    @Override
    public int[] getClusterIds() {
        return this.clusterIds;
    }

    @Override
    public int[] getPolymorphicClusterIds() {
        return this.polymorphicClusterIds;
    }

    @Override
    public OClass addClusterId(int iId) {
        for (int currId : this.clusterIds) {
            if (currId != iId) continue;
            return this;
        }
        this.clusterIds = OArrays.copyOf(this.clusterIds, this.clusterIds.length + 1);
        this.clusterIds[this.clusterIds.length - 1] = iId;
        Arrays.sort(this.clusterIds);
        this.setDirty();
        return this;
    }

    @Override
    public OClass removeClusterId(int iId) {
        boolean found = false;
        for (int clusterId : this.clusterIds) {
            if (clusterId != iId) continue;
            found = true;
            break;
        }
        if (found) {
            int[] newClusterIds = new int[this.clusterIds.length - 1];
            int k = 0;
            for (int i = 0; i < this.clusterIds.length; ++i) {
                if (this.clusterIds[i] == iId) continue;
                newClusterIds[k] = this.clusterIds[i];
                ++k;
            }
        }
        return this;
    }

    public OClass setDirty() {
        this.document.setDirty();
        if (this.owner != null) {
            this.owner.setDirty();
        }
        return this;
    }

    @Override
    public Iterator<OClass> getBaseClasses() {
        if (this.baseClasses == null || this.baseClasses.size() == 0) {
            return null;
        }
        return this.baseClasses.iterator();
    }

    private OClass addBaseClasses(OClass iBaseClass) {
        if (this.baseClasses == null) {
            this.baseClasses = new ArrayList<OClass>();
        }
        if (this.baseClasses.contains(iBaseClass)) {
            return this;
        }
        this.baseClasses.add(iBaseClass);
        for (OClassImpl currentClass = this; currentClass != null; currentClass = (OClassImpl)currentClass.getSuperClass()) {
            currentClass.addPolymorphicClusterIds((OClassImpl)iBaseClass);
        }
        return this;
    }

    @Override
    public float getOverSize() {
        if (this.overSize > 0.0f) {
            return this.overSize;
        }
        if (this.superClass != null) {
            return this.superClass.getOverSize();
        }
        return 0.0f;
    }

    @Override
    public OClass setOverSize(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s oversize %f", this.name, Float.valueOf(overSize));
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setOverSizeInternal(overSize);
        return this;
    }

    public void setOverSizeInternal(float overSize) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.overSize = overSize;
    }

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    @Override
    public OClass setStrictMode(boolean iStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        String cmd = String.format("alter class %s strictmode %s", this.name, iStrict);
        this.getDatabase().command(new OCommandSQL(cmd)).execute(new Object[0]);
        this.setStrictModeInternal(iStrict);
        return this;
    }

    public void setStrictModeInternal(boolean iStrict) {
        this.getDatabase().checkSecurity("database.schema", ORole.PERMISSION_UPDATE);
        this.strictMode = iStrict;
    }

    @Override
    public String toString() {
        return this.name;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owner == null ? 0 : this.owner.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OClassImpl other = (OClassImpl)obj;
        return !(this.owner == null ? other.owner != null : !this.owner.equals(other.owner));
    }

    @Override
    public int compareTo(OClass o) {
        return this.name.compareTo(o.getName());
    }

    @Override
    public long count() {
        return this.count(true);
    }

    @Override
    public long count(boolean iPolymorphic) {
        if (iPolymorphic) {
            return this.getDatabase().countClusterElements(this.polymorphicClusterIds);
        }
        return this.getDatabase().countClusterElements(this.clusterIds);
    }

    private ODatabaseRecord getDatabase() {
        return ODatabaseRecordThreadLocal.INSTANCE.get();
    }

    @Override
    public void truncate() throws IOException {
        for (int id : this.clusterIds) {
            this.getDatabase().getStorage().getClusterById(id).truncate();
        }
    }

    @Override
    public boolean isSubClassOf(String iClassName) {
        return this.isSubClassOf(this.owner.getClass(iClassName));
    }

    @Override
    public boolean isSubClassOf(OClass iClass) {
        if (iClass == null) {
            return false;
        }
        for (OClass cls = this; cls != null; cls = cls.getSuperClass()) {
            if (!cls.getName().equals(iClass.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSuperClassOf(OClass iClass) {
        for (OClass cls = iClass; cls != null; cls = cls.getSuperClass()) {
            if (!cls.getName().equals(this.name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object get(OClass.ATTRIBUTES iAttribute) {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        switch (iAttribute) {
            case NAME: {
                return this.getName();
            }
            case SHORTNAME: {
                return this.getShortName();
            }
            case SUPERCLASS: {
                return this.getSuperClass();
            }
            case OVERSIZE: {
                return Float.valueOf(this.getOverSize());
            }
            case STRICTMODE: {
                return this.isStrictMode();
            }
        }
        throw new IllegalArgumentException("Cannot find attribute '" + (Object)((Object)iAttribute) + "'");
    }

    public void setInternalAndSave(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case NAME: {
                this.setNameInternal(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortNameInternal(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClassInternal(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSizeInternal(Float.parseFloat(stringValue.replace(',', '.')));
                break;
            }
            case STRICTMODE: {
                this.setStrictModeInternal(Boolean.parseBoolean(stringValue));
            }
        }
        this.saveInternal();
    }

    @Override
    public OClass set(OClass.ATTRIBUTES attribute, Object iValue) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (attribute) {
            case NAME: {
                this.setName(stringValue);
                break;
            }
            case SHORTNAME: {
                this.setShortName(stringValue);
                break;
            }
            case SUPERCLASS: {
                this.setSuperClass(this.getDatabase().getMetadata().getSchema().getClass(stringValue));
                break;
            }
            case OVERSIZE: {
                this.setOverSize(Float.parseFloat(stringValue));
                break;
            }
            case STRICTMODE: {
                this.setStrictMode(Boolean.parseBoolean(stringValue));
            }
        }
        return this;
    }

    private void addPolymorphicClusterIds(OClassImpl iBaseClass) {
        for (int i : iBaseClass.polymorphicClusterIds) {
            boolean found = false;
            for (int k : this.clusterIds) {
                if (i != k) continue;
                found = true;
                break;
            }
            if (found) continue;
            this.polymorphicClusterIds = OArrays.copyOf(this.polymorphicClusterIds, this.polymorphicClusterIds.length + 1);
            this.polymorphicClusterIds[this.polymorphicClusterIds.length - 1] = i;
            Arrays.sort(this.polymorphicClusterIds);
        }
    }

    public OPropertyImpl addPropertyInternal(String iName, OType iType, OType iLinkedType, OClass iLinkedClass) {
        if (iName == null || iName.length() == 0) {
            throw new OSchemaException("Found property name null");
        }
        Character wrongCharacter = OSchemaShared.checkNameIfValid(iName);
        if (wrongCharacter != null) {
            throw new OSchemaException("Invalid property name found. Character '" + wrongCharacter + "' cannot be used in property name.");
        }
        String lowerName = iName.toLowerCase();
        if (this.properties.containsKey(lowerName)) {
            throw new OSchemaException("Class " + this.name + " already has property '" + iName + "'");
        }
        OPropertyImpl prop = new OPropertyImpl(this, iName, iType);
        this.properties.put(lowerName, prop);
        if (iLinkedType != null) {
            prop.setLinkedTypeInternal(iLinkedType);
        } else if (iLinkedClass != null) {
            prop.setLinkedClassInternal(iLinkedClass);
        }
        return prop;
    }

    public void saveInternal() {
        this.owner.saveInternal();
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, String ... fields) {
        return this.createIndex(iName, iType, (OProgressListener)null, fields);
    }

    @Override
    public OIndex<?> createIndex(String iName, OClass.INDEX_TYPE iType, OProgressListener iProgressListener, String ... fields) {
        if (!(OClass.INDEX_TYPE.DICTIONARY.equals((Object)iType) || OClass.INDEX_TYPE.FULLTEXT.equals((Object)iType) || OClass.INDEX_TYPE.NOTUNIQUE.equals((Object)iType) || OClass.INDEX_TYPE.UNIQUE.equals((Object)iType))) {
            throw new OIndexException("Index of this type (" + (Object)((Object)iType) + ") cannot be used in class indexes.");
        }
        if (fields.length == 0) {
            throw new OIndexException("List of fields to index cannot be empty.");
        }
        if (fields.length > 1 && OClass.INDEX_TYPE.FULLTEXT.equals((Object)iType)) {
            throw new OIndexException((Object)((Object)OClass.INDEX_TYPE.FULLTEXT) + " indexes cannot be used as composite ones.");
        }
        Set<String> existingFieldNames = this.properties.keySet();
        LinkedList<String> fieldsToIndex = new LinkedList<String>();
        for (String fieldToIndex : fields) {
            String fieldName = this.extractFieldName(fieldToIndex);
            if (!existingFieldNames.contains(fieldName.toLowerCase())) {
                throw new OIndexException("Index with name : '" + iName + "' cannot be created on class : '" + this.name + "' because field: '" + fieldName + "' is absent in class definition.");
            }
            fieldsToIndex.add(fieldName);
        }
        OIndexDefinition indexDefinition = fieldsToIndex.size() == 1 ? this.createSingleFieldIndexDefinition(fields[0]) : this.createMultipleFieldIndexDefinition(fieldsToIndex);
        OIndex<?> index = this.getDatabase().getMetadata().getIndexManager().createIndex(iName, iType.toString(), indexDefinition, this.clusterIds, iProgressListener);
        return index;
    }

    private OIndexDefinition createMultipleFieldIndexDefinition(List<String> fieldsToIndex) {
        OCompositeIndexDefinition compositeIndex = new OCompositeIndexDefinition(this.name);
        for (String fieldName : fieldsToIndex) {
            OProperty propertyToIndex = this.properties.get(fieldName.toLowerCase());
            OType propertyType = propertyToIndex.getType();
            if (propertyType.equals((Object)OType.EMBEDDEDLIST) || propertyType.equals((Object)OType.EMBEDDEDSET) || propertyType.equals((Object)OType.LINKSET) || propertyType.equals((Object)OType.LINKSET) || propertyType.equals((Object)OType.EMBEDDEDMAP) || propertyType.equals((Object)OType.LINKMAP)) {
                throw new OIndexException("Collections are not supported in composite indexes");
            }
            OPropertyIndexDefinition propertyIndex = new OPropertyIndexDefinition(this.name, propertyToIndex.getName(), propertyType);
            compositeIndex.addIndex(propertyIndex);
        }
        OCompositeIndexDefinition indexDefinition = compositeIndex;
        return indexDefinition;
    }

    private OIndexDefinition createSingleFieldIndexDefinition(String field) {
        OPropertyIndexDefinition indexDefinition;
        String fieldName = this.extractFieldName(field);
        OProperty propertyToIndex = this.properties.get(fieldName.toLowerCase());
        OType propertyToIndexType = propertyToIndex.getType();
        if (propertyToIndexType == OType.EMBEDDEDMAP || propertyToIndexType == OType.LINKMAP) {
            OType indexType;
            OPropertyMapIndexDefinition.INDEX_BY indexBy = this.extractMapIndexSpecifier(field);
            if (indexBy.equals((Object)OPropertyMapIndexDefinition.INDEX_BY.KEY)) {
                indexType = OType.STRING;
            } else if (propertyToIndexType == OType.LINKMAP) {
                indexType = OType.LINK;
            } else {
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyMapIndexDefinition(this.name, propertyToIndex.getName(), indexType, indexBy);
        } else if (propertyToIndexType.equals((Object)OType.EMBEDDEDLIST) || propertyToIndexType.equals((Object)OType.EMBEDDEDSET) || propertyToIndexType.equals((Object)OType.LINKLIST) || propertyToIndexType.equals((Object)OType.LINKSET)) {
            OType indexType;
            if (propertyToIndexType.equals((Object)OType.LINKLIST) || propertyToIndexType.equals((Object)OType.LINKSET)) {
                indexType = OType.LINK;
            } else {
                indexType = propertyToIndex.getLinkedType();
                if (indexType == null) {
                    throw new OIndexException("Linked type was not provided. You should provide linked type for embedded collections that are going to be indexed.");
                }
            }
            indexDefinition = new OPropertyListIndexDefinition(this.name, propertyToIndex.getName(), indexType);
        } else {
            indexDefinition = new OPropertyIndexDefinition(this.name, propertyToIndex.getName(), propertyToIndexType);
        }
        return indexDefinition;
    }

    @Override
    public boolean areIndexed(String ... fields) {
        return this.areIndexed(Arrays.asList(fields));
    }

    @Override
    public boolean areIndexed(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        boolean currentClassResult = indexManager.areIndexed(this.name, fields);
        if (this.superClass != null) {
            return currentClassResult || this.superClass.areIndexed(fields);
        }
        return currentClassResult;
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(String ... fields) {
        return this.getInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public Set<OIndex<?>> getInvolvedIndexes(Collection<String> fields) {
        HashSet result = new HashSet(this.getClassInvolvedIndexes(fields));
        if (this.superClass != null) {
            result.addAll(this.superClass.getInvolvedIndexes(fields));
        }
        return result;
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(Collection<String> fields) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassInvolvedIndexes(this.name, fields);
    }

    @Override
    public Set<OIndex<?>> getClassInvolvedIndexes(String ... fields) {
        return this.getClassInvolvedIndexes(Arrays.asList(fields));
    }

    @Override
    public OIndex<?> getClassIndex(String iName) {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassIndex(this.name, iName);
    }

    @Override
    public Set<OIndex<?>> getClassIndexes() {
        OIndexManagerProxy indexManager = this.getDatabase().getMetadata().getIndexManager();
        return indexManager.getClassIndexes(this.name);
    }

    @Override
    public Set<OIndex<?>> getIndexes() {
        Set<OIndex<?>> indexes = this.getClassIndexes();
        if (this.superClass == null) {
            return indexes;
        }
        HashSet result = new HashSet(indexes);
        result.addAll(this.superClass.getIndexes());
        return result;
    }

    private String extractFieldName(String fieldName) {
        String[] fieldNameParts = fieldName.split("\\s+");
        if (fieldNameParts.length == 1) {
            return fieldName;
        }
        if (fieldNameParts.length == 3) {
            return fieldNameParts[0];
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'");
    }

    private OPropertyMapIndexDefinition.INDEX_BY extractMapIndexSpecifier(String fieldName) {
        String[] fieldNameParts = fieldName.split("\\s+");
        if (fieldNameParts.length == 1) {
            return OPropertyMapIndexDefinition.INDEX_BY.KEY;
        }
        if (fieldNameParts.length == 3 && "by".equals(fieldNameParts[1].toLowerCase())) {
            try {
                return OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'");
            }
        }
        throw new IllegalArgumentException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'");
    }

    private void setPolymorphicClusterIds(int[] iClusterIds) {
        this.polymorphicClusterIds = iClusterIds;
        Arrays.sort(this.polymorphicClusterIds);
    }

    private OClass setClusterIds(int[] iClusterIds) {
        this.clusterIds = iClusterIds;
        Arrays.sort(this.clusterIds);
        return this;
    }
}

