/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.iterator;

import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.record.ORecordInternal;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordIteratorCluster<REC extends ORecordInternal<?>>
extends OIdentifiableIterator<REC> {
    protected long rangeFrom;
    protected long rangeTo;

    public ORecordIteratorCluster(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int iClusterId) {
        this(iDatabase, iLowLevelDatabase, iClusterId, -1L, -1L);
    }

    public ORecordIteratorCluster(ODatabaseRecord iDatabase, ODatabaseRecordAbstract iLowLevelDatabase, int iClusterId, long iRangeFrom, long iRangeTo) {
        super(iDatabase, iLowLevelDatabase);
        if (iClusterId == -1) {
            throw new IllegalArgumentException("The clusterId is invalid");
        }
        this.current.clusterId = iClusterId;
        this.rangeFrom = iRangeFrom > -1L ? iRangeFrom - 1L : iRangeFrom;
        this.rangeTo = iRangeTo;
        long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
        this.firstClusterPosition = range[0];
        this.lastClusterPosition = this.rangeTo > -1L ? Math.min(this.rangeTo, range[1]) : range[1];
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId);
        this.txEntries = iDatabase.getTransaction().getRecordEntriesByClusterIds(new int[]{iClusterId});
        if (this.txEntries != null) {
            for (ORecordOperation entry : this.txEntries) {
                switch (entry.type) {
                    case 3: {
                        ++this.totalAvailableRecords;
                        break;
                    }
                    case 2: {
                        --this.totalAvailableRecords;
                    }
                }
            }
        }
        this.begin();
    }

    @Override
    public boolean hasPrevious() {
        this.checkDirection(false);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        return this.current.clusterPosition > this.getRangeFrom() + 1L;
    }

    @Override
    public boolean hasNext() {
        long recordsToBrowse;
        this.checkDirection(true);
        if (this.limit > -1L && this.browsedRecords >= this.limit) {
            return false;
        }
        if (this.browsedRecords >= this.totalAvailableRecords) {
            return false;
        }
        if (this.liveUpdated) {
            this.lastClusterPosition = this.getRangeTo();
        }
        long l = recordsToBrowse = this.current.clusterPosition > -2L && this.lastClusterPosition > -1L ? this.lastClusterPosition - this.current.clusterPosition : 0L;
        if (recordsToBrowse > 0L) {
            return true;
        }
        if (this.txEntries != null) {
            recordsToBrowse += (long)(this.txEntries.size() - (this.currentTxEntryPosition + 1));
        }
        return recordsToBrowse > 0L;
    }

    public REC previous() {
        this.checkDirection(false);
        ORecordInternal<?> record = this.getRecord();
        while (this.hasPrevious()) {
            if ((record = this.readCurrentRecord(record, -1)) == null) continue;
            return (REC)record;
        }
        throw new NoSuchElementException();
    }

    @Override
    public REC next() {
        this.checkDirection(true);
        ORecordInternal<?> record = this.getRecord();
        while (this.hasNext()) {
            record = this.getTransactionEntry();
            if (record != null) {
                return (REC)record;
            }
            record = this.readCurrentRecord(null, 1);
            if (record == null) continue;
            return (REC)record;
        }
        throw new NoSuchElementException();
    }

    @Override
    public ORecordInternal<?> current() {
        return this.readCurrentRecord(this.getRecord(), 0);
    }

    @Override
    public ORecordIteratorCluster<REC> begin() {
        this.current.clusterPosition = this.getRangeFrom();
        return this;
    }

    @Override
    public ORecordIteratorCluster<REC> last() {
        this.current.clusterPosition = this.getRangeTo();
        return this;
    }

    public ORecordIteratorCluster<REC> setRange(long iFrom, long iEnd) {
        this.firstClusterPosition = iFrom;
        this.rangeTo = iEnd;
        this.current.clusterPosition = this.firstClusterPosition;
        return this;
    }

    public long getRangeFrom() {
        long limit = (this.liveUpdated ? this.database.getStorage().getClusterDataRange(this.current.clusterId)[1] : this.firstClusterPosition) - 1L;
        if (this.rangeFrom > -1L) {
            return Math.max(this.rangeFrom, limit);
        }
        return limit;
    }

    public long getRangeTo() {
        long limit = (this.liveUpdated ? this.database.getStorage().getClusterDataRange(this.current.clusterId)[1] : this.lastClusterPosition) + 1L;
        if (this.rangeTo > -1L) {
            return Math.min(this.rangeTo, limit);
        }
        return limit;
    }

    @Override
    public ORecordIteratorCluster<REC> setLiveUpdated(boolean iLiveUpdated) {
        super.setLiveUpdated(iLiveUpdated);
        if (iLiveUpdated) {
            this.firstClusterPosition = -1L;
            this.lastClusterPosition = -1L;
        } else {
            long[] range = this.database.getStorage().getClusterDataRange(this.current.clusterId);
            this.firstClusterPosition = range[0];
            this.lastClusterPosition = range[1];
        }
        this.totalAvailableRecords = this.database.countClusterElements(this.current.clusterId);
        return this;
    }
}

